/*
 * Decompiled with CFR 0.152.
 */
package com.meituan.sqt.utils;

import com.meituan.sqt.enums.EncryptionAlgorithmEnum;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptUtil {
    private EncryptUtil() {
    }

    public static String encrypt(EncryptionAlgorithmEnum algorithm, String plainText, String secretKey, String iv) throws Exception {
        SecretKey key = EncryptUtil.buildSecretKey(algorithm, secretKey);
        AlgorithmParameterSpec params = EncryptUtil.buildIvSpec(algorithm, iv);
        Cipher cipher = Cipher.getInstance(algorithm.getAlgorithmKey());
        if (Objects.nonNull(params)) {
            cipher.init(1, (Key)key, params);
        } else {
            cipher.init(1, key);
        }
        byte[] cipherText = cipher.doFinal(plainText.getBytes());
        return java.util.Base64.getUrlEncoder().withoutPadding().encodeToString(cipherText);
    }

    public static String decrypt(EncryptionAlgorithmEnum algorithm, String encryptedText, String secretKey, String iv) throws Exception {
        SecretKey key = EncryptUtil.buildSecretKey(algorithm, secretKey);
        AlgorithmParameterSpec params = EncryptUtil.buildIvSpec(algorithm, iv);
        Cipher cipher = Cipher.getInstance(algorithm.getAlgorithmKey());
        if (Objects.nonNull(params)) {
            cipher.init(2, (Key)key, params);
        } else {
            cipher.init(2, key);
        }
        byte[] plainText = cipher.doFinal(EncryptUtil.base64Decode(encryptedText));
        return new String(plainText);
    }

    private static AlgorithmParameterSpec buildIvSpec(EncryptionAlgorithmEnum algorithm, String iv) {
        if (StringUtils.isBlank((CharSequence)iv)) {
            return null;
        }
        if (EncryptionAlgorithmEnum.ecbMode(algorithm)) {
            return null;
        }
        return Objects.equals((Object)algorithm, (Object)EncryptionAlgorithmEnum.AES_GCM) || Objects.equals((Object)algorithm, (Object)EncryptionAlgorithmEnum.SM4_GCM) ? new GCMParameterSpec(128, java.util.Base64.getDecoder().decode(iv)) : new IvParameterSpec(java.util.Base64.getDecoder().decode(iv));
    }

    private static SecretKey buildSecretKey(EncryptionAlgorithmEnum algorithm, String secretKeyString) {
        return new SecretKeySpec(java.util.Base64.getDecoder().decode(secretKeyString), algorithm.getAlgorithmName());
    }

    private static byte[] base64Decode(String cipherText) {
        try {
            return java.util.Base64.getUrlDecoder().decode(cipherText);
        }
        catch (Exception e) {
            return java.util.Base64.getDecoder().decode(cipherText);
        }
    }

    public static String aesEncrypt(String originText, String secret) throws Exception {
        AesCypher cypher = new AesCypher(secret);
        return cypher.encrypt(originText);
    }

    public static String aesDecrypt(String encryptedText, String secret) throws Exception {
        AesCypher cypher = new AesCypher(secret);
        return cypher.decrypt(encryptedText);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    static class AesCypher {
        private static final Logger LOGGER = LoggerFactory.getLogger(AesCypher.class);
        private byte[] linebreak = new byte[0];
        private SecretKey key;
        private Cipher cipher;
        private Base64 coder;

        public AesCypher(String secret) {
            try {
                this.coder = new Base64(32, this.linebreak, true);
                byte[] secrets = this.coder.decode(secret);
                this.key = new SecretKeySpec(secrets, "AES");
                this.cipher = Cipher.getInstance("AES/ECB/PKCS5Padding", "SunJCE");
            }
            catch (Exception e) {
                LOGGER.error("AesCypher.genKey NoSuchAlgorithmException", (Throwable)e);
            }
        }

        public synchronized String encrypt(String plainText) throws Exception {
            this.cipher.init(1, this.key);
            byte[] cipherText = this.cipher.doFinal(plainText.getBytes("UTF-8"));
            return new String(this.coder.encode(cipherText));
        }

        public synchronized String decrypt(String codedText) throws Exception {
            byte[] encypted = this.coder.decode(codedText.getBytes());
            this.cipher.init(2, this.key);
            byte[] decrypted = this.cipher.doFinal(encypted);
            return new String(decrypted, "UTF-8");
        }
    }
}

