/*
 * Decompiled with CFR 0.152.
 */
package com.meituan.sqt.enums;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public enum EncryptionAlgorithmEnum {
    AES_ECB("AES Electronic Codebook PKCS5Padding", "AES/ECB/PKCS5Padding", "AES", "ECB"),
    AES_CBC("AES Cipher Block Chaining PKCS5Padding", "AES/CBC/PKCS5Padding", "AES", "CBC"),
    AES_GCM("AES Galois/Counter", "AES/GCM/NoPadding", "AES", "GCM"),
    SM4_ECB("SM4 Electronic Codebook PKCS5Padding", "SM4/ECB/PKCS5Padding", "SM4", "ECB"),
    SM4_CBC("SM4 Cipher Block Chaining PKCS5Padding", "SM4/CBC/PKCS5Padding", "SM4", "CBC"),
    SM4_GCM("SM4 Galois/Counter", "SM4/GCM/NoPadding", "SM4", "GCM");

    private String desc;
    private String algorithmKey;
    private String algorithmName;
    private String encryptionMode;

    private EncryptionAlgorithmEnum(String desc, String algorithmKey, String algorithmName, String encryptionMode) {
        this.desc = desc;
        this.algorithmKey = algorithmKey;
        this.algorithmName = algorithmName;
        this.encryptionMode = encryptionMode;
    }

    public static boolean ecbMode(EncryptionAlgorithmEnum encryptionAlgorithmEnum) {
        if (encryptionAlgorithmEnum == null) {
            return false;
        }
        return Objects.equals(encryptionAlgorithmEnum.getEncryptionMode(), "ECB");
    }

    public static boolean gcmMode(EncryptionAlgorithmEnum encryptionAlgorithmEnum) {
        if (encryptionAlgorithmEnum == null) {
            return false;
        }
        return Objects.equals(encryptionAlgorithmEnum.getEncryptionMode(), "GCM");
    }

    public static EncryptionAlgorithmEnum parseAlgorithm(String algorithmName, String encryptionMode) {
        if (StringUtils.isBlank((CharSequence)algorithmName) || StringUtils.isBlank((CharSequence)encryptionMode)) {
            return null;
        }
        for (EncryptionAlgorithmEnum algorithm : EncryptionAlgorithmEnum.values()) {
            if (!algorithm.getAlgorithmName().equalsIgnoreCase(algorithmName) || !algorithm.getEncryptionMode().equalsIgnoreCase(encryptionMode)) continue;
            return algorithm;
        }
        return null;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getAlgorithmKey() {
        return this.algorithmKey;
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public String getEncryptionMode() {
        return this.encryptionMode;
    }
}

