/*
 * Decompiled with CFR 0.152.
 */
package com.meituan.sqt.demo.out.cashier;

import com.meituan.sqt.demo.out.cashier.IThirdCashierService;
import com.meituan.sqt.request.out.ApiRequest;
import com.meituan.sqt.request.out.cashier.StandardCashierCloseOrderRequest;
import com.meituan.sqt.request.out.cashier.StandardCashierCreateOrderRequest;
import com.meituan.sqt.request.out.cashier.StandardCashierPayQueryRequest;
import com.meituan.sqt.request.out.cashier.StandardCashierRefundRequest;
import com.meituan.sqt.response.out.budget.BaseApiResponse;
import com.meituan.sqt.response.out.cashier.StandardCashierCloseOrderResponse;
import com.meituan.sqt.response.out.cashier.StandardCashierCreateOrderResponse;
import com.meituan.sqt.response.out.cashier.StandardCashierRefundResponse;
import com.meituan.sqt.utils.EncryptUtil;
import com.meituan.sqt.utils.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mock/cashier"})
public class ThirdCashierMockController {
    private static final Logger log = LoggerFactory.getLogger(ThirdCashierMockController.class);
    @Autowired
    IThirdCashierService thirdCashierService;
    private static final String accessKey = "CD5JWMDYYZUQ-TK";
    private static final String secretKey = "avnSmanBozOdyXPWXsu9pg==";

    @PostMapping(value={"/createOrder"}, consumes={"application/json; charset=utf-8"}, produces={"application/json"})
    @ResponseBody
    public BaseApiResponse createOrder(@RequestBody ApiRequest apiRequest) {
        log.info("\u3010\u4e09\u65b9\u6536\u94f6-\u6536\u5355\u3011 apiRequest:{}", (Object)JsonUtil.object2Json(apiRequest));
        try {
            String decryptContent = EncryptUtil.aesDecrypt(apiRequest.getContent(), secretKey);
            StandardCashierCreateOrderRequest request = JsonUtil.json2Object(decryptContent, StandardCashierCreateOrderRequest.class);
            log.info("\u3010\u4e09\u65b9\u6536\u94f6-\u6536\u5355\u3011\u89e3\u5bc6\u5f97\u5230 request:{}", (Object)JsonUtil.object2Json(request));
            StandardCashierCreateOrderResponse respBody = this.thirdCashierService.createOrder(request);
            log.info("\u3010\u4e09\u65b9\u6536\u94f6-\u6536\u5355\u3011response:{}", (Object)JsonUtil.object2Json(respBody));
            String encryptData = EncryptUtil.aesEncrypt(JsonUtil.object2Json(respBody), secretKey);
            log.info("\u3010\u4e09\u65b9\u6536\u94f6-\u6536\u5355\u3011response:{}", (Object)JsonUtil.object2Json(respBody));
            return BaseApiResponse.success(encryptData, request.getTraceId());
        }
        catch (Exception e) {
            log.error("\u3010\u4e09\u65b9\u6536\u94f6-\u6536\u5355\u3011\u5f02\u5e38, apiRequest: {}", (Object)JsonUtil.object2Json(apiRequest), (Object)e);
            return BaseApiResponse.fail(500, "\u6536\u5355\u5185\u90e8\u5f02\u5e38");
        }
    }

    @PostMapping(value={"/refund"}, consumes={"application/json; charset=utf-8"}, produces={"application/json"})
    @ResponseBody
    public BaseApiResponse refund(@RequestBody ApiRequest apiRequest) {
        log.info("\u3010\u4e09\u65b9\u6536\u94f6-\u9000\u6b3e\u3011 apiRequest:{}", (Object)JsonUtil.object2Json(apiRequest));
        try {
            String decryptContent = EncryptUtil.aesDecrypt(apiRequest.getContent(), secretKey);
            StandardCashierRefundRequest request = JsonUtil.json2Object(decryptContent, StandardCashierRefundRequest.class);
            log.info("\u3010\u4e09\u65b9\u6536\u94f6-\u9000\u6b3e\u3011\u89e3\u5bc6\u5f97\u5230 request:{}", (Object)JsonUtil.object2Json(request));
            StandardCashierRefundResponse respBody = this.thirdCashierService.refund(request);
            log.info("\u3010\u4e09\u65b9\u6536\u94f6-\u9000\u6b3e\u3011response:{}", (Object)JsonUtil.object2Json(respBody));
            String encryptData = EncryptUtil.aesEncrypt(JsonUtil.object2Json(respBody), secretKey);
            log.info("\u3010\u4e09\u65b9\u6536\u94f6-\u9000\u6b3e\u3011apiResponse:{}", (Object)JsonUtil.object2Json(respBody));
            return BaseApiResponse.success(encryptData, request.getTraceId());
        }
        catch (Exception e) {
            log.error("\u3010\u4e09\u65b9\u6536\u94f6-\u9000\u6b3e\u3011\u5f02\u5e38, apiRequest: {}", (Object)JsonUtil.object2Json(apiRequest), (Object)e);
            return BaseApiResponse.fail(500, "\u9000\u6b3e\u5185\u90e8\u5f02\u5e38");
        }
    }

    @PostMapping(value={"/payStatusQuery"}, consumes={"application/json; charset=utf-8"}, produces={"application/json"})
    @ResponseBody
    public BaseApiResponse payStatusQuery(@RequestBody ApiRequest apiRequest) {
        log.info("\u3010\u4e09\u65b9\u6536\u94f6-\u652f\u4ed8\u72b6\u6001\u67e5\u8be2\u3011 apiRequest:{}", (Object)JsonUtil.object2Json(apiRequest));
        try {
            String decryptContent = EncryptUtil.aesDecrypt(apiRequest.getContent(), secretKey);
            StandardCashierPayQueryRequest request = JsonUtil.json2Object(decryptContent, StandardCashierPayQueryRequest.class);
            log.info("\u3010\u4e09\u65b9\u6536\u94f6-\u652f\u4ed8\u72b6\u6001\u67e5\u8be2\u3011\u89e3\u5bc6\u5f97\u5230 request:{}", (Object)JsonUtil.object2Json(request));
            StandardCashierPayQueryRequest respBody = this.thirdCashierService.payQuery(request);
            log.info("\u3010\u4e09\u65b9\u6536\u94f6-\u652f\u4ed8\u72b6\u6001\u67e5\u8be2\u3011response:{}", (Object)JsonUtil.object2Json(respBody));
            String encryptData = EncryptUtil.aesEncrypt(JsonUtil.object2Json(respBody), secretKey);
            log.info("\u3010\u4e09\u65b9\u6536\u94f6-\u652f\u4ed8\u72b6\u6001\u67e5\u8be2\u3011apiResponse:{}", (Object)JsonUtil.object2Json(respBody));
            return BaseApiResponse.success(encryptData, request.getTraceId());
        }
        catch (Exception e) {
            log.error("\u3010\u4e09\u65b9\u6536\u94f6-\u652f\u4ed8\u72b6\u6001\u67e5\u8be2\u3011\u5f02\u5e38, apiRequest: {}", (Object)JsonUtil.object2Json(apiRequest), (Object)e);
            return BaseApiResponse.fail(500, "\u652f\u4ed8\u72b6\u6001\u67e5\u8be2\u5185\u90e8\u5f02\u5e38");
        }
    }

    @PostMapping(value={"/closeOrder"}, consumes={"application/json; charset=utf-8"}, produces={"application/json"})
    @ResponseBody
    public BaseApiResponse closeOrder(@RequestBody ApiRequest apiRequest) {
        log.info("\u3010\u4e09\u65b9\u6536\u94f6-\u5173\u5355\u3011 apiRequest:{}", (Object)JsonUtil.object2Json(apiRequest));
        try {
            String decryptContent = EncryptUtil.aesDecrypt(apiRequest.getContent(), secretKey);
            StandardCashierCloseOrderRequest request = JsonUtil.json2Object(decryptContent, StandardCashierCloseOrderRequest.class);
            log.info("\u3010\u4e09\u65b9\u6536\u94f6-\u5173\u5355\u3011\u89e3\u5bc6\u5f97\u5230 request:{}", (Object)JsonUtil.object2Json(request));
            StandardCashierCloseOrderResponse respBody = this.thirdCashierService.closeOrder(request);
            log.info("\u3010\u4e09\u65b9\u6536\u94f6-\u5173\u5355\u3011response:{}", (Object)JsonUtil.object2Json(respBody));
            String encryptData = EncryptUtil.aesEncrypt(JsonUtil.object2Json(respBody), secretKey);
            log.info("\u3010\u4e09\u65b9\u6536\u94f6-\u5173\u5355\u3011apiResponse:{}", (Object)JsonUtil.object2Json(respBody));
            return BaseApiResponse.success(encryptData, request.getTraceId());
        }
        catch (Exception e) {
            log.error("\u3010\u4e09\u65b9\u6536\u94f6-\u5173\u5355\u3011\u5f02\u5e38, apiRequest: {}", (Object)JsonUtil.object2Json(apiRequest), (Object)e);
            return BaseApiResponse.fail(500, "\u5173\u5355\u5185\u90e8\u5f02\u5e38");
        }
    }
}

