/*
 * Decompiled with CFR 0.152.
 */
package com.meituan.sqt.demo.out.cashier;

import com.meituan.sqt.request.out.budget.BaseApiRequest;
import com.meituan.sqt.request.out.cashier.StaffInfoV;
import com.meituan.sqt.request.out.cashier.StandardCashierCloseOrderRequest;
import com.meituan.sqt.request.out.cashier.StandardCashierCreateOrderRequest;
import com.meituan.sqt.request.out.cashier.StandardCashierPayQueryRequest;
import com.meituan.sqt.request.out.cashier.StandardCashierRefundRequest;
import com.meituan.sqt.response.out.budget.BaseApiResponse;
import com.meituan.sqt.response.out.cashier.StandardCashierCloseOrderResponse;
import com.meituan.sqt.response.out.cashier.StandardCashierCreateOrderResponse;
import com.meituan.sqt.response.out.cashier.StandardCashierRefundResponse;
import com.meituan.sqt.utils.EncryptUtil;
import com.meituan.sqt.utils.HttpClientUtil;
import com.meituan.sqt.utils.JsonUtil;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class ThirdCashierAPITest {
    private static Long entId = 0L;
    private static final String accessKey = "CD5JWMDYYZUQ-TK";
    private static final String secretKey = "avnSmanBozOdyXPWXsu9pg==";
    private static final String dateStrPattern = "yyyy-MM-dd HH:mm:ss";

    private String randomId() {
        Random random = new Random();
        return String.valueOf(random.nextInt(1000000000));
    }

    private String dateFormat(LocalDateTime localDateTime) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(dateStrPattern);
        return localDateTime.format(formatter);
    }

    @Test
    public void testCreateOrder() throws Exception {
        StandardCashierCreateOrderRequest request = new StandardCashierCreateOrderRequest();
        request.setTradeNo(this.randomId());
        request.setSqtBizOrderId(this.randomId());
        request.setTradeAmount("190.00");
        request.setServiceFeeAmount("10.00");
        request.setGoodsName("\u725b");
        LocalDateTime closeTime = LocalDateTime.now().plusMinutes(15L);
        request.setTradeExpiringTime(this.dateFormat(closeTime));
        request.setNotifyUrl("http://localhost:80/test/cashier/notify");
        request.setReturnUrl("http://localhost:80/test/cashier/return");
        request.setFirstBusinessType("010");
        request.setSecondBusinessType("010120");
        StaffInfoV staffInfoV = new StaffInfoV();
        staffInfoV.setStaffId(123L);
        staffInfoV.setStaffName("\u5f20\u4e09");
        staffInfoV.setStaffNum("456");
        staffInfoV.setStaffPhone("12345678901");
        staffInfoV.setStaffEmail("e@mail.com");
        request.setStaffInfo(staffInfoV);
        HashMap<String, String> extInfoMap = new HashMap<String, String>();
        extInfoMap.put("ssoUser", "{\"staffId\":\"123\"}");
        request.setExtInfoMap(extInfoMap);
        request.setTs(System.currentTimeMillis());
        request.setEntId(entId);
        request.setTraceId(this.randomId());
        request.setMethod("trade.third.pay");
        String rawContent = JsonUtil.object2Json(request, false);
        String encryptData = EncryptUtil.aesEncrypt(rawContent, secretKey);
        BaseApiRequest baseApiRequest = new BaseApiRequest(accessKey, encryptData);
        String api = "http://localhost:8080/cashier/api";
        String responseStr = HttpClientUtil.invokePost2Json(api, JsonUtil.object2Json(baseApiRequest), 2000, 3000).getBody();
        System.out.println("\u660e\u6587\u8bf7\u6c42\uff1a" + rawContent);
        System.out.println("\u54cd\u5e94\uff1a" + responseStr);
        Assert.assertNotNull((Object)responseStr);
        BaseApiResponse baseApiResponse = JsonUtil.json2Object(responseStr, BaseApiResponse.class);
        Assert.assertNotNull((Object)baseApiResponse);
        Assert.assertEquals((Object)0, (Object)baseApiResponse.getStatus());
        String data = EncryptUtil.aesDecrypt(baseApiResponse.getData(), secretKey);
        Assert.assertNotNull((Object)data);
        StandardCashierCreateOrderResponse response = JsonUtil.json2Object(data, StandardCashierCreateOrderResponse.class);
        Assert.assertNotNull((Object)response);
    }

    @Test
    public void testQueryPayStatus() throws Exception {
        StandardCashierPayQueryRequest request = new StandardCashierPayQueryRequest();
        request.setTradeNo("4263393");
        request.setTs(System.currentTimeMillis());
        request.setEntId(entId);
        request.setTraceId(this.randomId());
        request.setMethod("trade.third.pay.query");
        String rawContent = JsonUtil.object2Json(request, false);
        String encryptData = EncryptUtil.aesEncrypt(rawContent, secretKey);
        BaseApiRequest baseApiRequest = new BaseApiRequest(accessKey, encryptData);
        String api = "http://localhost:8080/cashier/api";
        String responseStr = HttpClientUtil.invokePost2Json(api, JsonUtil.object2Json(baseApiRequest), 2000, 3000).getBody();
        System.out.println("\u660e\u6587\u8bf7\u6c42\uff1a" + rawContent);
        System.out.println("\u54cd\u5e94\uff1a" + responseStr);
        Assert.assertNotNull((Object)responseStr);
        BaseApiResponse baseApiResponse = JsonUtil.json2Object(responseStr, BaseApiResponse.class);
        Assert.assertNotNull((Object)baseApiResponse);
        Assert.assertEquals((Object)0, (Object)baseApiResponse.getStatus());
        String data = EncryptUtil.aesDecrypt(baseApiResponse.getData(), secretKey);
        Assert.assertNotNull((Object)data);
        StandardCashierPayQueryRequest response = JsonUtil.json2Object(data, StandardCashierPayQueryRequest.class);
        Assert.assertNotNull((Object)response);
    }

    @Test
    public void testRefund() throws Exception {
        StandardCashierRefundRequest request = new StandardCashierRefundRequest();
        request.setTradeNo("4263393");
        request.setTradeRefundNo(this.randomId());
        request.setRefundAmount("11.00");
        request.setServiceFeeRefundAmount("1.00");
        request.setTs(System.currentTimeMillis());
        request.setEntId(entId);
        request.setTraceId(this.randomId());
        request.setMethod("trade.third.refund");
        String rawContent = JsonUtil.object2Json(request, false);
        String encryptData = EncryptUtil.aesEncrypt(rawContent, secretKey);
        BaseApiRequest baseApiRequest = new BaseApiRequest(accessKey, encryptData);
        String api = "http://localhost:8080/cashier/api";
        String responseStr = HttpClientUtil.invokePost2Json(api, JsonUtil.object2Json(baseApiRequest), 2000, 3000).getBody();
        System.out.println("\u660e\u6587\u8bf7\u6c42\uff1a" + rawContent);
        System.out.println("\u54cd\u5e94\uff1a" + responseStr);
        Assert.assertNotNull((Object)responseStr);
        BaseApiResponse baseApiResponse = JsonUtil.json2Object(responseStr, BaseApiResponse.class);
        Assert.assertNotNull((Object)baseApiResponse);
        Assert.assertEquals((Object)0, (Object)baseApiResponse.getStatus());
        String data = EncryptUtil.aesDecrypt(baseApiResponse.getData(), secretKey);
        Assert.assertNotNull((Object)data);
        StandardCashierRefundResponse response = JsonUtil.json2Object(data, StandardCashierRefundResponse.class);
        Assert.assertNotNull((Object)response);
    }

    @Test
    public void testCloseOrder() throws Exception {
        StandardCashierCloseOrderRequest request = new StandardCashierCloseOrderRequest();
        request.setTradeNo("4263393");
        request.setTs(System.currentTimeMillis());
        request.setEntId(entId);
        request.setTraceId(this.randomId());
        request.setMethod("trade.third.pay.close");
        String rawContent = JsonUtil.object2Json(request, false);
        String encryptData = EncryptUtil.aesEncrypt(rawContent, secretKey);
        BaseApiRequest baseApiRequest = new BaseApiRequest(accessKey, encryptData);
        String api = "http://localhost:8080/cashier/api";
        String responseStr = HttpClientUtil.invokePost2Json(api, JsonUtil.object2Json(baseApiRequest), 2000, 3000).getBody();
        System.out.println("\u660e\u6587\u8bf7\u6c42\uff1a" + rawContent);
        System.out.println("\u54cd\u5e94\uff1a" + responseStr);
        Assert.assertNotNull((Object)responseStr);
        BaseApiResponse baseApiResponse = JsonUtil.json2Object(responseStr, BaseApiResponse.class);
        Assert.assertNotNull((Object)baseApiResponse);
        Assert.assertEquals((Object)0, (Object)baseApiResponse.getStatus());
        String data = EncryptUtil.aesDecrypt(baseApiResponse.getData(), secretKey);
        Assert.assertNotNull((Object)data);
        StandardCashierCloseOrderResponse response = JsonUtil.json2Object(data, StandardCashierCloseOrderResponse.class);
        Assert.assertNotNull((Object)response);
    }
}

