/*
 * Decompiled with CFR 0.152.
 */
package com.meituan.sqt.demo.out.budget;

import com.meituan.sqt.request.out.budget.BaseApiRequest;
import com.meituan.sqt.request.out.budget.StandardBudgetPayQueryRequest;
import com.meituan.sqt.request.out.budget.StandardBudgetPayRequest;
import com.meituan.sqt.request.out.budget.StandardBudgetQueryRequest;
import com.meituan.sqt.request.out.budget.StandardBudgetRefundQueryRequest;
import com.meituan.sqt.request.out.budget.StandardBudgetRefundRequest;
import com.meituan.sqt.response.out.budget.BaseApiResponse;
import com.meituan.sqt.response.out.budget.BudgetPayResponse;
import com.meituan.sqt.response.out.budget.BudgetQueryPayResponse;
import com.meituan.sqt.response.out.budget.BudgetQueryRefundResponse;
import com.meituan.sqt.response.out.budget.BudgetQueryResponse;
import com.meituan.sqt.response.out.budget.BudgetRefundResponse;
import com.meituan.sqt.utils.EncryptUtil;
import com.meituan.sqt.utils.HttpClientUtil;
import com.meituan.sqt.utils.JsonUtil;
import org.junit.Assert;
import org.junit.Test;

public class OutBudgetTestDemo {
    private static String host = "http://localhost:8411/test/budget";
    private static Long entId = 101774L;
    private static final String accessKey = "CD5JWMDYYZUQ-TK";
    private static final String secretKey = "avnSmanBozOdyXPWXsu9pg==";

    @Test
    public void mockBudgetQueryFromSqt() throws Exception {
        StandardBudgetQueryRequest request = new StandardBudgetQueryRequest();
        request.setBudgetKey("budgetKey");
        request.setSqtBizOrderId(111111L);
        request.setEstimateAmount("11.22");
        request.setTs(System.currentTimeMillis() / 1000L);
        request.setTraceId("-1111111");
        request.setEntId(entId);
        String rawContent = JsonUtil.object2Json(request, false);
        String encryptData = EncryptUtil.aesEncrypt(rawContent, secretKey);
        BaseApiRequest baseApiRequest = new BaseApiRequest(accessKey, encryptData);
        String budgetQueryHostUrl = "http://localhost:8411/mockV2/budget/queryBudget";
        String responseStr = HttpClientUtil.invokePost2Json(budgetQueryHostUrl, JsonUtil.object2Json(baseApiRequest), 2000, 3000).getBody();
        System.out.println("\u7b2c\u4e09\u65b9\u5e73\u53f0\u3010\u9884\u7b97\u67e5\u8be2\u3011\u8fd4\u56de\u54cd\u5e94\u7ed3\u679c(\u5bc6\u6587\uff09: " + responseStr);
        BaseApiResponse baseResponse = JsonUtil.json2Object(responseStr, BaseApiResponse.class);
        Assert.assertNotNull((Object)baseResponse);
        Assert.assertEquals((String)"\u7b2c\u4e09\u65b9\u5e73\u53f0\u3010\u9884\u7b97\u67e5\u8be2\u3011\u5931\u8d25", (long)0L, (long)baseResponse.getStatus().intValue());
        String responseData = EncryptUtil.aesDecrypt(baseResponse.getData(), secretKey);
        System.out.println("\u7b2c\u4e09\u65b9\u5e73\u53f0\u3010\u9884\u7b97\u67e5\u8be2\u3011\u8fd4\u56de\u54cd\u5e94\u7ed3\u679c(\u660e\u6587\uff09: " + responseData);
        BudgetQueryResponse respBody = JsonUtil.json2Object(responseData, BudgetQueryResponse.class);
        Assert.assertNotNull((String)"\u54cd\u5e94\u7ed3\u679c\u4e3a\u7a7a", (Object)respBody);
    }

    @Test
    public void mockBudgetPayFromSqt() throws Exception {
        StandardBudgetPayRequest request = new StandardBudgetPayRequest();
        request.setTs(System.currentTimeMillis() / 1000L);
        request.setTraceId("-1111111");
        request.setEntId(entId);
        request.setBudgetKey("budgetKey");
        request.setPayTradeNo("11231312");
        request.setEntPayAmount("12.1");
        request.setServiceFeeAmount("12.1");
        request.setSqtBizOrderId(111111L);
        String rawContent = JsonUtil.object2Json(request, false);
        String encryptData = EncryptUtil.aesEncrypt(rawContent, secretKey);
        BaseApiRequest baseApiRequest = new BaseApiRequest(accessKey, encryptData);
        String payHostUrl = "http://localhost:8411/mockV2/budget/budgetPay";
        String responseStr = HttpClientUtil.invokePost2Json(payHostUrl, JsonUtil.object2Json(baseApiRequest), 2000, 3000).getBody();
        System.out.println("\u7b2c\u4e09\u65b9\u5e73\u53f0\u3010\u9884\u7b97\u6263\u51cf\u3011\u8fd4\u56de\u54cd\u5e94\u7ed3\u679c(\u5bc6\u6587\uff09: " + responseStr);
        BaseApiResponse baseResponse = JsonUtil.json2Object(responseStr, BaseApiResponse.class);
        Assert.assertNotNull((Object)baseResponse);
        Assert.assertEquals((String)"\u7b2c\u4e09\u65b9\u5e73\u53f0\u3010\u9884\u7b97\u6263\u51cf\u3011\u5931\u8d25", (long)0L, (long)baseResponse.getStatus().intValue());
        String responseData = EncryptUtil.aesDecrypt(baseResponse.getData(), secretKey);
        System.out.println("\u7b2c\u4e09\u65b9\u5e73\u53f0\u3010\u9884\u7b97\u6263\u51cf\u3011\u8fd4\u56de\u54cd\u5e94\u7ed3\u679c(\u660e\u6587\uff09: " + responseData);
        BudgetPayResponse respBody = JsonUtil.json2Object(responseData, BudgetPayResponse.class);
        Assert.assertNotNull((String)"\u54cd\u5e94\u7ed3\u679c\u4e3a\u7a7a", (Object)respBody);
    }

    @Test
    public void mockBudgetPayQueryFromSqt() throws Exception {
        StandardBudgetPayQueryRequest payQueryRequest = new StandardBudgetPayQueryRequest();
        payQueryRequest.setTs(System.currentTimeMillis() / 1000L);
        payQueryRequest.setTraceId("-1111111");
        payQueryRequest.setEntId(entId);
        payQueryRequest.setPayTradeNo("11231312");
        String rawContent = JsonUtil.object2Json(payQueryRequest, false);
        String encryptData = EncryptUtil.aesEncrypt(rawContent, secretKey);
        BaseApiRequest baseApiRequest = new BaseApiRequest(accessKey, encryptData);
        String payQueryHostUrl = "http://localhost:8411/mockV2/budget/budgetPayQuery";
        String responseStr = HttpClientUtil.invokePost2Json(payQueryHostUrl, JsonUtil.object2Json(baseApiRequest), 2000, 3000).getBody();
        System.out.println("\u7b2c\u4e09\u65b9\u5e73\u53f0\u3010\u9884\u7b97\u6263\u51cf\u72b6\u6001\u67e5\u8be2\u3011\u8fd4\u56de\u54cd\u5e94\u7ed3\u679c(\u5bc6\u6587\uff09: " + responseStr);
        BaseApiResponse baseResponse = JsonUtil.json2Object(responseStr, BaseApiResponse.class);
        Assert.assertNotNull((Object)baseResponse);
        Assert.assertEquals((String)"\u7b2c\u4e09\u65b9\u5e73\u53f0\u3010\u9884\u7b97\u6263\u51cf\u72b6\u6001\u67e5\u8be2\u3011\u5931\u8d25", (long)0L, (long)baseResponse.getStatus().intValue());
        String responseData = EncryptUtil.aesDecrypt(baseResponse.getData(), secretKey);
        System.out.println("\u7b2c\u4e09\u65b9\u5e73\u53f0\u3010\u9884\u7b97\u6263\u51cf\u72b6\u6001\u67e5\u8be2\u3011\u8fd4\u56de\u54cd\u5e94\u7ed3\u679c(\u660e\u6587\uff09: " + responseData);
        BudgetQueryPayResponse respBody = JsonUtil.json2Object(responseData, BudgetQueryPayResponse.class);
        Assert.assertNotNull((String)"\u54cd\u5e94\u7ed3\u679c\u4e3a\u7a7a", (Object)respBody);
    }

    @Test
    public void mockBudgetRefundFromSqt() throws Exception {
        StandardBudgetRefundRequest refundRequest = new StandardBudgetRefundRequest();
        refundRequest.setTs(System.currentTimeMillis() / 1000L);
        refundRequest.setTraceId("-1111111");
        refundRequest.setEntId(entId);
        refundRequest.setBudgetKey("budgetKey");
        refundRequest.setPayTradeNo("11231312");
        refundRequest.setRefundTradeNo("1111111");
        refundRequest.setRefundAmount("12.1");
        refundRequest.setServiceFeeRefundAmount("12.1");
        refundRequest.setSqtBizOrderId(111111L);
        String rawContent = JsonUtil.object2Json(refundRequest, false);
        String encryptData = EncryptUtil.aesEncrypt(rawContent, secretKey);
        BaseApiRequest baseApiRequest = new BaseApiRequest(accessKey, encryptData);
        String refundHostUrl = "http://localhost:8411/mockV2/budget/budgetRefund";
        String responseStr = HttpClientUtil.invokePost2Json(refundHostUrl, JsonUtil.object2Json(baseApiRequest), 2000, 3000).getBody();
        System.out.println("\u7b2c\u4e09\u65b9\u5e73\u53f0\u3010\u9884\u7b97\u6062\u590d\u3011\u8fd4\u56de\u54cd\u5e94\u7ed3\u679c(\u5bc6\u6587\uff09: " + responseStr);
        BaseApiResponse baseResponse = JsonUtil.json2Object(responseStr, BaseApiResponse.class);
        Assert.assertNotNull((Object)baseResponse);
        Assert.assertEquals((String)"\u7b2c\u4e09\u65b9\u5e73\u53f0\u3010\u9884\u7b97\u6062\u590d\u3011\u5931\u8d25", (long)0L, (long)baseResponse.getStatus().intValue());
        String responseData = EncryptUtil.aesDecrypt(baseResponse.getData(), secretKey);
        System.out.println("\u7b2c\u4e09\u65b9\u5e73\u53f0\u3010\u9884\u7b97\u6062\u590d\u3011\u8fd4\u56de\u54cd\u5e94\u7ed3\u679c(\u660e\u6587\uff09: " + responseData);
        BudgetRefundResponse respBody = JsonUtil.json2Object(responseData, BudgetRefundResponse.class);
        Assert.assertNotNull((String)"\u54cd\u5e94\u7ed3\u679c\u4e3a\u7a7a", (Object)respBody);
    }

    @Test
    public void mockBudgetRefundQueryFromSqt() throws Exception {
        StandardBudgetRefundQueryRequest refundQueryRequest = new StandardBudgetRefundQueryRequest();
        refundQueryRequest.setTs(System.currentTimeMillis() / 1000L);
        refundQueryRequest.setTraceId("-1111111");
        refundQueryRequest.setEntId(entId);
        refundQueryRequest.setRefundTradeNo("11231312");
        String rawContent = JsonUtil.object2Json(refundQueryRequest, false);
        String encryptData = EncryptUtil.aesEncrypt(rawContent, secretKey);
        BaseApiRequest baseApiRequest = new BaseApiRequest(accessKey, encryptData);
        String refundQueryHostUrl = "http://localhost:8411/mockV2/budget/budgetRefundQuery";
        String responseStr = HttpClientUtil.invokePost2Json(refundQueryHostUrl, JsonUtil.object2Json(baseApiRequest), 2000, 3000).getBody();
        System.out.println("\u7b2c\u4e09\u65b9\u5e73\u53f0\u3010\u9884\u7b97\u6062\u590d\u72b6\u6001\u67e5\u8be2\u3011\u8fd4\u56de\u54cd\u5e94\u7ed3\u679c(\u5bc6\u6587\uff09: " + responseStr);
        BaseApiResponse baseResponse = JsonUtil.json2Object(responseStr, BaseApiResponse.class);
        Assert.assertNotNull((Object)baseResponse);
        Assert.assertEquals((String)"\u7b2c\u4e09\u65b9\u5e73\u53f0\u3010\u9884\u7b97\u6062\u590d\u72b6\u6001\u67e5\u8be2\u3011\u5931\u8d25", (long)0L, (long)baseResponse.getStatus().intValue());
        String responseData = EncryptUtil.aesDecrypt(baseResponse.getData(), secretKey);
        System.out.println("\u7b2c\u4e09\u65b9\u5e73\u53f0\u3010\u9884\u7b97\u6062\u590d\u72b6\u6001\u67e5\u8be2\u3011\u8fd4\u56de\u54cd\u5e94\u7ed3\u679c(\u660e\u6587\uff09: " + responseData);
        BudgetQueryRefundResponse respBody = JsonUtil.json2Object(responseData, BudgetQueryRefundResponse.class);
        Assert.assertNotNull((String)"\u54cd\u5e94\u7ed3\u679c\u4e3a\u7a7a", (Object)respBody);
    }
}

