/*
 * Decompiled with CFR 0.152.
 */
package com.meituan.sqt.demo.out.budget;

import com.meituan.sqt.demo.out.budget.IThirdBudgetService;
import com.meituan.sqt.request.out.budget.BaseApiRequest;
import com.meituan.sqt.request.out.budget.StandardBaseRequest;
import com.meituan.sqt.response.out.budget.BaseApiResponse;
import com.meituan.sqt.response.out.budget.BudgetPayResponse;
import com.meituan.sqt.response.out.budget.BudgetQueryPayResponse;
import com.meituan.sqt.response.out.budget.BudgetQueryRefundResponse;
import com.meituan.sqt.response.out.budget.BudgetQueryResponse;
import com.meituan.sqt.response.out.budget.BudgetRefundResponse;
import com.meituan.sqt.utils.EncryptUtil;
import com.meituan.sqt.utils.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/mock/budget"})
public class BudgetMockController {
    private static final Logger log = LoggerFactory.getLogger(BudgetMockController.class);
    private static final String accessKey = "CD5JWMDYYZUQ-TK";
    private static final String secretKey = "avnSmanBozOdyXPWXsu9pg==";
    @Autowired
    IThirdBudgetService thirdBudgetService;

    @PostMapping(value={"/queryBudget"})
    @ResponseBody
    public BaseApiResponse queryBudget(@RequestBody BaseApiRequest baseRequest) {
        log.info("\u9884\u7b97\u63a5\u5165\u3010\u9884\u7b97\u67e5\u8be2\u3011request:{}", (Object)JsonUtil.object2Json(baseRequest));
        try {
            String decryptContent = EncryptUtil.aesDecrypt(baseRequest.getContent(), secretKey);
            log.info("\u9884\u7b97\u63a5\u5165\u3010\u9884\u7b97\u67e5\u8be2\u3011mock \u89e3\u5bc6decryptContent\uff1a{}", (Object)decryptContent);
            StandardBaseRequest request = JsonUtil.json2Object(decryptContent, StandardBaseRequest.class);
            log.info("\u9884\u7b97\u63a5\u5165\u3010\u9884\u7b97\u67e5\u8be2\u3011request:{}", (Object)JsonUtil.object2Json(request));
            BudgetQueryResponse budgetQueryRespBody = this.thirdBudgetService.queryBudget(request);
            String encryptData = EncryptUtil.aesEncrypt(JsonUtil.object2Json(budgetQueryRespBody), secretKey);
            log.info("\u9884\u7b97\u63a5\u5165\u3010\u9884\u7b97\u67e5\u8be2\u3011response:{}", (Object)JsonUtil.object2Json(budgetQueryRespBody));
            return BaseApiResponse.success(encryptData, request.getTraceId());
        }
        catch (Exception e) {
            log.error("\u9884\u7b97\u63a5\u5165\u3010\u9884\u7b97\u67e5\u8be2\u3011mock\u3010\u5f02\u5e38\u3011", (Throwable)e);
            return BaseApiResponse.fail(e.getMessage());
        }
    }

    @PostMapping(value={"/budgetPay"})
    @ResponseBody
    public BaseApiResponse budgetPay(@RequestBody BaseApiRequest baseRequest) throws Exception {
        log.info("\u9884\u7b97\u63a5\u5165\u3010\u9884\u7b97\u6263\u51cf\u3011request:{}", (Object)JsonUtil.object2Json(baseRequest));
        try {
            String decryptContent = EncryptUtil.aesDecrypt(baseRequest.getContent(), secretKey);
            log.info("\u9884\u7b97\u63a5\u5165\u3010\u9884\u7b97\u6263\u51cf\u3011mock \u89e3\u5bc6decryptContent\uff1a{}", (Object)decryptContent);
            StandardBaseRequest request = JsonUtil.json2Object(decryptContent, StandardBaseRequest.class);
            log.info("\u9884\u7b97\u63a5\u5165\u3010\u9884\u7b97\u6263\u51cf\u3011request:{}", (Object)JsonUtil.object2Json(request));
            BudgetPayResponse budgetPayRespBody = this.thirdBudgetService.budgetPay(request);
            String encryptData = EncryptUtil.aesEncrypt(JsonUtil.object2Json(budgetPayRespBody), secretKey);
            log.info("\u9884\u7b97\u63a5\u5165\u3010\u9884\u7b97\u6263\u51cf\u3011response:{}", (Object)JsonUtil.object2Json(budgetPayRespBody));
            return BaseApiResponse.success(encryptData, request.getTraceId());
        }
        catch (Exception e) {
            log.error("\u9884\u7b97\u63a5\u5165\u3010\u9884\u7b97\u6263\u51cf\u3011mock\u3010\u5f02\u5e38\u3011", (Throwable)e);
            return BaseApiResponse.fail(e.getMessage());
        }
    }

    @PostMapping(value={"/budgetPayQuery"})
    @ResponseBody
    public BaseApiResponse budgetPayQuery(@RequestBody BaseApiRequest baseRequest) {
        log.info("\u9884\u7b97\u63a5\u5165\u3010\u9884\u7b97\u6263\u51cf\u72b6\u6001\u67e5\u8be2\u3011request:{}", (Object)JsonUtil.object2Json(baseRequest));
        try {
            String decryptContent = EncryptUtil.aesDecrypt(baseRequest.getContent(), secretKey);
            log.info("\u9884\u7b97\u63a5\u5165\u3010\u9884\u7b97\u6263\u51cf\u72b6\u6001\u67e5\u8be2\u3011mock \u89e3\u5bc6decryptContent\uff1a{}", (Object)decryptContent);
            StandardBaseRequest request = JsonUtil.json2Object(decryptContent, StandardBaseRequest.class);
            log.info("\u9884\u7b97\u63a5\u5165\u3010\u9884\u7b97\u6263\u51cf\u72b6\u6001\u67e5\u8be2\u3011request:{}", (Object)JsonUtil.object2Json(request));
            BudgetQueryPayResponse budgetPayQueryRespBody = this.thirdBudgetService.budgetPayQuery(request);
            String encryptData = EncryptUtil.aesEncrypt(JsonUtil.object2Json(budgetPayQueryRespBody), secretKey);
            log.info("\u9884\u7b97\u63a5\u5165\u3010\u9884\u7b97\u6263\u51cf\u72b6\u6001\u67e5\u8be2\u3011response:{}", (Object)JsonUtil.object2Json(budgetPayQueryRespBody));
            return BaseApiResponse.success(encryptData, request.getTraceId());
        }
        catch (Exception e) {
            log.error("\u9884\u7b97\u63a5\u5165\u3010\u9884\u7b97\u6263\u51cf\u72b6\u6001\u67e5\u8be2\u3011mock\u3010\u5f02\u5e38\u3011", (Throwable)e);
            return BaseApiResponse.fail(e.getMessage());
        }
    }

    @PostMapping(value={"/budgetRefund"})
    @ResponseBody
    public BaseApiResponse budgetRefund(@RequestBody BaseApiRequest baseRequest) throws Exception {
        log.info("\u9884\u7b97\u63a5\u5165\u3010\u9884\u7b97\u6062\u590d\u3011request:{}", (Object)JsonUtil.object2Json(baseRequest));
        try {
            String decryptContent = EncryptUtil.aesDecrypt(baseRequest.getContent(), secretKey);
            log.info("\u9884\u7b97\u63a5\u5165\u3010\u9884\u7b97\u6062\u590d\u3011mock \u89e3\u5bc6decryptContent\uff1a{}", (Object)decryptContent);
            StandardBaseRequest request = JsonUtil.json2Object(decryptContent, StandardBaseRequest.class);
            log.info("\u9884\u7b97\u63a5\u5165\u3010\u9884\u7b97\u6062\u590d\u3011request:{}", (Object)JsonUtil.object2Json(request));
            BudgetRefundResponse budgetRefundRespBody = this.thirdBudgetService.budgetRefund(request);
            String encryptData = EncryptUtil.aesEncrypt(JsonUtil.object2Json(budgetRefundRespBody), secretKey);
            log.info("\u9884\u7b97\u63a5\u5165\u3010\u9884\u7b97\u6062\u590d\u3011response:{}", (Object)JsonUtil.object2Json(budgetRefundRespBody));
            return BaseApiResponse.success(encryptData, request.getTraceId());
        }
        catch (Exception e) {
            log.error("\u9884\u7b97\u63a5\u5165\u3010\u9884\u7b97\u6062\u590d\u3011mock\u3010\u5f02\u5e38\u3011", (Throwable)e);
            return BaseApiResponse.fail(e.getMessage());
        }
    }

    @PostMapping(value={"/budgetRefundQuery"})
    @ResponseBody
    public BaseApiResponse budgetRefundQuery(@RequestBody BaseApiRequest baseRequest) {
        log.info("\u9884\u7b97\u63a5\u5165\u3010\u9884\u7b97\u6062\u590d\u72b6\u6001\u67e5\u8be2\u3011request:{}", (Object)JsonUtil.object2Json(baseRequest));
        try {
            String decryptContent = EncryptUtil.aesDecrypt(baseRequest.getContent(), secretKey);
            log.info("\u9884\u7b97\u63a5\u5165\u3010\u9884\u7b97\u6062\u590d\u72b6\u6001\u67e5\u8be2\u3011mock \u89e3\u5bc6decryptContent\uff1a{}", (Object)decryptContent);
            StandardBaseRequest request = JsonUtil.json2Object(decryptContent, StandardBaseRequest.class);
            log.info("\u9884\u7b97\u63a5\u5165\u3010\u9884\u7b97\u6062\u590d\u72b6\u6001\u67e5\u8be2\u3011request:{}", (Object)JsonUtil.object2Json(request));
            BudgetQueryRefundResponse budgetRefundQueryRespBody = this.thirdBudgetService.budgetRefundQuery(request);
            String encryptData = EncryptUtil.aesEncrypt(JsonUtil.object2Json(budgetRefundQueryRespBody), secretKey);
            log.info("\u9884\u7b97\u63a5\u5165\u3010\u9884\u7b97\u6062\u590d\u72b6\u6001\u67e5\u8be2\u3011response:{}", (Object)JsonUtil.object2Json(budgetRefundQueryRespBody));
            return BaseApiResponse.success(encryptData, request.getTraceId());
        }
        catch (Exception e) {
            log.error("\u9884\u7b97\u63a5\u5165\u3010\u9884\u7b97\u6062\u590d\u72b6\u6001\u67e5\u8be2\u3011mock\u3010\u5f02\u5e38\u3011", (Throwable)e);
            return BaseApiResponse.fail(e.getMessage());
        }
    }
}

