/*
 * Decompiled with CFR 0.152.
 */
package com.meituan.sqt.demo.in.project;

import com.google.common.collect.Lists;
import com.meituan.sqt.client.SqtClient;
import com.meituan.sqt.constant.CommonConstants;
import com.meituan.sqt.enums.ResponseStatusEnum;
import com.meituan.sqt.exception.MtSqtException;
import com.meituan.sqt.request.in.project.ProjectQueryRequest;
import com.meituan.sqt.response.in.BaseApiResponse;
import com.meituan.sqt.response.in.project.ProjectQueryResult;
import com.meituan.sqt.utils.JsonUtil;
import java.util.Objects;

public class ProjectQueryDemo {
    private static final String invokeUrl = "https://waimai-openapi.apigw.test.meituan.com/api/sqt/open/project/query";
    private static SqtClient sqtClient = null;

    public static void main(String[] args) throws MtSqtException {
        ProjectQueryRequest projectQueryRequest = new ProjectQueryRequest();
        projectQueryRequest.setTs(System.currentTimeMillis());
        projectQueryRequest.setEntId(sqtClient.getEntId());
        projectQueryRequest.setProjectNo("openapiProject2");
        projectQueryRequest.setSuitableType(2);
        projectQueryRequest.setStatusList(Lists.newArrayList((Object[])new String[]{"ONLINE", "PAUSE"}));
        BaseApiResponse<ProjectQueryResult> response = sqtClient.invokeApi(invokeUrl, projectQueryRequest, null, null);
        if (response == null) {
            // empty if block
        }
        if (Objects.equals(ResponseStatusEnum.SUCCESS.getCode(), response.getStatus())) {
            ProjectQueryResult result = response.getRealData();
            System.out.println(JsonUtil.object2Json(result));
        } else {
            ProjectQueryDemo.handleRespFailResult(response);
        }
    }

    private static void handleRespFailResult(BaseApiResponse<ProjectQueryResult> response) {
        if (ResponseStatusEnum.HIGH_FREQUENCY_ACCESS.getCode().intValue() == response.getStatus().intValue()) {
            // empty if block
        }
        if (ResponseStatusEnum.EXCEED_ACCESS_NUMBER.getCode().intValue() == response.getStatus().intValue()) {
            // empty if block
        }
        System.out.println(response.getMsg());
    }

    static {
        sqtClient = new SqtClient.Builder().setEntId(CommonConstants.entId).setAccessKey("CHEDT40YLREQ-TK").setSecretKey("ZMOI95pl06mzzGr+oIQnYw==").build();
    }
}

