/*
 * Decompiled with CFR 0.152.
 */
package com.meituan.sqt.demo.in.login;

import com.google.common.collect.Maps;
import com.meituan.sqt.client.SqtClient;
import com.meituan.sqt.constant.CommonConstants;
import com.meituan.sqt.model.HttpResponse;
import com.meituan.sqt.request.in.login.LoginRequest;
import com.meituan.sqt.utils.HttpClientUtil;
import com.meituan.sqt.utils.JsonUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.RandomStringUtils;

public class LoginDemo {
    private static String LOGIN_URL_TEST = "https://waimai-openapi.apigw.test.meituan.com/api/sqt/open/login/h5/loginFree/redirection?test_open_swimlane=test-open";
    private static String LOGIN_URL_PROD = "https://bep-openapi.meituan.com/api/sqt/open/login/h5/loginFree/redirection";
    private static SqtClient sqtClient = null;

    public static void main(String[] args) throws Exception {
        LoginDemo.serverInvokeLogin();
    }

    private static void serverInvokeLogin() throws Exception {
        HashMap headerMap = Maps.newHashMap();
        headerMap.put("Accept", "application/json");
        headerMap.put("Content-type", "application/x-www-form-urlencoded; charset=utf-8");
        Map<String, String> requestParamMap = sqtClient.buildRequestMap(LoginDemo.buildLoginRequestBody());
        HttpResponse httpResponse = null;
        try {
            httpResponse = HttpClientUtil.invokePost(LOGIN_URL_TEST, headerMap, requestParamMap, 2000, 3000);
            if (httpResponse.getStatus() == 302) {
                System.out.println("url = " + httpResponse.getHeader().get("Location").get(0));
                return;
            }
            System.out.println("httpResponse = " + JsonUtil.object2Json(httpResponse));
        }
        catch (Exception e) {
            System.out.println("e = " + e);
        }
    }

    private static String buildLoginRequestBody() throws Exception {
        LoginRequest loginRequest = new LoginRequest();
        loginRequest.setTs(System.currentTimeMillis());
        loginRequest.setEntId(CommonConstants.entId);
        loginRequest.setStaffInfo(LoginDemo.buildLoginStaffInfo());
        loginRequest.setNonce(RandomStringUtils.random((int)36, (boolean)true, (boolean)true));
        loginRequest.setProductType("mt_waimai");
        return JsonUtil.object2Json(loginRequest, false);
    }

    private static LoginRequest.LoginStaffInfo buildLoginStaffInfo() {
        LoginRequest.LoginStaffInfo loginStaffInfo = new LoginRequest.LoginStaffInfo();
        loginStaffInfo.setStaffPhone("19987888888");
        return loginStaffInfo;
    }

    static {
        sqtClient = new SqtClient.Builder().setEntId(CommonConstants.entId).setAccessKey("CHEDT40YLREQ-TK").setSecretKey("ZMOI95pl06mzzGr+oIQnYw==").build();
    }
}

