/*
 * Decompiled with CFR 0.152.
 */
package com.meituan.sqt.demo.in.cost;

import com.google.common.collect.Lists;
import com.meituan.sqt.client.SqtClient;
import com.meituan.sqt.constant.CommonConstants;
import com.meituan.sqt.enums.ResponseStatusEnum;
import com.meituan.sqt.exception.MtSqtException;
import com.meituan.sqt.request.in.cost.CostQueryRequest;
import com.meituan.sqt.response.in.BaseApiResponse;
import com.meituan.sqt.response.in.cost.CostQueryResult;
import com.meituan.sqt.utils.JsonUtil;
import java.util.Objects;

public class CostQueryDemo {
    private static final String invokeUrl = "https://waimai-openapi.apigw.test.meituan.com/api/sqt/open/cost/query";
    private static SqtClient sqtClient = null;

    public static void main(String[] args) throws MtSqtException {
        CostQueryRequest costQueryRequest = new CostQueryRequest();
        costQueryRequest.setTs(System.currentTimeMillis());
        costQueryRequest.setEntId(sqtClient.getEntId());
        costQueryRequest.setCostNo("openapiCost2");
        costQueryRequest.setCostName("\u6210\u672c\u4e2d\u5fc3");
        costQueryRequest.setSuitableType(2);
        costQueryRequest.setParentCostNo("cost");
        costQueryRequest.setStatusList(Lists.newArrayList((Object[])new String[]{"ONLINE", "PAUSE"}));
        BaseApiResponse<CostQueryResult> response = sqtClient.invokeApi(invokeUrl, costQueryRequest, null, null);
        if (response == null) {
            // empty if block
        }
        if (Objects.equals(ResponseStatusEnum.SUCCESS.getCode(), response.getStatus())) {
            CostQueryResult result = response.getRealData();
            System.out.println(JsonUtil.object2Json(result));
        } else {
            CostQueryDemo.handleRespFailResult(response);
        }
    }

    private static void handleRespFailResult(BaseApiResponse<CostQueryResult> response) {
        if (ResponseStatusEnum.HIGH_FREQUENCY_ACCESS.getCode().intValue() == response.getStatus().intValue()) {
            // empty if block
        }
        if (ResponseStatusEnum.EXCEED_ACCESS_NUMBER.getCode().intValue() == response.getStatus().intValue()) {
            // empty if block
        }
        System.out.println(response.getMsg());
    }

    static {
        sqtClient = new SqtClient.Builder().setEntId(CommonConstants.entId).setAccessKey("CHEDT40YLREQ-TK").setSecretKey("ZMOI95pl06mzzGr+oIQnYw==").build();
    }
}

