/*
 * Decompiled with CFR 0.152.
 */
package com.meituan.sqt.demo.in.bill;

import com.google.common.collect.Lists;
import com.meituan.sqt.client.SqtClient;
import com.meituan.sqt.constant.CommonConstants;
import com.meituan.sqt.enums.ResponseStatusEnum;
import com.meituan.sqt.enums.bill.ApiBizCategoryEnum;
import com.meituan.sqt.exception.MtSqtException;
import com.meituan.sqt.request.in.bill.QuerySettlementDetailRequest;
import com.meituan.sqt.response.in.BaseApiResponse;
import com.meituan.sqt.response.in.bill.QuerySettlementDetailResponse;
import com.meituan.sqt.response.in.bill.dto.settlement.SettlementDetail;
import com.meituan.sqt.response.in.bill.dto.settlement.hotel.HotelSettlementDetail;
import com.meituan.sqt.response.in.bill.dto.settlement.plane.PlaneSettlementDetail;
import com.meituan.sqt.response.in.bill.dto.settlement.train.TrainSettlementDetail;
import com.meituan.sqt.utils.JsonUtil;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class QuerySettlementDetailDemo {
    private static final String invokeUrl = "https://bep-openapi.meituan.com/api/sqt/open/settle/bill/querySettlementDetail";
    private static SqtClient sqtClient = null;

    public static void main(String[] args) throws MtSqtException {
        QuerySettlementDetailRequest querySettlementDetailRequest = new QuerySettlementDetailRequest();
        querySettlementDetailRequest.setTs(System.currentTimeMillis());
        querySettlementDetailRequest.setEntId(sqtClient.getEntId());
        querySettlementDetailRequest.setRequestNo("e982b3b690d344c9ba093385f022f852");
        querySettlementDetailRequest.setFirstBusinessType(ApiBizCategoryEnum.HOTEL.getCode());
        querySettlementDetailRequest.setStartDate("2023-03-01");
        querySettlementDetailRequest.setEndDate("2023-03-31");
        querySettlementDetailRequest.setPageSize(200);
        querySettlementDetailRequest.setSqtBizOrderId("186462657454931125");
        querySettlementDetailRequest.setNextStartId("180300117200971780");
        BaseApiResponse<QuerySettlementDetailResponse> response = sqtClient.invokeApi(invokeUrl, querySettlementDetailRequest, null, null);
        List<? extends SettlementDetail> planeSettlementDetailList = QuerySettlementDetailDemo.getSettlementDetail(ApiBizCategoryEnum.PLANE.getCode(), response.getRealData());
        System.out.println(JsonUtil.object2Json(planeSettlementDetailList));
        if (response == null) {
            // empty if block
        }
        if (Objects.equals(ResponseStatusEnum.SUCCESS.getCode(), response.getStatus())) {
            QuerySettlementDetailResponse querySettlementDetailResponse = response.getRealData();
        } else {
            QuerySettlementDetailDemo.handleRespFailResult(response);
        }
    }

    public static List<? extends SettlementDetail> getSettlementDetail(String firstBusinessType, QuerySettlementDetailResponse response) {
        if (StringUtils.isBlank((CharSequence)firstBusinessType) || Objects.isNull(response)) {
            return Lists.newArrayList();
        }
        if (StringUtils.equals((CharSequence)firstBusinessType, (CharSequence)ApiBizCategoryEnum.PLANE.getCode())) {
            return JsonUtil.json2ObjectList(JsonUtil.object2Json(response.getSettlementDetailList()), PlaneSettlementDetail.class);
        }
        if (StringUtils.equals((CharSequence)firstBusinessType, (CharSequence)ApiBizCategoryEnum.HOTEL.getCode())) {
            return JsonUtil.json2ObjectList(JsonUtil.object2Json(response.getSettlementDetailList()), HotelSettlementDetail.class);
        }
        if (StringUtils.equals((CharSequence)firstBusinessType, (CharSequence)ApiBizCategoryEnum.TRAIN.getCode())) {
            return JsonUtil.json2ObjectList(JsonUtil.object2Json(response.getSettlementDetailList()), TrainSettlementDetail.class);
        }
        return Lists.newArrayList();
    }

    private static void handleRespFailResult(BaseApiResponse<QuerySettlementDetailResponse> response) {
        if (ResponseStatusEnum.HIGH_FREQUENCY_ACCESS.getCode().intValue() == response.getStatus().intValue()) {
            // empty if block
        }
        if (ResponseStatusEnum.EXCEED_ACCESS_NUMBER.getCode().intValue() == response.getStatus().intValue()) {
            // empty if block
        }
        System.out.println(response.getMsg());
    }

    static {
        sqtClient = new SqtClient.Builder().setEntId(CommonConstants.entId).setAccessKey("CHEDT40YLREQ-TK").setSecretKey("ZMOI95pl06mzzGr+oIQnYw==").build();
    }
}

