/*
 * Decompiled with CFR 0.152.
 */
package com.meituan.sqt.demo.in.bill;

import com.google.common.collect.Lists;
import com.meituan.sqt.client.SqtClient;
import com.meituan.sqt.constant.CommonConstants;
import com.meituan.sqt.enums.ResponseStatusEnum;
import com.meituan.sqt.enums.bill.ApiBizCategoryEnum;
import com.meituan.sqt.exception.MtSqtException;
import com.meituan.sqt.request.in.bill.QuerySettleBillDetailRequest;
import com.meituan.sqt.response.in.BaseApiResponse;
import com.meituan.sqt.response.in.bill.QuerySettleBillDetailResponse;
import com.meituan.sqt.response.in.bill.dto.billdetail.BillDetail;
import com.meituan.sqt.response.in.bill.dto.billdetail.hotel.HotelBillDetail;
import com.meituan.sqt.response.in.bill.dto.billdetail.plane.PlaneBillDetail;
import com.meituan.sqt.response.in.bill.dto.billdetail.train.TrainBillDetail;
import com.meituan.sqt.utils.JsonUtil;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class QuerySettleBillDetailDemo {
    private static final String invokeUrl = "https://bep-openapi.meituan.com/api/sqt/open/settle/bill/querySettleBillDetail";
    private static SqtClient sqtClient = null;

    public static void main(String[] args) throws MtSqtException {
        QuerySettleBillDetailRequest querySettleBillDetailRequest = new QuerySettleBillDetailRequest();
        querySettleBillDetailRequest.setTs(System.currentTimeMillis());
        querySettleBillDetailRequest.setEntId(sqtClient.getEntId());
        querySettleBillDetailRequest.setRequestNo("e982b3b690d344c9ba093385f022f852");
        querySettleBillDetailRequest.setBillNo("B068283241201241205000H00000");
        querySettleBillDetailRequest.setFirstBusinessType(ApiBizCategoryEnum.PLANE.getCode());
        querySettleBillDetailRequest.setPageSize(200);
        querySettleBillDetailRequest.setNextStartId("123123132123132");
        BaseApiResponse<QuerySettleBillDetailResponse> response = sqtClient.invokeApi(invokeUrl, querySettleBillDetailRequest, null, null);
        List<? extends BillDetail> planeBillDetailList = QuerySettleBillDetailDemo.getBillDetail(ApiBizCategoryEnum.PLANE.getCode(), response.getRealData());
        System.out.println(JsonUtil.object2Json(planeBillDetailList));
        if (response == null) {
            // empty if block
        }
        if (Objects.equals(ResponseStatusEnum.SUCCESS.getCode(), response.getStatus())) {
            QuerySettleBillDetailResponse querySettleBillDetailResponse = response.getRealData();
        } else {
            QuerySettleBillDetailDemo.handleRespFailResult(response);
        }
    }

    public static List<? extends BillDetail> getBillDetail(String firstBusinessType, QuerySettleBillDetailResponse response) {
        if (StringUtils.isBlank((CharSequence)firstBusinessType) || Objects.isNull(response)) {
            return Lists.newArrayList();
        }
        if (StringUtils.equals((CharSequence)firstBusinessType, (CharSequence)ApiBizCategoryEnum.PLANE.getCode())) {
            return JsonUtil.json2ObjectList(JsonUtil.object2Json(response.getBillDetailList()), PlaneBillDetail.class);
        }
        if (StringUtils.equals((CharSequence)firstBusinessType, (CharSequence)ApiBizCategoryEnum.HOTEL.getCode())) {
            return JsonUtil.json2ObjectList(JsonUtil.object2Json(response.getBillDetailList()), HotelBillDetail.class);
        }
        if (StringUtils.equals((CharSequence)firstBusinessType, (CharSequence)ApiBizCategoryEnum.TRAIN.getCode())) {
            return JsonUtil.json2ObjectList(JsonUtil.object2Json(response.getBillDetailList()), TrainBillDetail.class);
        }
        return Lists.newArrayList();
    }

    private static void handleRespFailResult(BaseApiResponse<QuerySettleBillDetailResponse> response) {
        if (ResponseStatusEnum.HIGH_FREQUENCY_ACCESS.getCode().intValue() == response.getStatus().intValue()) {
            // empty if block
        }
        if (ResponseStatusEnum.EXCEED_ACCESS_NUMBER.getCode().intValue() == response.getStatus().intValue()) {
            // empty if block
        }
        System.out.println(response.getMsg());
    }

    static {
        sqtClient = new SqtClient.Builder().setEntId(CommonConstants.entId).setAccessKey("CHEDT40YLREQ-TK").setSecretKey("ZMOI95pl06mzzGr+oIQnYw==").build();
    }
}

