/*
 * Decompiled with CFR 0.152.
 */
package com.meituan.sqt.demo.in.base;

import com.meituan.sqt.client.SqtClient;
import com.meituan.sqt.constant.CommonConstants;
import com.meituan.sqt.enums.ResponseStatusEnum;
import com.meituan.sqt.exception.MtSqtException;
import com.meituan.sqt.request.in.base.UrlQueryRequest;
import com.meituan.sqt.response.in.BaseApiResponse;
import com.meituan.sqt.response.in.base.UrlQueryResult;
import java.util.HashMap;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class UrlQueryDemo {
    private static final String invokeUrl = "https://waimai-openapi.apigw.test.meituan.com/api/sqt/open/url/query";
    private static SqtClient sqtClient = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws MtSqtException {
        UrlQueryRequest urlQueryRequest = new UrlQueryRequest();
        urlQueryRequest.setUrlIdentifier("sqt_home_page");
        HashMap<String, String> buildParam = new HashMap<String, String>();
        buildParam.put("param1", "value1");
        buildParam.put("param2", "value2");
        urlQueryRequest.setUrlParam(buildParam);
        urlQueryRequest.setTs(System.currentTimeMillis());
        urlQueryRequest.setEntId(sqtClient.getEntId());
        BaseApiResponse<UrlQueryResult> response = sqtClient.invokeApi(invokeUrl, urlQueryRequest, 3000, 3000);
        if (response == null) {
            // empty if block
        }
        if (Objects.equals(ResponseStatusEnum.SUCCESS.getCode(), response.getStatus())) {
            UrlQueryResult urlQueryResult = response.getRealData();
            if (urlQueryResult != null && !StringUtils.isNotBlank((CharSequence)urlQueryResult.getUrl())) return;
        }
        UrlQueryDemo.handleRespFailResult(response);
    }

    private static void handleRespFailResult(BaseApiResponse<UrlQueryResult> response) {
        if (ResponseStatusEnum.HIGH_FREQUENCY_ACCESS.getCode().intValue() == response.getStatus().intValue()) {
            // empty if block
        }
        if (ResponseStatusEnum.EXCEED_ACCESS_NUMBER.getCode().intValue() == response.getStatus().intValue()) {
            // empty if block
        }
    }

    static {
        sqtClient = new SqtClient.Builder().setEntId(CommonConstants.entId).setAccessKey("CHEDT40YLREQ-TK").setSecretKey("ZMOI95pl06mzzGr+oIQnYw==").build();
    }
}

