/*
 * Decompiled with CFR 0.152.
 */
package com.meituan.sqt.client;

import com.google.common.collect.Maps;
import com.meituan.sqt.enums.EncryptionAlgorithmEnum;
import com.meituan.sqt.enums.SdkErrorEnum;
import com.meituan.sqt.exception.MtSqtException;
import com.meituan.sqt.model.ApiMetaInfo;
import com.meituan.sqt.model.HttpResponse;
import com.meituan.sqt.request.in.BaseApiRequest;
import com.meituan.sqt.response.in.BaseApiResponse;
import com.meituan.sqt.utils.AnnotationUtil;
import com.meituan.sqt.utils.EncryptUtil;
import com.meituan.sqt.utils.HttpClientUtil;
import com.meituan.sqt.utils.JsonUtil;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqtClient {
    private static final Logger log = LoggerFactory.getLogger(SqtClient.class);
    private Long entId;
    private String accessKey;
    private String secretKey;
    private EncryptionAlgorithmEnum encryptionAlgorithm;
    private String oldSecretKey;
    private EncryptionAlgorithmEnum oldEncryptionAlgorithm;

    private SqtClient(Builder builder) {
        this.entId = builder.entId;
        this.accessKey = builder.accessKey;
        this.secretKey = builder.secretKey;
        this.encryptionAlgorithm = builder.encryptionAlgorithm == null ? EncryptionAlgorithmEnum.AES_ECB : builder.encryptionAlgorithm;
        this.oldSecretKey = builder.oldSecretKey;
        this.oldEncryptionAlgorithm = builder.oldEncryptionAlgorithm;
    }

    public Long getEntId() {
        return this.entId;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public EncryptionAlgorithmEnum getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public String getOldSecretKey() {
        return this.oldSecretKey;
    }

    public EncryptionAlgorithmEnum getOldEncryptionAlgorithm() {
        return this.oldEncryptionAlgorithm;
    }

    public <T> BaseApiResponse<T> invokeApi(String invokeUrl, BaseApiRequest<T> request, Integer connectTimeout, Integer socketTimeout) throws MtSqtException {
        this.verifyParams(request);
        try {
            HashMap headerMap = Maps.newHashMap();
            headerMap.put("Accept", "application/json");
            headerMap.put("Content-type", "application/x-www-form-urlencoded; charset=utf-8");
            String rawContent = JsonUtil.object2Json(request, false);
            Map<String, String> requestParamMap = this.buildRequestMap(rawContent);
            ApiMetaInfo apiMetaInfo = AnnotationUtil.getApiMeta(request);
            if (connectTimeout == null && apiMetaInfo != null) {
                connectTimeout = apiMetaInfo.getConnectTimeout();
            }
            if (socketTimeout == null && apiMetaInfo != null) {
                socketTimeout = apiMetaInfo.getSocketTimeout();
            }
            if (connectTimeout == null || socketTimeout == null) {
                throw new MtSqtException(SdkErrorEnum.MISS_TIME_OUT_ERROR);
            }
            HttpResponse httpResponse = HttpClientUtil.invokePost(invokeUrl, headerMap, requestParamMap, connectTimeout, socketTimeout);
            BaseApiResponse<T> response = this.buildResponseResult(request, httpResponse);
            return response;
        }
        catch (Exception e) {
            log.error("HTTP\u8c03\u7528\u5931\u8d25, \u8bf7\u6c42\u4fe1\u606f:{}, serverUrl:{}", new Object[]{JsonUtil.object2Json(request), invokeUrl, e});
            throw new MtSqtException(SdkErrorEnum.REQUEST_FAILED_ERROR);
        }
    }

    public Map<String, String> buildRequestMap(String rawContent) throws Exception {
        String iv = this.genIvParam(this.encryptionAlgorithm);
        String content = EncryptUtil.encrypt(this.encryptionAlgorithm, rawContent, this.secretKey, iv);
        HashMap requestParamMap = Maps.newHashMap();
        requestParamMap.put("accessKey", this.accessKey);
        requestParamMap.put("content", content);
        if (StringUtils.isNotBlank((CharSequence)iv)) {
            requestParamMap.put("iv", iv);
        }
        return requestParamMap;
    }

    private <T> BaseApiResponse<T> buildResponseResult(BaseApiRequest<T> request, HttpResponse httpResponse) throws Exception {
        String responseStr;
        String string = responseStr = httpResponse == null ? null : httpResponse.getBody();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            throw new MtSqtException(SdkErrorEnum.HTTP_INVOKE_NULL_RESULT);
        }
        try {
            BaseApiResponse baseApiResponse = JsonUtil.json2Object(responseStr, BaseApiResponse.class);
            if (baseApiResponse == null || StringUtils.isEmpty((CharSequence)baseApiResponse.getData())) {
                return baseApiResponse;
            }
            String rawContent = this.decryptContent(baseApiResponse.getData(), baseApiResponse.getIv(), httpResponse);
            T realDataObject = request.deserializeResponse(rawContent);
            baseApiResponse.setRealData(realDataObject);
            return baseApiResponse;
        }
        catch (Exception e) {
            log.error("HTTP\u8c03\u7528, \u8fd4\u56de\u7ed3\u679c\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u6c42\u4fe1\u606f:{}, \u54cd\u5e94\u7ed3\u679c:{}", new Object[]{JsonUtil.object2Json(request), responseStr, e});
            throw new MtSqtException(SdkErrorEnum.PARSE_RESPONSE_ERROR);
        }
    }

    private String decryptContent(String data, String iv, HttpResponse httpResponse) throws Exception {
        String encryptionMode;
        if (StringUtils.isBlank((CharSequence)this.oldSecretKey) || this.oldEncryptionAlgorithm == null) {
            return EncryptUtil.decrypt(this.encryptionAlgorithm, data, this.secretKey, iv);
        }
        String encryptionAlgorithm = this.getHeaderValue(httpResponse.getHeader(), "X-Encryption-Algorithm");
        EncryptionAlgorithmEnum usingAlgorithm = EncryptionAlgorithmEnum.parseAlgorithm(encryptionAlgorithm, encryptionMode = this.getHeaderValue(httpResponse.getHeader(), "X-Encryption-Mode"));
        if (Objects.equals((Object)usingAlgorithm, (Object)this.oldEncryptionAlgorithm)) {
            return EncryptUtil.decrypt(this.oldEncryptionAlgorithm, data, this.oldSecretKey, iv);
        }
        return EncryptUtil.decrypt(this.encryptionAlgorithm, data, this.secretKey, iv);
    }

    private String getHeaderValue(Map<String, List<String>> headers, String headerName) {
        List<String> values = headers.get(headerName);
        return values != null && !values.isEmpty() ? values.get(0) : null;
    }

    private String genIvParam(EncryptionAlgorithmEnum encryptionAlgorithmEnum) {
        if (EncryptionAlgorithmEnum.ecbMode(encryptionAlgorithmEnum)) {
            return null;
        }
        int length = 16;
        if (EncryptionAlgorithmEnum.gcmMode(encryptionAlgorithmEnum)) {
            length = 12;
        }
        byte[] iv = new byte[length];
        SecureRandom random = new SecureRandom();
        random.nextBytes(iv);
        return Base64.getEncoder().encodeToString(iv);
    }

    private void verifyParams(BaseApiRequest request) throws MtSqtException {
        if (request == null) {
            log.error("request\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            throw new MtSqtException(SdkErrorEnum.MISS_PARAM_ERROR);
        }
    }

    public static class Builder {
        private Long entId;
        private String accessKey;
        private String secretKey;
        private EncryptionAlgorithmEnum encryptionAlgorithm;
        private String oldSecretKey;
        private EncryptionAlgorithmEnum oldEncryptionAlgorithm;

        public Builder setEntId(Long entId) {
            this.entId = entId;
            return this;
        }

        public Builder setAccessKey(String accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        public Builder setSecretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public Builder setEncryptionAlgorithm(EncryptionAlgorithmEnum encryptionAlgorithm) {
            this.encryptionAlgorithm = encryptionAlgorithm;
            return this;
        }

        public Builder setOldSecretKey(String oldSecretKey) {
            this.oldSecretKey = oldSecretKey;
            return this;
        }

        public Builder setOldEncryptionAlgorithm(EncryptionAlgorithmEnum oldEncryptionAlgorithm) {
            this.oldEncryptionAlgorithm = oldEncryptionAlgorithm;
            return this;
        }

        public SqtClient build() {
            return new SqtClient(this);
        }
    }
}

