/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ons.print.com.logic;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import jp.co.ons.common.base.BasePrintLogic;
import jp.co.ons.common.util.FileUtil;
import jp.co.ons.common.util.LogUtil;
import jp.co.ons.common.util.StringUtil;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRCsvDataSource;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.engine.util.JRLoader;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFPrintSetup;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class XlsxPrintLogic
extends BasePrintLogic {
    private static final String PG_ID = "XlsxPrintLogic";
    private static final int MAX_BREAK_PAGE = 1024;

    @Override
    protected String getPgId() {
        return PG_ID;
    }

    @Override
    protected boolean run() throws Exception {
        int breakPage = 0;
        JRCsvDataSource jrCsvsource = new JRCsvDataSource(JRLoader.getLocationInputStream((String)this.getCsvFilePath()), "UTF-8");
        jrCsvsource.setUseFirstRowAsHeader(true);
        jrCsvsource.setFieldDelimiter('\t');
        jrCsvsource.setRecordDelimiter("\n");
        FileUtil.createEmptyFile(this.getOutFilePath());
        JasperPrint jasperPrint = JasperFillManager.fillReport((String)this.getJasperFilePath(), null, (JRDataSource)jrCsvsource);
        JRXlsxExporter xlsxExporter = new JRXlsxExporter();
        xlsxExporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        xlsxExporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)this.getOutFilePath());
        xlsxExporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)Boolean.FALSE);
        xlsxExporter.exportReport();
        FileOutputStream out = null;
        XSSFWorkbook workbook = new XSSFWorkbook((InputStream)new FileInputStream(this.getOutFilePath()));
        if (workbook.getNumberOfSheets() > 0) {
            XSSFSheet sheet1 = workbook.getSheetAt(0);
            sheet1.setMargin((short)2, 0.0);
            sheet1.setMargin((short)3, 0.0);
            sheet1.setMargin((short)0, 0.0);
            sheet1.setMargin((short)1, 0.0);
            Map<String, String> mapPrintInfo = this.getPrintInfo();
            if (mapPrintInfo != null) {
                String paper = mapPrintInfo.get("paper");
                String titleX = mapPrintInfo.get("titleX");
                String titleY = mapPrintInfo.get("titleY");
                XSSFPrintSetup printSetting = sheet1.getPrintSetup();
                if ("A3".equals(paper)) {
                    printSetting.setPaperSize((short)8);
                    printSetting.setLandscape(true);
                } else if ("A3_TATE".equals(paper)) {
                    printSetting.setPaperSize((short)8);
                    printSetting.setLandscape(false);
                } else if ("A4".equals(paper)) {
                    printSetting.setPaperSize((short)9);
                    printSetting.setLandscape(true);
                } else if ("A4_TATE".equals(paper)) {
                    printSetting.setPaperSize((short)55);
                    printSetting.setLandscape(false);
                } else if ("A5".equals(paper)) {
                    printSetting.setPaperSize((short)11);
                    printSetting.setLandscape(true);
                } else if ("A5_TATE".equals(paper)) {
                    printSetting.setPaperSize((short)11);
                    printSetting.setLandscape(false);
                } else if ("B4".equals(paper)) {
                    printSetting.setPaperSize((short)12);
                    printSetting.setLandscape(true);
                } else if ("B4_TATE".equals(paper)) {
                    printSetting.setPaperSize((short)12);
                    printSetting.setLandscape(false);
                } else if ("B5".equals(paper)) {
                    printSetting.setPaperSize((short)13);
                    printSetting.setLandscape(true);
                } else if ("B5_TATE".equals(paper)) {
                    printSetting.setPaperSize((short)13);
                    printSetting.setLandscape(false);
                }
                if (!StringUtil.isEmpty((String)titleX) && !StringUtil.isEmpty((String)titleY) && NumberUtils.isNumber((String)titleX) && NumberUtils.isNumber((String)titleY)) {
                    int rowY = Integer.parseInt(titleY);
                    int cellX = Integer.parseInt(titleX);
                    XSSFRow row = sheet1.getRow(rowY);
                    XSSFCell cell = row.getCell(cellX);
                    if (cell != null) {
                        String title = cell.getStringCellValue();
                        LogUtil.info(this.getClass(), String.valueOf(title) + ":" + titleX + ":" + titleY + ":" + paper);
                        if (!StringUtil.isEmpty((String)title)) {
                            int i = 0;
                            while (i < sheet1.getLastRowNum()) {
                                row = sheet1.getRow(i);
                                cell = row.getCell(cellX);
                                String colTitle = cell.getStringCellValue();
                                if (!StringUtil.isEmpty((String)title) && title.equals(colTitle) && i >= rowY + 1 && breakPage < 1024) {
                                    sheet1.setRowBreak(i - (rowY + 1));
                                    ++breakPage;
                                }
                                ++i;
                            }
                        }
                    }
                }
            }
            out = new FileOutputStream(this.getOutFilePath());
            workbook.write((OutputStream)out);
            out.close();
        }
        return true;
    }
}

