/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ons.common.xml;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlParser {
    private Document doc = null;
    private ArrayList<XP> al = null;

    public XmlParser(String path) throws Exception {
        this(new FileInputStream(path));
    }

    public XmlParser(FileInputStream in) throws Exception {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.doc = builder.parse(in);
        }
        catch (ParserConfigurationException e) {
            throw e;
        }
        catch (SAXException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
    }

    public synchronized void initNodeAttr() {
        this.al = new ArrayList();
    }

    public synchronized void setNodeAttr(String nodeName, String attrName, String val) {
        this.al.add(new XP(nodeName, attrName, val));
    }

    public synchronized String getAttribute(String attrName) {
        Element el = this.getElement();
        if (el == null) {
            return null;
        }
        return el.getAttribute(attrName);
    }

    public synchronized String[] getAttributes(String nodeName, String attrName) {
        Element el = this.getElement();
        if (el == null) {
            return null;
        }
        NodeList nl = el.getChildNodes();
        Element retEl = null;
        ArrayList<String> al = new ArrayList<String>();
        int cnt = 0;
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i).getNodeName().equals(nodeName)) {
                retEl = (Element)nl.item(i);
                al.add(retEl.getAttribute(attrName));
                ++cnt;
            }
            ++i;
        }
        int attrCnt = al.size();
        if (attrCnt == 0) {
            return null;
        }
        String[] retStr = new String[attrCnt];
        int i2 = 0;
        while (i2 < attrCnt) {
            retStr[i2] = (String)al.get(i2);
            ++i2;
        }
        return retStr;
    }

    public synchronized String getNodeValue() {
        Element el = this.getElement();
        if (el == null) {
            return null;
        }
        return el.getFirstChild().getNodeValue();
    }

    public synchronized NodeList getChiledNode() {
        Element el = this.getElement();
        if (el == null) {
            return null;
        }
        return el.getChildNodes();
    }

    private synchronized Element getElement() {
        Element el = null;
        String sNodeName = null;
        HashMap<String, String> hm = null;
        int i = 0;
        while (i < this.al.size()) {
            XP xp = this.al.get(i);
            hm = new HashMap<String, String>();
            sNodeName = xp.node;
            while (xp.node.equals(sNodeName)) {
                hm.put(xp.attrName, xp.attrVal);
                if (++i >= this.al.size()) break;
                xp = this.al.get(i);
            }
            el = this.getChildElement(el, sNodeName, hm);
        }
        return el;
    }

    private synchronized Element getChildElement(Element el, String nodeName, Map<String, String> searchConf) {
        NodeList nl = el == null ? this.doc.getDocumentElement().getChildNodes() : el.getChildNodes();
        Element retEl = null;
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i).getNodeName().equals(nodeName)) {
                retEl = (Element)nl.item(i);
                Iterator<String> ite = searchConf.keySet().iterator();
                boolean attrMat = false;
                while (ite.hasNext()) {
                    String key = ite.next();
                    if (key == null) {
                        attrMat = true;
                        break;
                    }
                    if (!retEl.getAttribute(key).equals(searchConf.get(key))) {
                        attrMat = false;
                        break;
                    }
                    attrMat = true;
                }
                if (attrMat) {
                    return retEl;
                }
            }
            ++i;
        }
        return null;
    }

    class XP {
        private String node = null;
        private String attrName = null;
        private String attrVal = null;

        private XP(String pNode, String pAttrName, String pAttrVal) {
            this.node = pNode;
            this.attrName = pAttrName;
            this.attrVal = pAttrVal;
        }
    }
}

