/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ons.common.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.co.ons.common.util.ConvUtil;
import org.apache.commons.lang.StringUtils;

public class StringUtil
extends StringUtils {
    private static final String[][] kanaHanZenTbl = new String[][]{{"\uff76\uff9e", "\u30ac"}, {"\uff77\uff9e", "\u30ae"}, {"\uff78\uff9e", "\u30b0"}, {"\uff79\uff9e", "\u30b2"}, {"\uff7a\uff9e", "\u30b4"}, {"\uff7b\uff9e", "\u30b6"}, {"\uff7c\uff9e", "\u30b8"}, {"\uff7d\uff9e", "\u30ba"}, {"\uff7e\uff9e", "\u30bc"}, {"\uff7f\uff9e", "\u30be"}, {"\uff80\uff9e", "\u30c0"}, {"\uff81\uff9e", "\u30c2"}, {"\uff82\uff9e", "\u30c5"}, {"\uff83\uff9e", "\u30c7"}, {"\uff84\uff9e", "\u30c9"}, {"\uff8a\uff9e", "\u30d0"}, {"\uff8b\uff9e", "\u30d3"}, {"\uff8c\uff9e", "\u30d6"}, {"\uff8d\uff9e", "\u30d9"}, {"\uff8e\uff9e", "\u30dc"}, {"\uff8a\uff9f", "\u30d1"}, {"\uff8b\uff9f", "\u30d4"}, {"\uff8c\uff9f", "\u30d7"}, {"\uff8d\uff9f", "\u30da"}, {"\uff8e\uff9f", "\u30dd"}, {"\uff73\uff9e", "\u30f4"}, {"\uff71", "\u30a2"}, {"\uff72", "\u30a4"}, {"\uff73", "\u30a6"}, {"\uff74", "\u30a8"}, {"\uff75", "\u30aa"}, {"\uff76", "\u30ab"}, {"\uff77", "\u30ad"}, {"\uff78", "\u30af"}, {"\uff79", "\u30b1"}, {"\uff7a", "\u30b3"}, {"\uff7b", "\u30b5"}, {"\uff7c", "\u30b7"}, {"\uff7d", "\u30b9"}, {"\uff7e", "\u30bb"}, {"\uff7f", "\u30bd"}, {"\uff80", "\u30bf"}, {"\uff81", "\u30c1"}, {"\uff82", "\u30c4"}, {"\uff83", "\u30c6"}, {"\uff84", "\u30c8"}, {"\uff85", "\u30ca"}, {"\uff86", "\u30cb"}, {"\uff87", "\u30cc"}, {"\uff88", "\u30cd"}, {"\uff89", "\u30ce"}, {"\uff8a", "\u30cf"}, {"\uff8b", "\u30d2"}, {"\uff8c", "\u30d5"}, {"\uff8d", "\u30d8"}, {"\uff8e", "\u30db"}, {"\uff8f", "\u30de"}, {"\uff90", "\u30df"}, {"\uff91", "\u30e0"}, {"\uff92", "\u30e1"}, {"\uff93", "\u30e2"}, {"\uff94", "\u30e4"}, {"\uff95", "\u30e6"}, {"\uff96", "\u30e8"}, {"\uff97", "\u30e9"}, {"\uff98", "\u30ea"}, {"\uff99", "\u30eb"}, {"\uff9a", "\u30ec"}, {"\uff9b", "\u30ed"}, {"\uff9c", "\u30ef"}, {"\uff66", "\u30f2"}, {"\uff9d", "\u30f3"}, {"\uff67", "\u30a1"}, {"\uff68", "\u30a3"}, {"\uff69", "\u30a5"}, {"\uff6a", "\u30a7"}, {"\uff6b", "\u30a9"}, {"\uff6c", "\u30e3"}, {"\uff6d", "\u30e5"}, {"\uff6e", "\u30e7"}, {"\uff6f", "\u30c3"}, {"\uff61", "\u3002"}, {"\uff62", "\u300c"}, {"\uff63", "\u300d"}, {"\uff64", "\u3001"}, {"\uff65", "\u30fb"}, {"\uff70", "\u30fc"}, {"", ""}};

    public static String replaceReturn(String val, String replace) {
        if (val == null) {
            return val;
        }
        return StringUtil.replace(val, System.getProperty("line.separator"), replace);
    }

    public static String replaceReturnBr(String val) {
        return StringUtil.replaceReturn(val, "<br>");
    }

    public static String replaceLen(String val, String ins, int len) {
        if (val == null) {
            return val;
        }
        StringBuffer sb = new StringBuffer();
        int startIndex = 0;
        int endIndex = 0;
        while (startIndex < val.length()) {
            endIndex = endIndex + len <= val.length() ? (endIndex += len) : val.length();
            sb.append(val.substring(startIndex, endIndex));
            if (endIndex != val.length()) {
                sb.append(ins);
            }
            startIndex = endIndex;
        }
        return sb.toString();
    }

    public static String replace(String str, String fromTgt, String toTgt) {
        if (str == null) {
            return str;
        }
        int pos = -1;
        int apos = 0;
        StringBuffer sb = null;
        while ((pos = str.indexOf(fromTgt, apos)) >= 0) {
            if (sb == null) {
                sb = new StringBuffer(str.substring(0, pos));
            } else {
                sb.append(str.substring(apos, pos));
            }
            sb.append(toTgt);
            apos = pos + fromTgt.length();
        }
        if (sb != null) {
            sb.append(str.substring(apos));
            return sb.toString();
        }
        return str;
    }

    public static String substringByte(String val, int start, int len) {
        return StringUtil.substringByte(val, start, len, "UTF-8");
    }

    public static String substringByte(String val, int start, int len, String charCode) {
        if (val == null) {
            return "";
        }
        String tmp = val;
        int startLen = 0;
        int startIndex = -1;
        int dstlen = 0;
        int i = 0;
        while (i < tmp.length()) {
            startLen = StringUtil.isWideChar(tmp.substring(i, i + 1), charCode) ? (startLen += 2) : ++startLen;
            if (startLen >= start) {
                if (startIndex == -1) {
                    startIndex = i;
                }
                dstlen = StringUtil.isWideChar(tmp.substring(i, i + 1), charCode) ? (dstlen += 2) : ++dstlen;
                if (dstlen > len) {
                    return tmp.substring(startIndex, i);
                }
            }
            ++i;
        }
        return tmp;
    }

    public static boolean isWideChar(String sBuf, String charCode) {
        if (sBuf == null) {
            return false;
        }
        return sBuf.matches("^[^ -~\uff61-\uff9f]+$");
    }

    public static String removeComma(String str) {
        return StringUtil.remove(str, ',');
    }

    public static String remove(String str, char remove) {
        if (str == null) {
            return null;
        }
        char[] chars = str.toCharArray();
        StringBuffer buf = new StringBuffer(chars.length);
        int i = 0;
        while (i < chars.length) {
            if (chars[i] != remove) {
                buf.append(chars[i]);
            }
            ++i;
        }
        return buf.toString();
    }

    public static String trimStr(String str, char remove) {
        if (str == null) {
            return null;
        }
        char[] chars = str.toCharArray();
        StringBuffer buf = new StringBuffer(chars.length);
        int i = 0;
        while (i < chars.length) {
            if (i != 0 && i != chars.length - 1 || chars[i] != remove) {
                buf.append(chars[i]);
            }
            ++i;
        }
        return buf.toString();
    }

    public static String trimStr(String str, String remove) {
        String tmp;
        boolean flg = true;
        StringBuffer sb1 = new StringBuffer();
        StringBuffer sb2 = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            tmp = str.substring(i, i + 1);
            if (!flg || !tmp.equals(remove)) {
                sb1.append(str.substring(i, i + 1));
                flg = false;
            }
            ++i;
        }
        flg = true;
        i = sb1.length();
        while (i > 0) {
            tmp = sb1.toString().substring(i - 1, i);
            if (!flg || !tmp.equals(remove)) {
                sb2.insert(0, tmp);
                flg = false;
            }
            --i;
        }
        return sb2.toString();
    }

    public static String lTrimStr(String str, char remove) {
        if (str == null) {
            return null;
        }
        char[] chars = str.toCharArray();
        int i = 0;
        int len = chars.length;
        while (i < len) {
            if (chars[i] != remove) break;
            ++i;
        }
        return i != 0 ? str.substring(i) : str;
    }

    public static String rTrimStr(String str, char remove) {
        if (str == null) {
            return null;
        }
        char[] chars = str.toCharArray();
        int i = chars.length - 1;
        while (i != 0 && chars[i] == remove) {
            --i;
        }
        return i == 0 ? "" : str.substring(0, i + 1);
    }

    public static String trimSpace(String str) {
        if (str == null) {
            return "";
        }
        String val = StringUtil.lTrimSpace(str);
        val = StringUtil.rTrimSpace(val);
        return val;
    }

    public static String lTrimSpace(String str) {
        if (str == null) {
            return "";
        }
        boolean flg = true;
        StringBuffer sb1 = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            String tmp = str.substring(i, i + 1);
            if (!flg || !tmp.equals(" ") && !tmp.equals("\u3000")) {
                sb1.append(str.substring(i, i + 1));
                flg = false;
            }
            ++i;
        }
        return sb1.toString();
    }

    public static String rTrimSpace(String str) {
        if (str == null) {
            return "";
        }
        boolean flg = true;
        StringBuffer sb2 = new StringBuffer();
        flg = true;
        int i = str.length();
        while (i > 0) {
            String tmp = str.toString().substring(i - 1, i);
            if (!flg || !tmp.equals(" ") && !tmp.equals("\u3000")) {
                sb2.insert(0, tmp);
                flg = false;
            }
            --i;
        }
        return sb2.toString();
    }

    public static String camelToSnake(String targetStr) {
        String convertedStr = targetStr.replaceAll("([A-Z]+)([A-Z][a-z])", "$1_$2").replaceAll("([a-z])([A-Z])", "$1_$2").replaceAll("([a-z])([0-9])", "$1_$2").replaceAll("([A-Z])([0-9])", "$1_$2");
        return convertedStr.toLowerCase();
    }

    public static String snakeToCamel(String targetStr) {
        Pattern p = Pattern.compile("_([a-z0-9])");
        Matcher m = p.matcher(targetStr.toLowerCase());
        StringBuffer sb = new StringBuffer(targetStr.length());
        while (m.find()) {
            m.appendReplacement(sb, m.group(1).toUpperCase());
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String nvl(String val) {
        if (val == null) {
            return "";
        }
        return val;
    }

    public static String wQuotation(String val) {
        return "\"" + StringUtil.nvl(val) + "\"";
    }

    public static String chgFormat(Object obj, String format) {
        if (obj == null) {
            return "";
        }
        return StringUtil.chgFormat(ConvUtil.convBigDecimalComma(obj), format);
    }

    public static String chgFormatZero(Object obj, String format) {
        if (obj == null) {
            return StringUtil.chgFormat(BigDecimal.ZERO, format);
        }
        return StringUtil.chgFormat(ConvUtil.convBigDecimalZero(obj), format);
    }

    public static String chgFormat(BigDecimal obj, String format) {
        if (obj == null) {
            return "";
        }
        DecimalFormat df = new DecimalFormat(format);
        String s = df.format(obj);
        return s;
    }

    public static String replaceAsStr(String val) {
        if (val == null) {
            return val;
        }
        String tmpVal = StringUtil.replace(val, "\ue014", "\u30fb");
        tmpVal = StringUtil.replace(tmpVal, "\ue000", "\u30fb");
        return tmpVal;
    }

    public static String kkanaHan2Zen(String p) {
        if (p == null) {
            return "";
        }
        String str = "";
        int i = 0;
        int j = 0;
        while (i < p.length()) {
            Character c = new Character(p.substring(i, i + 1).charAt(0));
            if (c.compareTo(new Character('\uff61')) >= 0 && c.compareTo(new Character('\uff9f')) <= 0) {
                j = 0;
                while (j < kanaHanZenTbl.length) {
                    if (p.substring(i).startsWith(kanaHanZenTbl[j][0])) {
                        str = String.valueOf(str) + kanaHanZenTbl[j][1];
                        i += kanaHanZenTbl[j][0].length() - 1;
                        break;
                    }
                    ++j;
                }
                if (j >= kanaHanZenTbl.length) {
                    str = String.valueOf(str) + p.substring(i, i + 1);
                }
            } else {
                str = String.valueOf(str) + p.substring(i, i + 1);
            }
            ++i;
        }
        return str;
    }

    public static String kkanaZen2Han(String p) {
        if (p == null) {
            return "";
        }
        String str = "";
        int i = 0;
        int j = 0;
        while (i < p.length()) {
            Character c = new Character(p.substring(i, i + 1).charAt(0));
            if (c.compareTo(new Character('\u30a1')) >= 0 && c.compareTo(new Character('\u30fc')) <= 0) {
                j = 0;
                while (j < kanaHanZenTbl.length) {
                    if (p.substring(i).startsWith(kanaHanZenTbl[j][1])) {
                        str = String.valueOf(str) + kanaHanZenTbl[j][0];
                        break;
                    }
                    ++j;
                }
                if (j >= kanaHanZenTbl.length) {
                    str = String.valueOf(str) + p.substring(i, i + 1);
                }
            } else {
                str = String.valueOf(str) + p.substring(i, i + 1);
            }
            ++i;
        }
        return str;
    }

    public static String latinHan2Zen(String p) {
        if (p == null) {
            return "";
        }
        String str = "";
        int i = 0;
        while (i < p.length()) {
            Character c = new Character(p.substring(i, i + 1).charAt(0));
            if (c.compareTo(new Character('!')) >= 0 && c.compareTo(new Character('~')) <= 0) {
                Character x = new Character((char)(c.charValue() + new Character('\ufee0').charValue()));
                str = String.valueOf(str) + x.toString();
            } else {
                str = String.valueOf(str) + p.substring(i, i + 1);
            }
            ++i;
        }
        return str;
    }

    public static String latinZen2Han(String p) {
        if (p == null) {
            return "";
        }
        String str = "";
        int i = 0;
        while (i < p.length()) {
            Character c = new Character(p.substring(i, i + 1).charAt(0));
            if (c.compareTo(new Character('\uff01')) >= 0 && c.compareTo(new Character('\uff5e')) <= 0) {
                Character x = new Character((char)(c.charValue() - new Character('\ufee0').charValue()));
                str = String.valueOf(str) + x.toString();
            } else {
                str = String.valueOf(str) + p.substring(i, i + 1);
            }
            ++i;
        }
        return str;
    }

    public static String kkana2Hkana(String p) {
        if (p == null) {
            return "";
        }
        String str = "";
        int i = 0;
        while (i < p.length()) {
            Character c = new Character(p.substring(i, i + 1).charAt(0));
            if (c.compareTo(new Character('\u30a1')) >= 0 && c.compareTo(new Character('\u30f3')) <= 0) {
                Character x = new Character((char)(c.charValue() - new Character('`').charValue()));
                str = String.valueOf(str) + x.toString();
            } else {
                str = String.valueOf(str) + p.substring(i, i + 1);
            }
            ++i;
        }
        return str;
    }

    public static String hkana2Kkana(String p) {
        if (p == null) {
            return "";
        }
        String str = "";
        int i = 0;
        while (i < p.length()) {
            Character c = new Character(p.substring(i, i + 1).charAt(0));
            if (c.compareTo(new Character('\u3041')) >= 0 && c.compareTo(new Character('\u3093')) <= 0) {
                Character x = new Character((char)(c.charValue() + new Character('`').charValue()));
                str = String.valueOf(str) + x.toString();
            } else {
                str = String.valueOf(str) + p.substring(i, i + 1);
            }
            ++i;
        }
        return str;
    }
}

