/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ons.common.util;

import java.io.FileInputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

public final class PropertiesManager {
    private static PropertiesManager propertiesManager = null;
    private Map<String, Properties> propertiesMap = new Hashtable<String, Properties>();
    private String webRootPath = null;

    private PropertiesManager() {
    }

    public static PropertiesManager getInstance() {
        if (propertiesManager == null) {
            propertiesManager = new PropertiesManager();
        }
        return propertiesManager;
    }

    public void addProperties(String key, Properties properties) {
        this.propertiesMap.put(key, properties);
    }

    public void addProperties(String key, String filePath) throws Exception {
        Properties properties = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(filePath);
            properties = new Properties();
            properties.load(fileInputStream);
        }
        finally {
            fileInputStream.close();
        }
        this.addProperties(key, properties);
    }

    public void removeProperties(String key) {
        this.propertiesMap.remove(key);
    }

    public Properties getProperties(String key) {
        return this.propertiesMap.get(key);
    }

    public void setProperty(String propertiesKey, String propertyKey, String propertyValue) throws Exception {
        Properties properties = propertiesManager.getProperties(propertiesKey);
        if (properties == null) {
            throw new Exception("\u5f15\u6570\uff1apropertiesKey\u3000\u5024:\"" + propertiesKey + "\"\u3000\u3067\u53d6\u5f97\u3067\u304d\u308bProperties\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
        }
        properties.put(propertyKey, propertyValue);
    }

    public static String getProperty(String propertiesKey, String propertyKey) throws Exception {
        Properties properties = propertiesManager.getProperties(propertiesKey);
        if (properties == null) {
            throw new Exception("\u5f15\u6570\uff1apropertiesKey\u3000\u5024:\"" + propertiesKey + "\"\u3000\u3067\u53d6\u5f97\u3067\u304d\u308bProperties\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
        }
        return (String)properties.get(propertyKey);
    }

    public String getWebRootPath() {
        return this.webRootPath;
    }

    public void setWebRootPath(String webRootPath) {
        this.webRootPath = webRootPath;
    }
}

