/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ons.common.util;

import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import jp.co.ons.common.xml.XmlParser;

public class PrintIdManager {
    private static final String PRINT_MAP_NODE = "Map";
    private static final String PRINT_MAP_ID = "id";
    private static final String PRINT_MAP_PATH = "path";
    private static final String PRINT_MAP_PAPER = "paper";
    private static final String PRINT_MAP_TITLE_X = "titleX";
    private static final String PRINT_MAP_TITLE_Y = "titleY";
    private static PrintIdManager instance = null;
    private static XmlParser msgParser = null;

    private PrintIdManager(FileInputStream stream) throws Exception {
        msgParser = new XmlParser(stream);
    }

    public static void setInstance(String filePath) throws Exception {
        FileInputStream file = new FileInputStream(filePath);
        PrintIdManager.setInstance(file);
    }

    public static void setInstance(FileInputStream stream) throws Exception {
        instance = new PrintIdManager(stream);
    }

    public static PrintIdManager getInstance() {
        return instance;
    }

    public synchronized String getPath(String printId) {
        if (msgParser == null) {
            return "";
        }
        msgParser.initNodeAttr();
        msgParser.setNodeAttr(PRINT_MAP_NODE, PRINT_MAP_ID, printId);
        String ret = msgParser.getAttribute(PRINT_MAP_PATH);
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    public synchronized Map<String, String> getPrintInfo(String printId) {
        if (msgParser == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        msgParser.initNodeAttr();
        msgParser.setNodeAttr(PRINT_MAP_NODE, PRINT_MAP_ID, printId);
        map.put(PRINT_MAP_ID, printId);
        map.put(PRINT_MAP_PATH, msgParser.getAttribute(PRINT_MAP_PATH));
        map.put(PRINT_MAP_PAPER, msgParser.getAttribute(PRINT_MAP_PAPER));
        map.put(PRINT_MAP_TITLE_X, msgParser.getAttribute(PRINT_MAP_TITLE_X));
        map.put(PRINT_MAP_TITLE_Y, msgParser.getAttribute(PRINT_MAP_TITLE_Y));
        return map;
    }
}

