/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ons.common.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import jp.co.ons.common.util.DateUtil;
import jp.co.ons.common.util.StringUtil;

public class HolidayUtil {
    private static final Calendar CST_IMPLEMENT_THE_LAW_OF_HOLIDAY = new GregorianCalendar(1948, 6, 20);
    private static final Calendar CST_AKIHITO_KEKKON = new GregorianCalendar(1959, 3, 10);
    private static final Calendar CST_SHOWA_TAISO = new GregorianCalendar(1989, 1, 24);
    private static final Calendar CST_NORIHITO_KEKKON = new GregorianCalendar(1993, 5, 9);
    private static final Calendar CST_SOKUIREISEIDEN = new GregorianCalendar(1990, 10, 12);
    private static final Calendar CST_IMPLEMENT_HOLIDAY = new GregorianCalendar(1973, 3, 12);
    private static final int INT_1 = 1;
    private static final int INT_2 = 2;
    private static final int INT_3 = 3;
    private static final int INT_4 = 4;
    private static final int INT_5 = 5;
    private static final int INT_6 = 6;
    private static final int INT_7 = 7;
    private static final int INT_9 = 9;
    private static final int INT_10 = 10;
    private static final int INT_11 = 11;
    private static final int INT_12 = 12;
    private static final int INT_99 = 99;

    public static Boolean getHolidayFlg(String prmDate) throws Exception {
        if (StringUtil.isEmpty((String)prmDate)) {
            return false;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd");
        Calendar myDate = Calendar.getInstance();
        myDate.setTime(formatter.parse(prmDate));
        if (myDate.get(7) == 1) {
            return true;
        }
        String tmp = HolidayUtil.getHolidayName(myDate);
        if (StringUtil.isEmpty((String)tmp)) {
            return false;
        }
        return true;
    }

    public static Date getNextNotHoliday(String prmDate) throws Exception {
        Date date = DateUtil.convDate(prmDate);
        if (date == null) {
            return null;
        }
        boolean result;
        while (result = HolidayUtil.getHolidayFlg(DateUtil.convDate(date)).booleanValue()) {
            date = DateUtil.addDate(date, 1);
        }
        return date;
    }

    public static Date getOldNotHoliday(String prmDate) throws Exception {
        Date date = DateUtil.convDate(prmDate);
        boolean result;
        while (result = HolidayUtil.getHolidayFlg(DateUtil.convDate(date)).booleanValue()) {
            date = DateUtil.addDate(date, -1);
        }
        return date;
    }

    public static String getHolidayName(String prmDate) throws Exception {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd");
        Calendar myDate = Calendar.getInstance();
        myDate.setTime(formatter.parse(prmDate));
        return HolidayUtil.getHolidayName(myDate);
    }

    private static String prvHolidayChk(Calendar myDate) {
        String result = "";
        int myYear = myDate.get(1);
        int myMonth = myDate.get(2) + 1;
        int myDay = myDate.get(5);
        if (myDate.before(CST_IMPLEMENT_THE_LAW_OF_HOLIDAY)) {
            return "";
        }
        block0 : switch (myMonth) {
            case 1: {
                if (myDay == 1) {
                    result = "\u5143\u65e5";
                    break;
                }
                if (myYear >= 2000) {
                    int numberOfWeek = (myDay - 1) / 7 + 1;
                    if (numberOfWeek != 2 || myDate.get(7) != 2) break;
                    result = "\u6210\u4eba\u306e\u65e5";
                    break;
                }
                if (myDay != 15) break;
                result = "\u6210\u4eba\u306e\u65e5";
                break;
            }
            case 2: {
                if (myDay == 11) {
                    if (myYear < 1967) break;
                    result = "\u5efa\u56fd\u8a18\u5ff5\u306e\u65e5";
                    break;
                }
                if (!myDate.equals(CST_SHOWA_TAISO)) break;
                result = "\u662d\u548c\u5929\u7687\u306e\u5927\u55aa\u306e\u793c";
                break;
            }
            case 3: {
                if (myDay != HolidayUtil.prvDayOfSpringEquinox(myYear)) break;
                result = "\u6625\u5206\u306e\u65e5";
                break;
            }
            case 4: {
                if (myDay == 29) {
                    if (myYear >= 2007) {
                        result = "\u662d\u548c\u306e\u65e5";
                        break;
                    }
                    if (myYear >= 1989) {
                        result = "\u307f\u3069\u308a\u306e\u65e5";
                        break;
                    }
                    result = "\u5929\u7687\u8a95\u751f\u65e5";
                    break;
                }
                if (!myDate.equals(CST_AKIHITO_KEKKON)) break;
                result = "\u7687\u592a\u5b50\u660e\u4ec1\u89aa\u738b\u306e\u7d50\u5a5a\u306e\u5100";
                break;
            }
            case 5: {
                switch (myDay) {
                    case 3: {
                        result = "\u61b2\u6cd5\u8a18\u5ff5\u65e5";
                        break block0;
                    }
                    case 4: {
                        if (myYear >= 2007) {
                            result = "\u307f\u3069\u308a\u306e\u65e5";
                            break block0;
                        }
                        if (myYear < 1986 || myDate.get(7) <= 2) break block0;
                        result = "\u56fd\u6c11\u306e\u4f11\u65e5";
                        break block0;
                    }
                    case 5: {
                        result = "\u3053\u3069\u3082\u306e\u65e5";
                        break block0;
                    }
                    case 6: {
                        if (myYear < 2007 || myDate.get(7) != 3 && myDate.get(7) != 4) break block0;
                        result = "\u632f\u66ff\u4f11\u65e5";
                        break block0;
                    }
                }
                break;
            }
            case 6: {
                if (!myDate.equals(CST_NORIHITO_KEKKON)) break;
                result = "\u7687\u592a\u5b50\u5fb3\u4ec1\u89aa\u738b\u306e\u7d50\u5a5a\u306e\u5100";
                break;
            }
            case 7: {
                if (myYear >= 2003) {
                    int numberOfWeek = (myDay - 1) / 7 + 1;
                    if (numberOfWeek != 3 || myDate.get(7) != 2) break;
                    result = "\u6d77\u306e\u65e5";
                    break;
                }
                if (myYear < 1996 || myDay != 20) break;
                result = "\u6d77\u306e\u65e5";
                break;
            }
            case 9: {
                int myAutumnEquinox = HolidayUtil.prvDayOfAutumnEquinox(myYear);
                if (myDay == myAutumnEquinox) {
                    result = "\u79cb\u5206\u306e\u65e5";
                    break;
                }
                if (myYear >= 2003) {
                    int numberOfWeek = (myDay - 1) / 7 + 1;
                    if (numberOfWeek == 3 && myDate.get(7) == 2) {
                        result = "\u656c\u8001\u306e\u65e5";
                        break;
                    }
                    if (myDate.get(7) != 3 || myDay != myAutumnEquinox - 1) break;
                    result = "\u56fd\u6c11\u306e\u4f11\u65e5";
                    break;
                }
                if (myYear < 1966 || myDay != 15) break;
                result = "\u656c\u8001\u306e\u65e5";
                break;
            }
            case 10: {
                if (myYear >= 2000) {
                    int numberOfWeek = (myDay - 1) / 7 + 1;
                    if (numberOfWeek != 2 || myDate.get(7) != 2) break;
                    result = "\u4f53\u80b2\u306e\u65e5";
                    break;
                }
                if (myYear < 1966 || myDay != 10) break;
                result = "\u4f53\u80b2\u306e\u65e5";
                break;
            }
            case 11: {
                if (myDay == 3) {
                    result = "\u6587\u5316\u306e\u65e5";
                    break;
                }
                if (myDay == 23) {
                    result = "\u52e4\u52b4\u611f\u8b1d\u306e\u65e5";
                    break;
                }
                if (!myDate.equals(CST_SOKUIREISEIDEN)) break;
                result = "\u5373\u4f4d\u793c\u6b63\u6bbf\u306e\u5100";
                break;
            }
            case 12: {
                if (myDay == 23 && myYear >= 1989) {
                    result = "\u5929\u7687\u8a95\u751f\u65e5";
                }
                if (myDay != 31) break;
                result = "\u5927\u6666\u65e5";
                break;
            }
        }
        return result;
    }

    private static int prvDayOfSpringEquinox(int myYear) {
        int springequinoxRet = myYear <= 1947 ? 99 : (myYear <= 1979 ? (int)(20.8357 + 0.242194 * (double)(myYear - 1980) - (double)((myYear - 1983) / 4)) : (myYear <= 2099 ? (int)(20.8431 + 0.242194 * (double)(myYear - 1980) - (double)((myYear - 1980) / 4)) : (myYear <= 2150 ? (int)(21.851 + 0.242194 * (double)(myYear - 1980) - (double)((myYear - 1980) / 4)) : 99)));
        return springequinoxRet;
    }

    private static int prvDayOfAutumnEquinox(int myYear) {
        int autumnequinoxRet = myYear <= 1947 ? 99 : (myYear <= 1979 ? (int)(23.2588 + 0.242194 * (double)(myYear - 1980) - (double)((myYear - 1983) / 4)) : (myYear <= 2099 ? (int)(23.2488 + 0.242194 * (double)(myYear - 1980) - (double)((myYear - 1980) / 4)) : (myYear <= 2150 ? (int)(24.2488 + 0.242194 * (double)(myYear - 1980) - (double)((myYear - 1980) / 4)) : 99)));
        return autumnequinoxRet;
    }

    public static String getHolidayName(Calendar myDate) {
        String holidaynameRet = "";
        String holidayName = HolidayUtil.prvHolidayChk(myDate);
        if (holidayName.equals("")) {
            if (myDate.get(7) == 2 && (myDate.after(CST_IMPLEMENT_HOLIDAY) || myDate.equals(CST_IMPLEMENT_HOLIDAY))) {
                Calendar yesterDay = (Calendar)myDate.clone();
                yesterDay.add(5, -1);
                holidayName = HolidayUtil.prvHolidayChk(yesterDay);
                if (!holidayName.equals("")) {
                    holidaynameRet = "\u632f\u66ff\u4f11\u65e5";
                }
            }
        } else {
            holidaynameRet = holidayName;
        }
        return holidaynameRet;
    }
}

