/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ons.common.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Stack;
import jp.co.ons.common.util.LogUtil;
import jp.co.ons.common.util.StringUtil;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

public class FileUtil {
    private static final int BYTE_SIZE = 1024;

    private FileUtil() {
    }

    public static boolean createFile(byte[] aryFileData, String strFileName) {
        if (aryFileData == null || aryFileData.length == 0) {
            return false;
        }
        if (FileUtil.createEmptyFile(strFileName)) {
            FileOutputStream fos = null;
            FilterOutputStream bos = null;
            try {
                try {
                    fos = new FileOutputStream(strFileName);
                    bos = new BufferedOutputStream(fos);
                    ((BufferedOutputStream)bos).write(aryFileData, 0, aryFileData.length);
                }
                catch (Exception exception) {
                    try {
                        bos.close();
                        fos.close();
                    }
                    catch (Exception exception2) {}
                }
            }
            finally {
                try {
                    bos.close();
                    fos.close();
                }
                catch (Exception exception) {}
            }
            return true;
        }
        return false;
    }

    public static boolean createEmptyFile(String strFileName) {
        if (strFileName == null) {
            return false;
        }
        File file = new File(strFileName).getAbsoluteFile();
        try {
            File parent = file.getParentFile();
            if (!parent.isDirectory()) {
                parent.mkdirs();
            }
            if (parent.isDirectory()) {
                file.createNewFile();
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private static boolean doCopy(String strCopyFrom, String strCopyTo) {
        FilterInputStream dis = null;
        FileInputStream fis = null;
        FilterOutputStream dos = null;
        FileOutputStream fos = null;
        try {
            try {
                fis = new FileInputStream(strCopyFrom);
                dis = new DataInputStream(fis);
                fos = new FileOutputStream(strCopyTo);
                dos = new DataOutputStream(fos);
                byte[] tmp = new byte[1024];
                int len = 0;
                while (true) {
                    len = ((DataInputStream)dis).read(tmp);
                    ((DataOutputStream)dos).write(tmp, 0, len);
                }
            }
            catch (Exception tmp) {
                try {
                    fis.close();
                    dis.close();
                    fos.close();
                    dos.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (Throwable throwable) {
            try {
                fis.close();
                dis.close();
                fos.close();
                dos.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        File copyFrom = new File(strCopyFrom);
        File copyTo = new File(strCopyTo);
        return copyFrom.length() == copyTo.length();
    }

    public static boolean copyFile(String strCopyFrom, String strCopyTo) {
        if (strCopyFrom == null) {
            return false;
        }
        File copyFrom = new File(strCopyFrom);
        if (!copyFrom.isFile()) {
            return false;
        }
        if (FileUtil.createEmptyFile(strCopyTo)) {
            return FileUtil.doCopy(strCopyFrom, strCopyTo);
        }
        return false;
    }

    public static boolean copyMove(String strCopyFrom, String strCopyTo) {
        if (!FileUtil.copyFile(strCopyFrom, strCopyTo)) {
            return false;
        }
        return FileUtil.deleteFile(strCopyFrom);
    }

    public static boolean copyBackMove(String strCopyFrom, String strBackDir) {
        return FileUtil.copyBackMove(strCopyFrom, strBackDir, "");
    }

    public static boolean copyBackMove(String strCopyFrom, String strBackDir, String currentDateTime) {
        File file = new File(strCopyFrom);
        String strCopyTo = String.valueOf(file.getParent()) + File.separator + strBackDir + File.separator + currentDateTime + file.getName();
        if (!FileUtil.copyFile(strCopyFrom, strCopyTo)) {
            return false;
        }
        return FileUtil.deleteFile(strCopyFrom);
    }

    public static boolean copyDirMove(String strCopyFrom, String strCopyTo) {
        if (strCopyFrom == null || strCopyFrom.equals("") || strCopyTo == null | strCopyTo.equals("")) {
            return false;
        }
        File fileDir = new File(strCopyFrom);
        if (!fileDir.isDirectory()) {
            return false;
        }
        String[] aryChildList = fileDir.list();
        int i = 0;
        while (i < aryChildList.length) {
            File file = new File(String.valueOf(strCopyFrom) + File.separator + aryChildList[i]);
            if (!file.isDirectory()) {
                FileUtil.copyMove(String.valueOf(strCopyFrom) + File.separator + aryChildList[i], String.valueOf(strCopyTo) + File.separator + aryChildList[i]);
            }
            ++i;
        }
        return true;
    }

    public static boolean deleteFile(String strFileName) {
        return FileUtil.deleteFile(strFileName, null);
    }

    public static boolean deleteFile(String strFileName, Date delTime) {
        if (strFileName == null) {
            return false;
        }
        ArrayList<String> arrayFileList = new ArrayList<String>();
        Stack<String> stkFileList = new Stack<String>();
        try {
            arrayFileList.add(strFileName);
            while (arrayFileList.size() > 0) {
                String strFile = (String)arrayFileList.get(0);
                File file = new File(strFile);
                if (file.isDirectory()) {
                    String[] aryChildList = file.list();
                    int i = 0;
                    while (i < aryChildList.length) {
                        arrayFileList.add(String.valueOf(strFile) + File.separator + aryChildList[i]);
                        ++i;
                    }
                }
                stkFileList.push(strFile);
                arrayFileList.remove(0);
            }
            while (!stkFileList.empty()) {
                long lastModifytime;
                Date lastTime;
                File file = new File((String)stkFileList.pop());
                if (delTime != null && delTime.compareTo(lastTime = new Date(lastModifytime = file.lastModified())) < 0 || file.delete()) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
        finally {
            arrayFileList = null;
            stkFileList = null;
        }
    }

    public static String getExtension(String fileName) {
        if (fileName == null) {
            return "";
        }
        int point = fileName.lastIndexOf(".");
        if (point != -1) {
            return fileName.substring(point + 1);
        }
        return "";
    }

    public static String getFileName(String fileName) {
        if (fileName == null) {
            return "";
        }
        int suffix = fileName.lastIndexOf("\\");
        if (suffix == -1) {
            suffix = fileName.lastIndexOf("/");
        }
        suffix = suffix == -1 ? 0 : ++suffix;
        int point = fileName.lastIndexOf(".");
        if (point == -1) {
            point = fileName.length();
        }
        return fileName.substring(suffix, point);
    }

    public static List<String> getFilePathList(String fileDirPaPath, String extension) {
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtil.isEmpty((String)fileDirPaPath)) {
            return list;
        }
        File fileDir = new File(fileDirPaPath);
        if (!fileDir.isDirectory()) {
            return list;
        }
        String[] aryChildList = fileDir.list();
        int i = 0;
        while (i < aryChildList.length) {
            File file = new File(String.valueOf(fileDirPaPath) + File.separator + aryChildList[i]);
            if (file.isDirectory()) {
                list.addAll(FileUtil.getFilePathList(file.getPath(), extension));
            } else if (StringUtil.isEmpty((String)extension) || FileUtil.getExtension(aryChildList[i]).equals(extension)) {
                list.add(String.valueOf(fileDirPaPath) + File.separator + aryChildList[i]);
            }
            ++i;
        }
        return list;
    }

    public static void createZip(String zip, String file) throws Exception {
        FileUtil.createZip(zip, Arrays.asList(file));
    }

    public static boolean createZip(String zip, Collection<String> files) {
        File target = null;
        BufferedInputStream bis = null;
        ZipOutputStream zos = null;
        try {
            try {
                zos = new ZipOutputStream(new File(zip));
                zos.setEncoding("windows-31j");
                for (String file : files) {
                    int buf;
                    target = new File(file);
                    bis = new BufferedInputStream(new FileInputStream(target));
                    zos.putNextEntry(new ZipEntry(target.getName()));
                    while ((buf = bis.read()) != -1) {
                        zos.write(buf);
                    }
                    bis.close();
                }
                zos.closeEntry();
                zos.close();
            }
            catch (IOException e) {
                LogUtil.error(FileUtil.class, "ZIP\u30d5\u30a1\u30a4\u30eb\u306e\u4f5c\u6210\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", e);
                try {
                    if (bis != null) {
                        bis.close();
                    }
                    if (zos != null) {
                        zos.closeEntry();
                        zos.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return false;
            }
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
                if (zos != null) {
                    zos.closeEntry();
                    zos.close();
                }
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    public static boolean isFile(String filePath) {
        if (filePath == null) {
            return false;
        }
        File file = new File(filePath);
        return !file.isFile();
    }
}

