/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ons.common.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import jp.co.ons.common.util.StringUtil;

public class DateUtil {
    public static final String YYYY = "yyyy";
    public static final String MM = "MM";
    public static final String DD = "dd";
    public static final String YYYYMM = "yyyyMM";
    public static final String YYYYMMDD = "yyyyMMdd";
    public static final String YYYYMMDDHH = "yyyyMMddHH";
    public static final String YYYYMMDDHHMM = "yyyyMMddHHmm";
    public static final String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final String YYYYMMDDHHMMSS_S = "yyyyMMddHHmmssS";
    public static final String YYYYMM_SLASH = "yyyy/MM";
    public static final String YYYYMMDD_SLASH = "yyyy/MM/dd";
    public static final String YYYYMMDDHH_SLASH = "yyyy/MM/dd HH";
    public static final String YYYYMMDDHHMM_SLASH = "yyyy/MM/dd HH:mm";
    public static final String YYYYMMDDHHMMSS_SLASH = "yyyy/MM/dd HH:mm:ss";
    public static final String YYYYMMDDHHMMSS_S_SLASH = "yyyy/MM/dd HH:mm:ss.S";
    public static final String MAX_DATE = "2999/12/31";

    private DateUtil() {
    }

    public static Date getMaxDate() {
        return DateUtil.convDate(MAX_DATE);
    }

    public static Date convDate(String data) {
        return DateUtil.convDate(data, YYYYMMDD_SLASH);
    }

    public static Date convDate(String data, String format) {
        return DateUtil.convDate(data, format, true);
    }

    public static Date convDate(String data, String format, boolean lenient) {
        Date date;
        if (StringUtil.isEmpty((String)data)) {
            return null;
        }
        SimpleDateFormat sf = new SimpleDateFormat(format);
        try {
            sf.setLenient(lenient);
            date = sf.parse(data);
        }
        catch (ParseException e) {
            date = null;
        }
        return date;
    }

    public static String convDate(Date data) {
        return DateUtil.convDate(data, YYYYMMDD_SLASH);
    }

    public static String convDate(Date data, String format) {
        return DateUtil.convDate(data, format, true);
    }

    public static String convDate(Date data, String format, boolean lenient) {
        if (data == null) {
            return null;
        }
        SimpleDateFormat sf = new SimpleDateFormat(format);
        sf.setLenient(lenient);
        return sf.format(data);
    }

    public static String convDate(String data, String format1, String format2) {
        Date date = DateUtil.convDate(data, format1);
        return DateUtil.convDate(date, format2);
    }

    public static Timestamp convDateToTimestamp(Date data) {
        Date d = data;
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        Timestamp d2 = new Timestamp(cal.getTimeInMillis());
        return d2;
    }

    public static Date addDate(Date data, int val) {
        if (data == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(data);
        cal.add(5, val);
        return cal.getTime();
    }

    public static Date addMonth(Date data, int val) {
        if (data == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(data);
        cal.add(2, val);
        return cal.getTime();
    }

    public static String addMonthYyyyMm(String ym, int val) {
        return DateUtil.addMonthYyyyMm(ym, val, YYYYMM);
    }

    public static String addMonthYyyyMm(String ym, int val, String format) {
        if (ym == null) {
            return null;
        }
        String ymd = String.valueOf(ym.replaceAll("/", "")) + "01";
        Date addYmd = DateUtil.convDate(ymd, YYYYMMDD);
        String addYmdS = DateUtil.convDate(DateUtil.addMonth(addYmd, val), format);
        return addYmdS;
    }

    public static int getLastDayInt(Date data) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(data);
        cal.add(2, 1);
        cal.set(5, 1);
        cal.add(5, -1);
        int days = cal.get(5);
        return days;
    }

    public static int getLastDayInt(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, 1);
        cal.add(2, 1);
        cal.set(5, 1);
        cal.add(5, -1);
        int days = cal.get(5);
        return days;
    }

    public static Date getLastDayDate(Date data) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(data);
        cal.add(2, 1);
        cal.set(5, 1);
        cal.add(5, -1);
        return cal.getTime();
    }

    public static Date getLastDayDate(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, 1);
        cal.add(2, 1);
        cal.set(5, 1);
        cal.add(5, -1);
        return cal.getTime();
    }

    public static String getLastDate(String ymd) {
        return DateUtil.convDate(DateUtil.getLastDayDate(DateUtil.convDate(StringUtil.replace(ymd, "/", ""), YYYYMMDD)), YYYYMMDD);
    }

    public static Date getNextMonthFirstDay(Date data) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(data);
        cal.add(2, 1);
        cal.set(5, 1);
        return cal.getTime();
    }

    public static Date getNextMonthFirstDay(String data) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.convDate(data));
        cal.add(2, 1);
        cal.set(5, 1);
        return cal.getTime();
    }

    public static Date getSysDate() {
        return new Date();
    }

    public static Date getSysDate(String format) {
        String date = DateUtil.convDate(DateUtil.getSysDate(), format);
        return DateUtil.convDate(date, format);
    }

    public static Date getSysDateMonthFirstDay() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.getSysDate());
        cal.set(5, 1);
        return cal.getTime();
    }

    public static String japaneseCalendar(Date date) {
        Locale locale = new Locale("ja", "JP", "JP");
        SimpleDateFormat format = new SimpleDateFormat("GGGGyyyy\u5e74MM\u6708dd\u65e5", locale);
        return format.format(date);
    }

    public static int differenceDays(String strDate1, String strDate2) throws ParseException {
        Date date1 = DateUtil.convDate(strDate1, YYYYMMDD);
        Date date2 = DateUtil.convDate(strDate2, YYYYMMDD);
        return DateUtil.differenceDays(date1, date2);
    }

    public static int differenceDays(Date date1, Date date2) {
        long datetime1 = date1.getTime();
        long datetime2 = date2.getTime();
        long one_date_time = 86400000L;
        long diffDays = (datetime1 - datetime2) / one_date_time;
        return (int)diffDays;
    }
}

