/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ons.common.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import jp.co.ons.common.util.FileUtil;
import jp.co.ons.common.util.StringUtil;

public class CsvUtil {
    private CsvUtil() {
    }

    public static void createCsv(String filePaht, List<List<String>> csvData, String charset) throws Exception {
        CsvUtil.createCsv(filePaht, csvData, charset, "\r\n");
    }

    public static void createCsv(String filePaht, List<List<String>> csvData, String charset, String lineSeparator) throws Exception {
        if (StringUtil.isEmpty((String)filePaht)) {
            return;
        }
        if (!FileUtil.createEmptyFile(filePaht)) {
            return;
        }
        if (csvData == null || csvData.isEmpty()) {
            return;
        }
        String wkCharset = null;
        wkCharset = StringUtil.isEmpty((String)charset) ? "windows-31j" : charset;
        BufferedWriter bw = null;
        try {
            File csv = new File(filePaht);
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(csv, true), wkCharset));
            for (List<String> csvLine : csvData) {
                if (csvLine == null || csvLine.isEmpty()) continue;
                int i = 0;
                while (i < csvLine.size()) {
                    String column = csvLine.get(i);
                    bw.write(StringUtil.nvl(column));
                    if (i + 1 < csvLine.size()) {
                        bw.write(",");
                    }
                    ++i;
                }
                bw.write(lineSeparator);
            }
        }
        finally {
            if (bw != null) {
                bw.close();
            }
        }
    }
}

