/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ons.common.util;

import java.math.BigDecimal;
import java.util.Date;
import jp.co.ons.common.util.DateUtil;
import jp.co.ons.common.util.StringUtil;

public class ConvUtil {
    private ConvUtil() {
    }

    public static String convString(Object obj) {
        return (String)ConvUtil.convObject(String.class, obj, null);
    }

    public static String convString(Object obj, String format) {
        return (String)ConvUtil.convObject(String.class, obj, format);
    }

    public static Integer convInteger(Object obj) {
        return (Integer)ConvUtil.convObject(Integer.class, obj, null);
    }

    public static Integer convIntegerNoThrow(Object obj) {
        Integer val = null;
        try {
            val = (Integer)ConvUtil.convObject(Integer.class, obj, null);
        }
        catch (Exception e) {
            val = null;
        }
        return val;
    }

    public static BigDecimal convBigDecimal(Object obj) {
        return (BigDecimal)ConvUtil.convObject(BigDecimal.class, obj, null);
    }

    public static BigDecimal convBigDecimalNoThrow(Object obj) {
        BigDecimal val = null;
        try {
            val = (BigDecimal)ConvUtil.convObject(BigDecimal.class, obj, null);
        }
        catch (Exception e) {
            val = null;
        }
        return val;
    }

    public static BigDecimal convBigDecimalZero(Object obj) {
        BigDecimal val = ConvUtil.convBigDecimalComma(obj);
        return ConvUtil.nvlZero(val);
    }

    public static BigDecimal nvlZero(BigDecimal val) {
        if (val == null) {
            return BigDecimal.ZERO;
        }
        return val;
    }

    public static Date convDate(Object obj, String format) {
        return (Date)ConvUtil.convObject(Date.class, obj, format);
    }

    public static Date convDateNoThrow(Object obj, String format) {
        Date val = null;
        try {
            val = (Date)ConvUtil.convObject(Date.class, obj, format);
        }
        catch (Exception e) {
            val = null;
        }
        return val;
    }

    public static BigDecimal convBigDecimalComma(Object val) {
        String tmp = ConvUtil.convString(val);
        if (StringUtil.isEmpty((String)tmp)) {
            return null;
        }
        String val2 = StringUtil.replace(tmp, ",", "");
        return ConvUtil.convBigDecimalNoThrow(val2);
    }

    public static Object convObject(Class cls, Object obj, String format) {
        if (obj == null) {
            return null;
        }
        if (cls == String.class) {
            if (obj instanceof String) {
                return obj;
            }
            if (obj instanceof Short) {
                return ((Short)obj).toString();
            }
            if (obj instanceof Integer) {
                return ((Integer)obj).toString();
            }
            if (obj instanceof Long) {
                return ((Long)obj).toString();
            }
            if (obj instanceof Float) {
                return ((Float)obj).toString();
            }
            if (obj instanceof Double) {
                return ((Double)obj).toString();
            }
            if (obj instanceof BigDecimal) {
                return ((BigDecimal)obj).toString();
            }
            if (obj instanceof Date) {
                if (!StringUtil.isEmpty((String)format)) {
                    return DateUtil.convDate((Date)obj, format);
                }
                return DateUtil.convDate((Date)obj, "yyyyMMdd");
            }
            return null;
        }
        if (cls == Short.class) {
            if (obj instanceof String) {
                if (!StringUtil.isEmpty((String)((String)obj))) {
                    return new Short((String)obj);
                }
                return null;
            }
            if (obj instanceof Short) {
                return obj;
            }
            if (obj instanceof Integer) {
                return ((Integer)obj).shortValue();
            }
            if (obj instanceof Long) {
                return Short.valueOf(((Long)obj).toString());
            }
            if (obj instanceof Float) {
                return Short.valueOf(((Float)obj).toString());
            }
            if (obj instanceof Double) {
                return Short.valueOf(((Double)obj).toString());
            }
            if (obj instanceof BigDecimal) {
                return Short.valueOf(((BigDecimal)obj).toString());
            }
            if (obj instanceof Date) {
                return Short.valueOf(String.valueOf(((Date)obj).getTime()));
            }
            return null;
        }
        if (cls == Integer.class) {
            if (obj instanceof String) {
                if (!StringUtil.isEmpty((String)((String)obj))) {
                    return new Integer((String)obj);
                }
                return null;
            }
            if (obj instanceof Short) {
                return Integer.valueOf(((Short)obj).toString());
            }
            if (obj instanceof Integer) {
                return obj;
            }
            if (obj instanceof Long) {
                return Integer.valueOf(((Long)obj).toString());
            }
            if (obj instanceof Float) {
                return Integer.valueOf(((Float)obj).toString());
            }
            if (obj instanceof Double) {
                return Integer.valueOf(((Double)obj).toString());
            }
            if (obj instanceof BigDecimal) {
                return Integer.valueOf(((BigDecimal)obj).toString());
            }
            if (obj instanceof Date) {
                return Integer.valueOf(String.valueOf(((Date)obj).getTime()));
            }
            return null;
        }
        if (cls == Long.class) {
            if (obj instanceof String) {
                if (!StringUtil.isEmpty((String)((String)obj))) {
                    return new Long((String)obj);
                }
                return null;
            }
            if (obj instanceof Short) {
                return Long.valueOf(((Short)obj).toString());
            }
            if (obj instanceof Integer) {
                return Long.valueOf(((Integer)obj).toString());
            }
            if (obj instanceof Long) {
                return obj;
            }
            if (obj instanceof Float) {
                return Long.valueOf(((Float)obj).toString());
            }
            if (obj instanceof Double) {
                return Long.valueOf(((Double)obj).toString());
            }
            if (obj instanceof BigDecimal) {
                return Long.valueOf(((BigDecimal)obj).toString());
            }
            if (obj instanceof Date) {
                return Long.valueOf(String.valueOf(((Date)obj).getTime()));
            }
            return null;
        }
        if (cls == Float.class) {
            if (obj instanceof String) {
                if (!StringUtil.isEmpty((String)((String)obj))) {
                    return new Float((String)obj);
                }
                return null;
            }
            if (obj instanceof Short) {
                return Float.valueOf(((Short)obj).toString());
            }
            if (obj instanceof Integer) {
                return Float.valueOf(((Integer)obj).toString());
            }
            if (obj instanceof Long) {
                return Float.valueOf(((Long)obj).toString());
            }
            if (obj instanceof Float) {
                return obj;
            }
            if (obj instanceof Double) {
                return Float.valueOf(((Double)obj).toString());
            }
            if (obj instanceof BigDecimal) {
                return Float.valueOf(((BigDecimal)obj).toString());
            }
            if (obj instanceof Date) {
                return Float.valueOf(String.valueOf(((Date)obj).getTime()));
            }
            return null;
        }
        if (cls == Double.class) {
            if (obj instanceof String) {
                if (!StringUtil.isEmpty((String)((String)obj))) {
                    return new Double((String)obj);
                }
                return null;
            }
            if (obj instanceof Short) {
                return Double.valueOf(((Short)obj).toString());
            }
            if (obj instanceof Integer) {
                return Double.valueOf(((Integer)obj).toString());
            }
            if (obj instanceof Long) {
                return Double.valueOf(((Long)obj).toString());
            }
            if (obj instanceof Float) {
                return Double.valueOf(((Float)obj).toString());
            }
            if (obj instanceof Double) {
                return obj;
            }
            if (obj instanceof BigDecimal) {
                return Double.valueOf(((BigDecimal)obj).toString());
            }
            if (obj instanceof Date) {
                return Double.valueOf(String.valueOf(((Date)obj).getTime()));
            }
            return null;
        }
        if (cls == BigDecimal.class) {
            if (obj instanceof String) {
                if (!StringUtil.isEmpty((String)((String)obj))) {
                    return new BigDecimal((String)obj);
                }
                return null;
            }
            if (obj instanceof Short) {
                return new BigDecimal(((Short)obj).toString());
            }
            if (obj instanceof Integer) {
                return new BigDecimal(((Integer)obj).toString());
            }
            if (obj instanceof Long) {
                return new BigDecimal(((Long)obj).toString());
            }
            if (obj instanceof Float) {
                return new BigDecimal(((Float)obj).toString());
            }
            if (obj instanceof Double) {
                return new BigDecimal(((Double)obj).toString());
            }
            if (obj instanceof BigDecimal) {
                return obj;
            }
            if (obj instanceof Date) {
                return new BigDecimal(String.valueOf(((Date)obj).getTime()));
            }
            return null;
        }
        if (cls == Date.class) {
            if (obj instanceof String) {
                if (!StringUtil.isEmpty((String)format)) {
                    return DateUtil.convDate((String)obj, format);
                }
                return DateUtil.convDate((String)obj, "yyyyMMdd");
            }
            if (obj instanceof Date) {
                return obj;
            }
            return null;
        }
        return obj;
    }
}

