/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ons.common.base;

import java.util.Map;
import jp.co.ons.common.util.FileUtil;
import jp.co.ons.common.util.LogUtil;
import jp.co.ons.common.util.PrintIdManager;

public abstract class BasePrintLogic {
    private static final String PG_ID = "BasePrintLogic";
    private String pritId;
    private String jasperFilePath;
    private String csvFilePath;
    private String outFilePath;

    protected String getPgId() {
        return PG_ID;
    }

    public boolean execute(String[] args) throws Exception {
        boolean result = false;
        this.pritId = args[2];
        this.csvFilePath = args[3];
        this.outFilePath = args[4];
        LogUtil.info(this.getClass(), "\u5e33\u7968\u306e\u51fa\u529b\u958b\u59cb:pritId[" + this.pritId + "][" + this.csvFilePath + "]");
        result = this.executeSub(args[0]);
        LogUtil.info(this.getClass(), "\u5e33\u7968\u306e\u51fa\u529b\u7d42\u4e86");
        return result;
    }

    public boolean executeSub(String propertiesDir) throws Exception {
        this.jasperFilePath = PrintIdManager.getInstance().getPath(this.pritId);
        this.jasperFilePath = String.valueOf(propertiesDir) + "/../" + this.jasperFilePath;
        if (FileUtil.isFile(this.jasperFilePath)) {
            LogUtil.error(this.getClass(), "JASPER\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002\uff1a" + this.jasperFilePath);
            return false;
        }
        if (FileUtil.isFile(this.csvFilePath)) {
            LogUtil.error(this.getClass(), "CSV\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002\uff1a" + this.csvFilePath);
            return false;
        }
        return this.run();
    }

    public Map<String, String> getPrintInfo() throws Exception {
        return PrintIdManager.getInstance().getPrintInfo(this.pritId);
    }

    protected abstract boolean run() throws Exception;

    public String getJasperFilePath() {
        return this.jasperFilePath;
    }

    public String getCsvFilePath() {
        return this.csvFilePath;
    }

    public String getOutFilePath() {
        return this.outFilePath;
    }
}

