package com.merlin204.tde.util;

import com.lowdragmc.photon.client.fx.FX;
import com.lowdragmc.photon.client.fx.FXHelper;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunction3;
import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.client.CameraShake;
import com.merlin204.tde.entity.enemy.EnemyEntity;
import com.merlin204.tde.entity.player.TDELocalPlayerPatch;
import com.merlin204.tde.entity.player.TDEServerPlayerPatch;
import com.merlin204.tde.photon.JointEffect;
import com.merlin204.tde.photon.PosEffect;
import com.merlin204.tde.util.TDEAbilityUtils;
import com.merlin204.tde.util.TDEAnimationUtils;
import com.merlin204.tde.world.TDEDamageSource;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.AnimationManager.AnimationAccessor;
import yesman.epicfight.api.animation.property.AnimationParameters;
import yesman.epicfight.api.animation.property.AnimationEvent.Event;
import yesman.epicfight.api.animation.property.AnimationEvent.InPeriodEvent;
import yesman.epicfight.api.animation.property.AnimationEvent.InTimeEvent;
import yesman.epicfight.api.animation.property.AnimationEvent.Side;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.utils.LevelUtil;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.renderer.patched.item.RenderItemBase;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.model.armature.HumanoidArmature;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class TDEEventUtils {

   public static InPeriodEvent rotateToTarget(int startFrame, int endFrame, float step) {
      float start = (float)startFrame / 60.0F;
      float end = (float)endFrame / 60.0F;
      return InPeriodEvent.create(start, end, (Event)step, Side.SERVER);
   }

   public static InPeriodEvent chaseToTarget(int startFrame, int endFrame, float speed, float distance) {
      float start = (float)startFrame / 60.0F;
      float end = (float)endFrame / 60.0F;
      return InPeriodEvent.create(end, distance, (Event)speed, Side.SERVER);
   }

   public static InPeriodEvent hurtNearTarget(int startFrame, int endFrame, float damage, int impactLevel, int intervalTick, float distance) {
      float start = (float)startFrame / 60.0F;
      float end = (float)endFrame / 60.0F;
      return InPeriodEvent.create(intervalTick, impactLevel, (Event)damage, Side.SERVER);
   }

   public static InPeriodEvent fxTrail(int startFrame, int endFrame, Joint joint, Vec3 startOffset, Vec3 endOffset, float timeInterpolation, int fxCount, String path, float random) {
      float start = (float)startFrame / 60.0F;
      float end = (float)endFrame / 60.0F;
      return InPeriodEvent.create(fxCount, random, joint, Side.CLIENT);
   }

   public static InPeriodEvent particleTrail(int startFrame, int endFrame, Joint joint, Vec3 startOffset, Vec3 endOffset, float timeInterpolation, int particleCount, ParticleOptions particleOptions, float random) {
      float start = (float)startFrame / 60.0F;
      float end = (float)endFrame / 60.0F;
      return InPeriodEvent.create(random, (float)joint, particleOptions, Side.CLIENT);
   }

   public static InPeriodEvent particleTrail(int startFrame, int endFrame, InteractionHand hand, Vec3 startOffset, Vec3 endOffset, float timeInterpolation, int particleCount, ParticleOptions particleOptions, float random) {
      float start = (float)startFrame / 60.0F;
      float end = (float)endFrame / 60.0F;
      Joint joint = null;
      switch(null.$SwitchMap$net$minecraft$world$InteractionHand[hand.ordinal()]) {
      case 1:
         joint = ((HumanoidArmature)Armatures.BIPED.get()).toolR;
         break;
      case 2:
         joint = ((HumanoidArmature)Armatures.BIPED.get()).toolL;
      }

      return InPeriodEvent.create(random, (float)joint, particleOptions, Side.CLIENT);
   }

   public static InPeriodEvent particleTrail(int startFrame, int endFrame, InteractionHand hand, float timeInterpolation, int particleCount, ParticleOptions particleOptions, float random) {
      float start = (float)startFrame / 60.0F;
      float end = (float)endFrame / 60.0F;
      Joint joint = null;
      switch(null.$SwitchMap$net$minecraft$world$InteractionHand[hand.ordinal()]) {
      case 1:
         joint = ((HumanoidArmature)Armatures.BIPED.get()).toolR;
         break;
      case 2:
         joint = ((HumanoidArmature)Armatures.BIPED.get()).toolL;
      }

      return InPeriodEvent.create(random, (float)joint, particleOptions, Side.CLIENT);
   }

   public static InPeriodEvent playerGroundSplitAtk(int startFrame, int endFrame, InteractionHand hand, float radius) {
      float start = (float)startFrame / 60.0F;
      float end = (float)endFrame / 60.0F;
      Joint joint = null;
      switch(null.$SwitchMap$net$minecraft$world$InteractionHand[hand.ordinal()]) {
      case 1:
         joint = ((HumanoidArmature)Armatures.BIPED.get()).toolR;
         break;
      case 2:
         joint = ((HumanoidArmature)Armatures.BIPED.get()).toolL;
      }

      return InPeriodEvent.create((float)hand, (float)joint, (Event)radius, Side.BOTH);
   }

   public static InPeriodEvent allBackTime(int param0, int param1) {
      // $FF: Couldn't be decompiled
   }

   public static InPeriodEvent mainBackTime(int param0, int param1) {
      // $FF: Couldn't be decompiled
   }

   public static InPeriodEvent offBackTime(int param0, int param1) {
      // $FF: Couldn't be decompiled
   }

   public static InTimeEvent simpleSound(int startFrame, SoundEvent soundEvent, float volume, float pitch) {
      float start = (float)startFrame / 60.0F;
      return InTimeEvent.create(volume, (Event)pitch, Side.BOTH);
   }

   public static InTimeEvent simpleCameraShake(int startFrame, int duration, float intensity, float frequency, float radius) {
      float start = (float)startFrame / 60.0F;
      return InTimeEvent.create(frequency, (Event)radius, Side.CLIENT);
   }

   public static InTimeEvent costManaEvent(int startFrame, float cost) {
      float start = (float)startFrame / 60.0F;
      return InTimeEvent.create(start, (Event)cost, Side.SERVER);
   }

   public static InTimeEvent costEnergyEvent(int startFrame, float cost) {
      float start = (float)startFrame / 60.0F;
      return InTimeEvent.create(start, (Event)cost, Side.SERVER);
   }

   public static InTimeEvent creatPosFxEvent(int startFrame, String Fx, int maxaAge, boolean updatePos) {
      float start = (float)startFrame / 60.0F;
      return InTimeEvent.create(maxaAge, (Event)updatePos, Side.CLIENT);
   }

   public static InPeriodEvent creatTiemFxEvent(int startFrame, int endFrame, String Fx, Joint joint, Vec3f offset, int maxaAge, boolean updatePos) {
      float start = (float)startFrame / 60.0F;
      float end = (float)endFrame / 60.0F;
      return InPeriodEvent.create((float)offset, maxaAge, (Event)updatePos, Side.CLIENT);
   }

   public static InTimeEvent creatSimpleFxEvent(int startFrame, String Fx, Joint joint, int maxaAge, boolean updatePos) {
      float start = (float)startFrame / 60.0F;
      return InTimeEvent.create(maxaAge, (Event)updatePos, Side.CLIENT);
   }

   public static InTimeEvent creatSimpleFxEvent(int startFrame, String Fx, Joint joint, Vec3f offset, int maxaAge, boolean updatePos) {
      float start = (float)startFrame / 60.0F;
      return InTimeEvent.create(maxaAge, (Event)updatePos, Side.CLIENT);
   }

   public static InTimeEvent creatSimpleSyncRotFxEvent(int startFrame, String Fx, Joint joint, int maxaAge, boolean updatePos) {
      float start = (float)startFrame / 60.0F;
      return InTimeEvent.create(maxaAge, (Event)updatePos, Side.CLIENT);
   }

   public static InTimeEvent simpleGroundSplit(int startFrame, double viewOffset, double xOffset, double yOffset, double zOffset, float radius, int impactLevel) {
      float start = (float)startFrame / 60.0F;
      return InTimeEvent.create(radius, (Event)impactLevel, Side.BOTH);
   }

   public static InTimeEvent simpleFXGroundSplit(int startFrame, String Fx, int maxAge, double viewOffset, double xOffset, double yOffset, double zOffset, float radius, int impactLevel) {
      float start = (float)startFrame / 60.0F;
      return InTimeEvent.create(radius, (Event)impactLevel, Side.BOTH);
   }

   public static InTimeEvent simpleGroundSplit(int startFrame, double viewOffset, double xOffset, double yOffset, double zOffset, float radius) {
      float start = (float)startFrame / 60.0F;
      return InTimeEvent.create((float)zOffset, (Event)radius, Side.BOTH);
   }

   public static InTimeEvent simpleFXGroundSplit(int startFrame, String Fx, int maxAge, double viewOffset, double xOffset, double yOffset, double zOffset, float radius) {
      float start = (float)startFrame / 60.0F;
      return InTimeEvent.create((float)zOffset, (Event)radius, Side.BOTH);
   }

   // $FF: synthetic method
   private static void lambda$simpleFXGroundSplit$23(String Fx, int maxAge, double viewOffset, double xOffset, double yOffset, double zOffset, float radius, LivingEntityPatch entityPatch, AssetAccessor self, AnimationParameters params) {
      TDEAnimationUtils.groundFXSplit(entityPatch, Fx, maxAge, viewOffset, xOffset, yOffset, zOffset, radius, 3);
   }

   // $FF: synthetic method
   private static void lambda$simpleGroundSplit$22(double viewOffset, double xOffset, double yOffset, double zOffset, float radius, LivingEntityPatch entityPatch, AssetAccessor self, AnimationParameters params) {
      TDEAnimationUtils.groundSplit(entityPatch, viewOffset, xOffset, yOffset, zOffset, radius, 3);
   }

   // $FF: synthetic method
   private static void lambda$simpleFXGroundSplit$21(String Fx, int maxAge, double viewOffset, double xOffset, double yOffset, double zOffset, float radius, int impactLevel, LivingEntityPatch entityPatch, AssetAccessor self, AnimationParameters params) {
      TDEAnimationUtils.groundFXSplit(entityPatch, Fx, maxAge, viewOffset, xOffset, yOffset, zOffset, radius, impactLevel);
   }

   // $FF: synthetic method
   private static void lambda$simpleGroundSplit$20(double viewOffset, double xOffset, double yOffset, double zOffset, float radius, int impactLevel, LivingEntityPatch entityPatch, AssetAccessor self, AnimationParameters params) {
      TDEAnimationUtils.groundSplit(entityPatch, viewOffset, xOffset, yOffset, zOffset, radius, impactLevel);
   }

   // $FF: synthetic method
   private static void lambda$creatSimpleSyncRotFxEvent$19(String Fx, Joint joint, int maxaAge, boolean updatePos, LivingEntityPatch entityPatch, AssetAccessor self, AnimationParameters params) {
      Entity entity = entityPatch.getOriginal();
      FX fx = FXHelper.getFX(new ResourceLocation(Fx));
      fx.createRuntime(true);
      JointEffect effect = new JointEffect(fx, entity.m_9236_(), entity, joint, new Vec3f(0.0F, 0.0F, 0.0F), maxaAge, updatePos, true, new NumberFunction3(Integer.valueOf(0), Float.valueOf(-entity.m_146908_()), Integer.valueOf(0)));
      effect.setRotation(0.0D, (double)(-entity.m_146908_()), 0.0D);
      effect.start();
   }

   // $FF: synthetic method
   private static void lambda$creatSimpleFxEvent$18(String Fx, Joint joint, Vec3f offset, int maxaAge, boolean updatePos, LivingEntityPatch entityPatch, AssetAccessor self, AnimationParameters params) {
      Entity entity = entityPatch.getOriginal();
      FX fx = FXHelper.getFX(new ResourceLocation(Fx));
      fx.createRuntime(true);
      (new JointEffect(fx, entity.m_9236_(), entity, joint, offset, maxaAge, updatePos, true)).start();
   }

   // $FF: synthetic method
   private static void lambda$creatSimpleFxEvent$17(String Fx, Joint joint, int maxaAge, boolean updatePos, LivingEntityPatch entityPatch, AssetAccessor self, AnimationParameters params) {
      Entity entity = entityPatch.getOriginal();
      FX fx = FXHelper.getFX(new ResourceLocation(Fx));
      fx.createRuntime(true);
      (new JointEffect(fx, entity.m_9236_(), entity, joint, maxaAge, updatePos)).start();
   }

   // $FF: synthetic method
   private static void lambda$creatTiemFxEvent$16(String Fx, Joint joint, Vec3f offset, int maxaAge, boolean updatePos, LivingEntityPatch entityPatch, AssetAccessor self, AnimationParameters params) {
      Entity entity = entityPatch.getOriginal();
      FX fx = FXHelper.getFX(new ResourceLocation(Fx));
      fx.createRuntime(true);
      (new JointEffect(fx, entity.m_9236_(), entity, joint, offset, maxaAge, updatePos, true)).start();
   }

   // $FF: synthetic method
   private static void lambda$creatPosFxEvent$15(String Fx, int maxaAge, boolean updatePos, LivingEntityPatch entityPatch, AssetAccessor self, AnimationParameters params) {
      Entity entity = entityPatch.getOriginal();
      FX fx = FXHelper.getFX(new ResourceLocation(Fx));
      fx.createRuntime(true);
      JointEffect effect = new JointEffect(fx, entity.m_9236_(), entity, (Joint)null, new Vec3f(0.0F, 0.0F, 0.0F), maxaAge, updatePos, true);
      effect.setRotation(0.0D, (double)(-entity.m_146908_()), 0.0D);
      effect.start();
   }

   // $FF: synthetic method
   private static void lambda$costEnergyEvent$14(float cost, LivingEntityPatch entityPatch, AssetAccessor self, AnimationParameters params) {
      Entity patt19356$temp = entityPatch.getOriginal();
      if(patt19356$temp instanceof EnemyEntity) {
         EnemyEntity tdeServerPlayerPatch = (EnemyEntity)patt19356$temp;
         if(cost > tdeServerPlayerPatch.getMaxEnergy() * 0.25F && (double)tdeServerPlayerPatch.getEnergy() < (double)tdeServerPlayerPatch.getMaxEnergy() * 0.25D) {
            tdeServerPlayerPatch.costEnergy(cost);
         }
      }

      if(entityPatch instanceof TDEServerPlayerPatch) {
         TDEServerPlayerPatch tdeServerPlayerPatch1 = (TDEServerPlayerPatch)entityPatch;
         tdeServerPlayerPatch1.costEnergy(cost);
      }

   }

   // $FF: synthetic method
   private static void lambda$costManaEvent$13(float cost, LivingEntityPatch entityPatch, AssetAccessor self, AnimationParameters params) {
      if(entityPatch instanceof TDEServerPlayerPatch) {
         TDEServerPlayerPatch tdeServerPlayerPatch = (TDEServerPlayerPatch)entityPatch;
         TDEAbilityUtils.subAbility(AbilityType.MANA, (Player)tdeServerPlayerPatch.getOriginal(), cost);
      }

   }

   // $FF: synthetic method
   private static void lambda$simpleCameraShake$12(int duration, float intensity, float frequency, float radius, LivingEntityPatch entityPatch, AssetAccessor self, AnimationParameters params) {
      CameraShake.shake(duration, intensity, frequency, ((LivingEntity)entityPatch.getOriginal()).m_20182_(), radius);
   }

   // $FF: synthetic method
   private static void lambda$simpleSound$11(SoundEvent soundEvent, float volume, float pitch, LivingEntityPatch entityPatch, AssetAccessor self, AnimationParameters params) {
      ((LivingEntity)entityPatch.getOriginal()).m_5496_(soundEvent, volume, pitch);
   }

   // $FF: synthetic method
   private static void lambda$offBackTime$10(LivingEntityPatch entityPatch, AssetAccessor self, AnimationParameters params) {
      if(entityPatch instanceof TDELocalPlayerPatch) {
         TDELocalPlayerPatch localPlayerPatch = (TDELocalPlayerPatch)entityPatch;
         localPlayerPatch.offBackTick = 5;
      }

   }

   // $FF: synthetic method
   private static void lambda$mainBackTime$9(LivingEntityPatch entityPatch, AssetAccessor self, AnimationParameters params) {
      if(entityPatch instanceof TDELocalPlayerPatch) {
         TDELocalPlayerPatch localPlayerPatch = (TDELocalPlayerPatch)entityPatch;
         localPlayerPatch.mainBackTick = 5;
      }

   }

   // $FF: synthetic method
   private static void lambda$allBackTime$8(LivingEntityPatch entityPatch, AssetAccessor self, AnimationParameters params) {
      if(entityPatch instanceof TDELocalPlayerPatch) {
         TDELocalPlayerPatch localPlayerPatch = (TDELocalPlayerPatch)entityPatch;
         localPlayerPatch.mainBackTick = 5;
         localPlayerPatch.offBackTick = 5;
      }

   }

   // $FF: synthetic method
   private static void lambda$playerGroundSplitAtk$7(InteractionHand hand, Joint finalJoint, float radius, LivingEntityPatch entityPatch, AssetAccessor self, AnimationParameters params) {
      AnimationPlayer player = entityPatch.getAnimator().getPlayerFor((AssetAccessor)null);
      float prevElapsedTime = player.getPrevElapsedTime();
      float elapsedTime = player.getElapsedTime();
      float step = (elapsedTime - prevElapsedTime) / 30.0F;
      ItemStack stack = ((LivingEntity)entityPatch.getOriginal()).m_21120_(hand);
      RenderItemBase renderItemBase = ClientEngine.getInstance().renderEngine.getItemRenderer(stack);
      if(renderItemBase.trailInfo() != null) {
         Vec3 trailStartOffset = renderItemBase.trailInfo().start();
         Vec3 trailEndOffset = renderItemBase.trailInfo().end();
         Vec3f trailDirection = new Vec3f((float)(trailEndOffset.f_82479_ - trailStartOffset.f_82479_), (float)(trailEndOffset.f_82480_ - trailStartOffset.f_82480_), (float)(trailEndOffset.f_82481_ - trailStartOffset.f_82481_));

         for(float f = prevElapsedTime; f <= elapsedTime; f += step) {
            byte particleCount = 10;

            for(int i = 0; i <= particleCount; ++i) {
               float ratio = (float)i / (float)particleCount;
               Vec3f pointOffset = new Vec3f((float)(trailStartOffset.f_82479_ + (double)(trailDirection.x * ratio)), (float)(trailStartOffset.f_82480_ + (double)(trailDirection.y * ratio)), (float)(trailStartOffset.f_82481_ + (double)(trailDirection.z * ratio)));
               Vec3 worldPos = TDEAnimationUtils.getJointWorldRawPos(entityPatch, finalJoint, f + step, pointOffset);
               if(!((LivingEntity)entityPatch.getOriginal()).m_9236_().f_46443_) {
                  LevelUtil.circleSlamFracture((LivingEntity)entityPatch.getOriginal(), ((LivingEntity)entityPatch.getOriginal()).m_9236_(), worldPos, (double)radius, false);
               }
            }
         }

      }
   }

   // $FF: synthetic method
   private static void lambda$particleTrail$6(float timeInterpolation, InteractionHand hand, int particleCount, float random, Joint finalJoint, ParticleOptions particleOptions, LivingEntityPatch entityPatch, AssetAccessor self, AnimationParameters params) {
      AnimationPlayer player = entityPatch.getAnimator().getPlayerFor((AssetAccessor)null);
      float prevElapsedTime = player.getPrevElapsedTime();
      float elapsedTime = player.getElapsedTime();
      float step = (elapsedTime - prevElapsedTime) / timeInterpolation;
      ItemStack stack = ((LivingEntity)entityPatch.getOriginal()).m_21120_(hand);
      RenderItemBase renderItemBase = ClientEngine.getInstance().renderEngine.getItemRenderer(stack);
      if(renderItemBase != null) {
         Vec3 trailStartOffset = renderItemBase.trailInfo().start();
         Vec3 trailEndOffset = renderItemBase.trailInfo().end();
         Vec3f trailDirection = new Vec3f((float)(trailEndOffset.f_82479_ - trailStartOffset.f_82479_), (float)(trailEndOffset.f_82480_ - trailStartOffset.f_82480_), (float)(trailEndOffset.f_82481_ - trailStartOffset.f_82481_));

         for(float f = prevElapsedTime; f <= elapsedTime; f += step) {
            for(int i = 0; i <= particleCount; ++i) {
               float ratio = (float)i / (float)particleCount;
               Vec3f pointOffset = new Vec3f((float)(trailStartOffset.f_82479_ + (double)(trailDirection.x * ratio)), (float)(trailStartOffset.f_82480_ + (double)(trailDirection.y * ratio)), (float)(trailStartOffset.f_82481_ + (double)(trailDirection.z * ratio)));
               double randX = (Math.random() - 0.5D) * (double)random;
               double randY = (Math.random() - 0.5D) * (double)random;
               double randZ = (Math.random() - 0.5D) * (double)random;
               Vec3 worldPos = TDEAnimationUtils.getJointWorldRawPos(entityPatch, finalJoint, f + step, pointOffset);
               if(((LivingEntity)entityPatch.getOriginal()).m_9236_().f_46443_) {
                  ((LivingEntity)entityPatch.getOriginal()).m_9236_().m_7106_(particleOptions, worldPos.f_82479_ + randX, worldPos.f_82480_ + randY, worldPos.f_82481_ + randZ, 0.0D, 0.0D, 0.0D);
               }
            }
         }

      }
   }

   // $FF: synthetic method
   private static void lambda$particleTrail$5(float timeInterpolation, Vec3 startOffset, Vec3 endOffset, int particleCount, float random, Joint finalJoint, ParticleOptions particleOptions, LivingEntityPatch entityPatch, AssetAccessor self, AnimationParameters params) {
      AnimationPlayer player = entityPatch.getAnimator().getPlayerFor((AssetAccessor)null);
      float prevElapsedTime = player.getPrevElapsedTime();
      float elapsedTime = player.getElapsedTime();
      float step = (elapsedTime - prevElapsedTime) / timeInterpolation;
      Vec3 trailStartOffset = startOffset;
      Vec3f trailDirection = new Vec3f((float)(endOffset.f_82479_ - startOffset.f_82479_), (float)(endOffset.f_82480_ - startOffset.f_82480_), (float)(endOffset.f_82481_ - startOffset.f_82481_));

      for(float f = prevElapsedTime; f <= elapsedTime; f += step) {
         for(int i = 0; i <= particleCount; ++i) {
            float ratio = (float)i / (float)particleCount;
            Vec3f pointOffset = new Vec3f((float)(trailStartOffset.f_82479_ + (double)(trailDirection.x * ratio)), (float)(trailStartOffset.f_82480_ + (double)(trailDirection.y * ratio)), (float)(trailStartOffset.f_82481_ + (double)(trailDirection.z * ratio)));
            double randX = (Math.random() - 0.5D) * (double)random;
            double randY = (Math.random() - 0.5D) * (double)random;
            double randZ = (Math.random() - 0.5D) * (double)random;
            Vec3 worldPos = TDEAnimationUtils.getJointWorldRawPos(entityPatch, finalJoint, f + step, pointOffset);
            if(((LivingEntity)entityPatch.getOriginal()).m_9236_().f_46443_) {
               ((LivingEntity)entityPatch.getOriginal()).m_9236_().m_7106_(particleOptions, worldPos.f_82479_ + randX, worldPos.f_82480_ + randY, worldPos.f_82481_ + randZ, 0.0D, 0.0D, 0.0D);
            }
         }
      }

   }

   // $FF: synthetic method
   private static void lambda$particleTrail$4(float timeInterpolation, Vec3 startOffset, Vec3 endOffset, int particleCount, float random, Joint joint, ParticleOptions particleOptions, LivingEntityPatch entityPatch, AssetAccessor self, AnimationParameters params) {
      AnimationPlayer player = entityPatch.getAnimator().getPlayerFor((AssetAccessor)null);
      float prevElapsedTime = player.getPrevElapsedTime();
      float elapsedTime = player.getElapsedTime();
      float step = (elapsedTime - prevElapsedTime) / timeInterpolation;
      Vec3 trailStartOffset = startOffset;
      Vec3f trailDirection = new Vec3f((float)(endOffset.f_82479_ - startOffset.f_82479_), (float)(endOffset.f_82480_ - startOffset.f_82480_), (float)(endOffset.f_82481_ - startOffset.f_82481_));

      for(float f = prevElapsedTime; f <= elapsedTime; f += step) {
         for(int i = 0; i <= particleCount; ++i) {
            float ratio = (float)i / (float)particleCount;
            Vec3f pointOffset = new Vec3f((float)(trailStartOffset.f_82479_ + (double)(trailDirection.x * ratio)), (float)(trailStartOffset.f_82480_ + (double)(trailDirection.y * ratio)), (float)(trailStartOffset.f_82481_ + (double)(trailDirection.z * ratio)));
            double randX = (Math.random() - 0.5D) * (double)random;
            double randY = (Math.random() - 0.5D) * (double)random;
            double randZ = (Math.random() - 0.5D) * (double)random;
            Vec3 worldPos = TDEAnimationUtils.getJointWorldRawPos(entityPatch, joint, f + step, pointOffset);
            if(((LivingEntity)entityPatch.getOriginal()).m_9236_().f_46443_) {
               ((LivingEntity)entityPatch.getOriginal()).m_9236_().m_7106_(particleOptions, worldPos.f_82479_ + randX, worldPos.f_82480_ + randY, worldPos.f_82481_ + randZ, 0.0D, 0.0D, 0.0D);
            }
         }
      }

   }

   // $FF: synthetic method
   private static void lambda$fxTrail$3(String path, float timeInterpolation, Vec3 startOffset, Vec3 endOffset, int fxCount, float random, Joint joint, LivingEntityPatch entityPatch, AssetAccessor self, AnimationParameters params) {
      FX fx = FXHelper.getFX(new ResourceLocation(path));
      AnimationPlayer player = entityPatch.getAnimator().getPlayerFor((AssetAccessor)null);
      float prevElapsedTime = player.getPrevElapsedTime();
      float elapsedTime = player.getElapsedTime();
      float step = (elapsedTime - prevElapsedTime) / timeInterpolation;
      Vec3 trailStartOffset = startOffset;
      Vec3f trailDirection = new Vec3f((float)(endOffset.f_82479_ - startOffset.f_82479_), (float)(endOffset.f_82480_ - startOffset.f_82480_), (float)(endOffset.f_82481_ - startOffset.f_82481_));

      for(float f = prevElapsedTime; f <= elapsedTime; f += step) {
         for(int i = 0; i <= fxCount; ++i) {
            float ratio = (float)i / (float)fxCount;
            Vec3f pointOffset = new Vec3f((float)(trailStartOffset.f_82479_ + (double)(trailDirection.x * ratio)), (float)(trailStartOffset.f_82480_ + (double)(trailDirection.y * ratio)), (float)(trailStartOffset.f_82481_ + (double)(trailDirection.z * ratio)));
            double randX = (Math.random() - 0.5D) * (double)random;
            double randY = (Math.random() - 0.5D) * (double)random;
            double randZ = (Math.random() - 0.5D) * (double)random;
            Vec3 worldPos = TDEAnimationUtils.getJointWorldRawPos(entityPatch, joint, f + step, pointOffset);
            if(((LivingEntity)entityPatch.getOriginal()).m_9236_().f_46443_) {
               PosEffect effect = new PosEffect(fx, ((LivingEntity)entityPatch.getOriginal()).m_9236_(), entityPatch.getOriginal(), new Vec3(worldPos.f_82479_ + randX, worldPos.f_82480_ + randY, worldPos.f_82481_ + randZ), 5, false, true);
               effect.start();
            }
         }
      }

   }

   // $FF: synthetic method
   private static void lambda$hurtNearTarget$2(float distance, int intervalTick, int impactLevel, float damage, LivingEntityPatch entityPatch, AssetAccessor self, AnimationParameters params) {
      if(entityPatch.getTarget() != null) {
         Vec3 playerPosition = ((LivingEntity)entityPatch.getOriginal()).m_20182_();
         Vec3 targetPosition = entityPatch.getTarget().m_20182_();
         if(((LivingEntity)entityPatch.getOriginal()).m_20182_().m_82554_(entityPatch.getTarget().m_20182_()) < (double)distance) {
            if(((LivingEntity)entityPatch.getOriginal()).f_19797_ % intervalTick != 0) {
               return;
            }

            TDEDamageSource tdeDamageSource = new TDEDamageSource(entityPatch.getDamageSource((AnimationAccessor)null, InteractionHand.MAIN_HAND));
            tdeDamageSource.setImpactLevel(impactLevel);
            entityPatch.getTarget().m_6469_(tdeDamageSource, damage);
         }
      }

   }

   // $FF: synthetic method
   private static void lambda$chaseToTarget$1(float distance, float speed, LivingEntityPatch entityPatch, AssetAccessor self, AnimationParameters params) {
      if(entityPatch.getTarget() != null) {
         Vec3 playerPosition = ((LivingEntity)entityPatch.getOriginal()).m_20182_();
         Vec3 targetPosition = entityPatch.getTarget().m_20182_();
         if(((LivingEntity)entityPatch.getOriginal()).m_20182_().m_82554_(entityPatch.getTarget().m_20182_()) > (double)distance) {
            Vec3 dir = entityPatch.getTarget().m_20182_().m_82546_(((LivingEntity)entityPatch.getOriginal()).m_20182_()).m_82541_().m_82490_((double)speed);
            ((LivingEntity)entityPatch.getOriginal()).m_6478_(MoverType.SELF, new Vec3(dir.f_82479_, 0.0D, dir.f_82481_));
         }

         entityPatch.rotateTo(entityPatch.getTarget(), 5.0F, true);
      }

   }

   // $FF: synthetic method
   private static void lambda$rotateToTarget$0(float step, LivingEntityPatch entityPatch, AssetAccessor self, AnimationParameters params) {
      if(entityPatch.getTarget() != null) {
         entityPatch.rotateTo(entityPatch.getTarget(), step, true);
      }

   }
}
