package com.merlin204.tde.util;

import com.lowdragmc.photon.client.fx.FX;
import com.lowdragmc.photon.client.fx.FXHelper;
import com.merlin204.tde.epicfight.animations.TDEAttackAnimation.TDEPhase;
import com.merlin204.tde.network.NetworkHandler;
import com.merlin204.tde.network.server.ShakeCameraPacket;
import com.merlin204.tde.photon.PosEffect;
import com.merlin204.tde.world.AtkDirection;
import com.merlin204.tde.world.TDEDamageSource;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.AttackAnimation.JointColliderPair;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.utils.LevelUtil;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSources;
import yesman.epicfight.world.damagesource.EpicFightDamageType;
import yesman.epicfight.world.damagesource.StunType;

public class TDEAnimationUtils {

   public static Vec3 getJointWorldPos(LivingEntityPatch entityPatch, Joint joint) {
      return getJointWorldPos(entityPatch, joint, Vec3f.ZERO);
   }

   public static Vec3 getJointWorldRawPos(LivingEntityPatch entityPatch, Joint joint, float time) {
      return getJointWorldRawPos(entityPatch, joint, time, Vec3f.ZERO);
   }

   public static Vec3 getJointWorldPos(LivingEntityPatch entityPatch, Joint joint, Vec3f offset) {
      LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
      OpenMatrix4f transformMatrix = entityPatch.getArmature().getBindedTransformFor(entityPatch.getAnimator().getPose(0.1F), joint);
      transformMatrix.translate(offset);
      OpenMatrix4f rotation = (new OpenMatrix4f()).rotate(-((float)Math.toRadians((double)(entity.f_20884_ + 180.0F))), new Vec3f(0.0F, 1.0F, 0.0F));
      OpenMatrix4f.mul(rotation, transformMatrix, transformMatrix);
      Vec3 pos = new Vec3((double)(transformMatrix.m30 + (float)entity.m_20185_()), (double)(transformMatrix.m31 + (float)entity.m_20186_()), (double)(transformMatrix.m32 + (float)entity.m_20189_()));
      return pos;
   }

   public static Vec3 getJointWorldPos(LivingEntityPatch entityPatch, Joint joint, Vec3f offset, float partialTicks) {
      LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
      OpenMatrix4f transformMatrix = entityPatch.getArmature().getBindedTransformFor(entityPatch.getAnimator().getPose(partialTicks), joint);
      transformMatrix.translate(offset);
      OpenMatrix4f rotation = (new OpenMatrix4f()).rotate(-((float)Math.toRadians((double)(entity.f_20884_ + 180.0F))), new Vec3f(0.0F, 1.0F, 0.0F));
      OpenMatrix4f.mul(rotation, transformMatrix, transformMatrix);
      Vec3 pos = new Vec3((double)(transformMatrix.m30 + (float)entity.m_20185_()), (double)(transformMatrix.m31 + (float)entity.m_20186_()), (double)(transformMatrix.m32 + (float)entity.m_20189_()));
      return pos;
   }

   public static Vec3 getJointWorldRawPos(LivingEntityPatch entityPatch, Joint joint, float time, Vec3f offset) {
      Animator animator = entityPatch.getAnimator();
      LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
      Pose pose = ((DynamicAnimation)animator.getPlayerFor((AssetAccessor)null).getAnimation().get()).getRawPose(time);
      OpenMatrix4f transformMatrix = entityPatch.getArmature().getBindedTransformFor(pose, joint);
      transformMatrix.translate(offset);
      OpenMatrix4f rotation = (new OpenMatrix4f()).rotate(-((float)Math.toRadians((double)(entity.f_20884_ + 180.0F))), new Vec3f(0.0F, 1.0F, 0.0F));
      OpenMatrix4f.mul(rotation, transformMatrix, transformMatrix);
      Vec3 pos = new Vec3((double)(transformMatrix.m30 + (float)entity.m_20185_()), (double)(transformMatrix.m31 + (float)entity.m_20186_()), (double)(transformMatrix.m32 + (float)entity.m_20189_()));
      return pos;
   }

   public static void shakeCameraForNearbyPlayers(Level level, Vec3 center, double radius, int duration, float intensity, float frequency) {
      List players = level.m_45976_(Player.class, (new AABB(center, center)).m_82400_(radius));
      Iterator var8 = players.iterator();

      while(var8.hasNext()) {
         Player player = (Player)var8.next();
         if(player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHandler.sendToClient(new ShakeCameraPacket(duration, intensity, frequency, center, (float)radius), serverPlayer);
         }
      }

   }

   public static void joinRotationInPose(Pose param0, LivingEntityPatch param1, String param2, float param3, float param4, float param5) {
      // $FF: Couldn't be decompiled
   }

   public static TDEPhase createSimplePhase(int startFrame, int endFrame, int waitFrame, InteractionHand interactionHand, Joint joint, Collider collider) {
      float start = (float)startFrame / 60.0F;
      float end = (float)endFrame / 60.0F;
      float wait = (float)waitFrame / 60.0F;
      return new TDEPhase(0.0F, start, start, end, wait, Float.MAX_VALUE, interactionHand, 0, AtkDirection.MIDDLE, joint, collider);
   }

   public static TDEPhase createSimplePhase(int startFrame, int endFrame, int waitFrame, InteractionHand interactionHand, int phaseImpactLevelMulti, AtkDirection atkDirection, Joint joint, Collider collider) {
      float start = (float)startFrame / 60.0F;
      float end = (float)endFrame / 60.0F;
      float wait = (float)waitFrame / 60.0F;
      return new TDEPhase(0.0F, start, start, end, wait, Float.MAX_VALUE, interactionHand, phaseImpactLevelMulti, atkDirection, joint, collider);
   }

   public static TDEPhase createSimplePhase(int startFrame, int endFrame, int waitFrame, InteractionHand interactionHand, AtkDirection atkDirection, Joint joint, Collider collider) {
      float start = (float)startFrame / 60.0F;
      float end = (float)endFrame / 60.0F;
      float wait = (float)waitFrame / 60.0F;
      return new TDEPhase(0.0F, start, start, end, wait, Float.MAX_VALUE, interactionHand, 0, atkDirection, joint, collider);
   }

   public static TDEPhase createSimplePhase(int startFrame, int endFrame, int waitFrame, InteractionHand interactionHand, int phaseImpactLevelMulti, Joint joint, Collider collider) {
      float start = (float)startFrame / 60.0F;
      float end = (float)endFrame / 60.0F;
      float wait = (float)waitFrame / 60.0F;
      return new TDEPhase(0.0F, start, start, end, wait, Float.MAX_VALUE, interactionHand, phaseImpactLevelMulti, AtkDirection.MIDDLE, joint, collider);
   }

   public static TDEPhase createSimplePhase(int startFrame, int endFrame, int waitFrame, InteractionHand interactionHand, JointColliderPair ... colliders) {
      float start = (float)startFrame / 60.0F;
      float end = (float)endFrame / 60.0F;
      float wait = (float)waitFrame / 60.0F;
      return new TDEPhase(0.0F, start, start, end, wait, Float.MAX_VALUE, interactionHand, 0, AtkDirection.MIDDLE, colliders);
   }

   public static TDEPhase createSimplePhase(int startFrame, int endFrame, int waitFrame, InteractionHand interactionHand, int phaseImpactLevelMulti, AtkDirection atkDirection, JointColliderPair ... colliders) {
      float start = (float)startFrame / 60.0F;
      float end = (float)endFrame / 60.0F;
      float wait = (float)waitFrame / 60.0F;
      return new TDEPhase(0.0F, start, start, end, wait, Float.MAX_VALUE, interactionHand, phaseImpactLevelMulti, atkDirection, colliders);
   }

   public static TDEPhase createSimplePhase(int startFrame, int endFrame, int waitFrame, InteractionHand interactionHand, int phaseImpactLevelMulti, JointColliderPair ... colliders) {
      float start = (float)startFrame / 60.0F;
      float end = (float)endFrame / 60.0F;
      float wait = (float)waitFrame / 60.0F;
      return new TDEPhase(0.0F, start, start, end, wait, Float.MAX_VALUE, interactionHand, phaseImpactLevelMulti, AtkDirection.MIDDLE, colliders);
   }

   public static TDEPhase createSimplePhase(int startFrame, int endFrame, int waitFrame, InteractionHand interactionHand, AtkDirection atkDirection, JointColliderPair ... colliders) {
      float start = (float)startFrame / 60.0F;
      float end = (float)endFrame / 60.0F;
      float wait = (float)waitFrame / 60.0F;
      return new TDEPhase(0.0F, start, start, end, wait, Float.MAX_VALUE, interactionHand, 0, atkDirection, colliders);
   }

   public static void groundSplit(LivingEntityPatch entityPatch, double viewOffset, double xOffset, double yOffset, double zOffset, float radius, int impactLevel) {
      LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
      float damage = getTotalAttackDamage(entityPatch);
      Vec3 pos = entity.m_20182_();
      float yaw = entityPatch.getYRot();
      double radians = Math.toRadians((double)yaw);
      double cosYaw = Math.cos(radians);
      double sinYaw = Math.sin(radians);
      double worldX = xOffset * cosYaw + zOffset * sinYaw;
      double worldZ = -xOffset * sinYaw + zOffset * cosYaw;
      Vec3 viewDir = (new Vec3(-sinYaw, 0.0D, cosYaw)).m_82490_(viewOffset);
      Vec3 totalOffset = viewDir.m_82520_(worldX, yOffset, worldZ);
      Vec3 target = pos.m_82520_(totalOffset.f_82479_, -1.0D + totalOffset.f_82480_, totalOffset.f_82481_);
      Vec3 damagetarget = pos.m_82520_(totalOffset.f_82479_, totalOffset.f_82480_, totalOffset.f_82481_);
      Level var30 = entity.m_9236_();
      if(var30 instanceof ServerLevel) {
         ServerLevel level = (ServerLevel)var30;
         if(target != null) {
            LevelUtil.circleSlamFracture(entity, level, target, (double)radius, false);
            dealAreaDamage(level, damagetarget, entity, damage, radius, impactLevel);
         }
      }

   }

   public static void groundFXSplit(LivingEntityPatch entityPatch, String Fx, int maxAge, double viewOffset, double xOffset, double yOffset, double zOffset, float radius, int impactLevel) {
      LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
      float damage = getTotalAttackDamage(entityPatch);
      Vec3 pos = entity.m_20182_();
      float yaw = entityPatch.getYRot();
      double radians = Math.toRadians((double)yaw);
      double cosYaw = Math.cos(radians);
      double sinYaw = Math.sin(radians);
      double worldX = xOffset * cosYaw + zOffset * sinYaw;
      double worldZ = -xOffset * sinYaw + zOffset * cosYaw;
      Vec3 viewDir = (new Vec3(-sinYaw, 0.0D, cosYaw)).m_82490_(viewOffset);
      Vec3 totalOffset = viewDir.m_82520_(worldX, yOffset, worldZ);
      Vec3 target = pos.m_82520_(totalOffset.f_82479_, -1.0D + totalOffset.f_82480_, totalOffset.f_82481_);
      Vec3 damagetarget = pos.m_82520_(totalOffset.f_82479_, totalOffset.f_82480_, totalOffset.f_82481_);
      Level fx = entity.m_9236_();
      if(fx instanceof ServerLevel) {
         ServerLevel level = (ServerLevel)fx;
         if(target != null) {
            FX fx1 = FXHelper.getFX(new ResourceLocation(Fx));
            (new PosEffect(fx1, entity.m_9236_(), entity, damagetarget, maxAge, true)).start();
            LevelUtil.circleSlamFracture(entity, level, target, (double)radius, false);
            dealAreaDamage(level, damagetarget, entity, damage, radius, impactLevel);
         }
      }

   }

   private static void dealAreaDamage(ServerLevel level, Vec3 center, LivingEntity source, float damage, float radius, int impactLevel) {
      if(radius > 0.0F) {
         AABB area = new AABB(center.m_7096_() - (double)radius, center.m_7098_() - (double)radius, center.m_7094_() - (double)radius, center.m_7096_() + (double)radius, center.m_7098_() + (double)radius, center.m_7094_() + (double)radius);
         Class var10001 = LivingEntity.class;
         List entities = area.m_6443_(center, (AABB)radius, source);
         Iterator var8 = (new ArrayList(entities)).iterator();

         while(var8.hasNext()) {
            LivingEntity entity = (LivingEntity)var8.next();
            if(entity.f_19802_ >= 0 && source != null) {
               LivingEntityPatch entityPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch(source, LivingEntityPatch.class);
               if(entityPatch != null) {
                  entity.f_19802_ = 0;
                  EpicFightDamageSources damageSources = EpicFightDamageSources.of(entity.m_9236_());
                  TDEDamageSource tdeDamageSource = new TDEDamageSource(entityPatch.getDamageSource(Animations.EMPTY_ANIMATION, InteractionHand.MAIN_HAND));
                  tdeDamageSource.setImpactLevel(impactLevel);
                  entity.m_6469_(tdeDamageSource.setInitialPosition(center).setStunType(StunType.NONE).setAnimation(Animations.EMPTY_ANIMATION).setImpact(damage / 5.0F), damage);
               }

               entity.f_19802_ = 0;
            }
         }

      }
   }

   public static void dealRectangularDamage(ServerLevel level, LivingEntity source, float damage, float width, float length, float verticalRadius) {
      if(width > 0.0F && length > 0.0F && verticalRadius > 0.0F) {
         float maxRange = (float)Math.sqrt((double)(width * width + length * length)) / 2.0F;
         AABB area = new AABB(source.m_20185_() - (double)maxRange, source.m_20186_() - (double)verticalRadius, source.m_20189_() - (double)maxRange, source.m_20185_() + (double)maxRange, source.m_20186_() + (double)verticalRadius, source.m_20189_() + (double)maxRange);
         float yaw = source.m_146908_();
         float cos = (float)Math.cos(Math.toRadians((double)yaw));
         float sin = (float)Math.sin(Math.toRadians((double)yaw));
         List entities = level.m_6443_(LivingEntity.class, area, source);
         Iterator var12 = entities.iterator();

         while(var12.hasNext()) {
            LivingEntity entity = (LivingEntity)var12.next();
            double dx = entity.m_20185_() - source.m_20185_();
            double dz = entity.m_20189_() - source.m_20189_();
            double localX = dx * (double)cos + dz * (double)sin;
            double localForward = -dx * (double)sin + dz * (double)cos;
            boolean inXRange = localX >= (double)(-width / 2.0F) && localX <= (double)(width / 2.0F);
            boolean inForwardRange = localForward >= 0.0D && localForward <= (double)length;
            boolean inVerticalRange = entity.m_20186_() >= source.m_20186_() - (double)verticalRadius && entity.m_20186_() <= source.m_20186_() + (double)verticalRadius;
            if(inXRange && inForwardRange && inVerticalRange && entity.f_19802_ >= 0) {
               LivingEntityPatch entityPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch(source, LivingEntityPatch.class);
               if(entityPatch != null) {
                  entity.f_19802_ = 0;
                  EpicFightDamageSources damageSources = EpicFightDamageSources.of(entity.m_9236_());
                  entity.m_6469_(damageSources.shockwave(source).setAnimation(Animations.EMPTY_ANIMATION).setInitialPosition(source.m_20182_()).addRuntimeTag(EpicFightDamageType.FINISHER).addRuntimeTag(DamageTypes.f_268565_), damage);
               }

               entity.f_19802_ = 0;
            }
         }

      }
   }

   public static float getTotalAttackDamage(LivingEntityPatch entityPatch) {
      LivingEntity owner = (LivingEntity)entityPatch.getOriginal();
      double baseDamage = owner.m_21133_(Attributes.f_22281_);
      return (float)baseDamage;
   }

   // $FF: synthetic method
   private static boolean lambda$dealRectangularDamage$1(LivingEntity source, LivingEntity entity) {
      return entity.m_6084_() && entity != source;
   }

   // $FF: synthetic method
   private static boolean lambda$dealAreaDamage$0(Vec3 center, float radius, LivingEntity source, LivingEntity entity) {
      return entity.m_6084_() && entity.m_20238_(center) <= (double)(radius * radius) && entity != source;
   }
}
