package com.merlin204.tde.util;

import com.merlin204.tde.capabilitiy.player.TDEPlayerCapabilities;
import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.capabilitiy.player.ability.PlayerAbilities;
import net.minecraft.world.entity.player.Player;

public class TDEAbilityUtils {

   public static int getLevel(Player player) {
      return (int)(getAbility(AbilityType.VITALITY, player) + getAbility(AbilityType.STRENGTH, player) + getAbility(AbilityType.DEXTERITY, player) + getAbility(AbilityType.INTELLIGENCE, player) + getAbility(AbilityType.STAMINA, player) + getAbility(AbilityType.ARCANE, player));
   }

   public static float getAbility(AbilityType abilityType, Player player) {
      return abilityType.type == 1?((Float)player.getCapability(TDEPlayerCapabilities.PLAYER_ABILITIES).map(abilityType).orElse(Float.valueOf(0.0F))).floatValue():((Float)player.getCapability(TDEPlayerCapabilities.PLAYER_ABILITIES).map(abilityType).orElse(Float.valueOf(0.0F))).floatValue();
   }

   public static float getAbilityMax(AbilityType abilityType, Player player) {
      return ((Float)player.getCapability(TDEPlayerCapabilities.PLAYER_ABILITIES).map(abilityType).orElse(Float.valueOf(0.0F))).floatValue();
   }

   public static void setAbility(AbilityType abilityType, Player player, float amount) {
      if(player.m_9236_().f_46443_) {
         player.getCapability(TDEPlayerCapabilities.PLAYER_ABILITIES);
         amount.ifPresent(player);
      } else {
         player.getCapability(TDEPlayerCapabilities.PLAYER_ABILITIES);
         amount.ifPresent(player);
      }

   }

   public static void addAbility(AbilityType abilityType, Player player, float amount) {
      if(player.m_9236_().f_46443_) {
         player.getCapability(TDEPlayerCapabilities.PLAYER_ABILITIES);
         amount.ifPresent(player);
      } else {
         player.getCapability(TDEPlayerCapabilities.PLAYER_ABILITIES);
         amount.ifPresent(player);
      }

   }

   public static void subAbility(AbilityType abilityType, Player player, float amount) {
      if(player.m_9236_().f_46443_) {
         player.getCapability(TDEPlayerCapabilities.PLAYER_ABILITIES);
         amount.ifPresent(player);
      } else {
         player.getCapability(TDEPlayerCapabilities.PLAYER_ABILITIES);
         amount.ifPresent(player);
      }

   }

   // $FF: synthetic method
   private static void lambda$subAbility$8(AbilityType abilityType, float amount, Player player, PlayerAbilities abilities) {
      abilities.get(abilityType).sub(amount);
      abilities.syncToClient(player);
   }

   // $FF: synthetic method
   private static void lambda$subAbility$7(AbilityType abilityType, float amount, Player player, PlayerAbilities abilities) {
      abilities.get(abilityType).sub(amount);
      abilities.syncToServer(player);
   }

   // $FF: synthetic method
   private static void lambda$addAbility$6(AbilityType abilityType, float amount, Player player, PlayerAbilities abilities) {
      abilities.get(abilityType).add(amount);
      abilities.syncToClient(player);
   }

   // $FF: synthetic method
   private static void lambda$addAbility$5(AbilityType abilityType, float amount, Player player, PlayerAbilities abilities) {
      abilities.get(abilityType).add(amount);
      abilities.syncToServer(player);
   }

   // $FF: synthetic method
   private static void lambda$setAbility$4(AbilityType abilityType, float amount, Player player, PlayerAbilities abilities) {
      abilities.get(abilityType).set(amount);
      abilities.syncToClient(player);
   }

   // $FF: synthetic method
   private static void lambda$setAbility$3(AbilityType abilityType, float amount, Player player, PlayerAbilities abilities) {
      abilities.get(abilityType).set(amount);
      abilities.syncToServer(player);
   }

   // $FF: synthetic method
   private static Float lambda$getAbilityMax$2(AbilityType abilityType, PlayerAbilities abilities) {
      return Float.valueOf(abilities.get(abilityType).getCurrentMax());
   }

   // $FF: synthetic method
   private static Float lambda$getAbility$1(AbilityType abilityType, PlayerAbilities abilities) {
      return Float.valueOf(abilities.get(abilityType).get());
   }

   // $FF: synthetic method
   private static Float lambda$getAbility$0(AbilityType abilityType, PlayerAbilities abilities) {
      return Float.valueOf(abilities.get(abilityType).getCurrentMax());
   }
}
