package com.merlin204.tde.photon;

import com.lowdragmc.photon.client.fx.EntityEffect;
import com.lowdragmc.photon.client.fx.FX;
import com.lowdragmc.photon.client.fx.EntityEffect.AutoRotate;
import com.lowdragmc.photon.client.gameobject.IFXObject;
import com.merlin204.tde.util.TDEAnimationUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(Dist.CLIENT)
public class JointTimeEffect extends EntityEffect {

   public static Map CACHE = new HashMap();
   public final Entity entity;
   private final Joint joint;
   private final Vec3f jointOffset;
   private final boolean updatePos;
   private final float time;
   private int age;
   private int maxAge;


   public JointTimeEffect(FX fx, Level level, Entity entity, Joint joint, Vec3f offset, int maxAge, boolean canupdatePos, boolean allowMulti, float time) {
      super(fx, level, entity, AutoRotate.NONE);
      this.maxAge = -1;
      this.entity = entity;
      this.joint = joint;
      this.jointOffset = offset;
      this.maxAge = maxAge;
      this.time = time;
      this.allowMulti = allowMulti;
      this.updatePos = canupdatePos;
   }

   public JointTimeEffect(FX fx, Level level, Entity entity, Joint joint, int maxAge, boolean canupdatePos, float time) {
      this(fx, level, entity, joint, Vec3f.ZERO, maxAge, canupdatePos, true, time);
   }

   public JointTimeEffect(FX fx, Level level, Entity entity, Joint joint, int maxAge, float time) {
      this(fx, level, entity, joint, Vec3f.ZERO, maxAge, true, true, time);
   }

   public JointTimeEffect(FX fx, Level level, Entity entity, Joint joint, float time) {
      this(fx, level, entity, joint, Vec3f.ZERO, -1, true, true, time);
   }

   public JointTimeEffect(FX fx, Level level, Entity entity, Joint joint, int maxAge, boolean canupdatePos, boolean allowMulti, float time) {
      this(fx, level, entity, joint, Vec3f.ZERO, maxAge, canupdatePos, allowMulti, time);
   }

   public void updateFXObjectTick(IFXObject fxObject) {
      super.updateFXObjectTick(fxObject);
      Vec3 jointPos = this.jointPos(this.entity);
      if(this.updatePos && this.runtime != null && this.runtime.root != null) {
         this.runtime.root.updatePos(new Vector3f((float)jointPos.f_82479_, (float)jointPos.f_82480_, (float)jointPos.f_82481_));
      }

      ++this.age;
      if(this.maxAge > 0 && this.age >= this.maxAge) {
         this.runtime.destroy(this.forcedDeath);
         this.removeFromCache();
      }

      if(this.runtime != null && fxObject == this.runtime.root && !this.entity.m_6084_()) {
         this.runtime.destroy(this.forcedDeath);
         this.removeFromCache();
      }

   }

   public void setMaxAge(int ticks) {
      this.maxAge = ticks;
   }

   public void destroy() {
      if(this.runtime != null) {
         this.runtime.destroy(this.forcedDeath);
         this.removeFromCache();
      }

   }

   private void removeFromCache() {
      List effects = (List)CACHE.get(this.entity);
      if(effects != null) {
         effects.remove(this);
         if(effects.isEmpty()) {
            CACHE.remove(this.entity);
         }
      }

   }

   public void updateFXObjectFrame(IFXObject fxObject, float partialTicks) {
      if(this.updatePos && this.runtime != null && fxObject == this.runtime.root) {
         Vec3 joint = this.jointPos(this.entity);
         this.runtime.root.updatePos(new Vector3f((float)joint.f_82479_, (float)joint.f_82480_, (float)joint.f_82481_));
      }

   }

   public void start() {
      // $FF: Couldn't be decompiled
   }

   private Vec3 jointPos(Entity entity) {
      LivingEntityPatch livingEntityPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch(entity, LivingEntityPatch.class);
      if(this.joint == null) {
         return new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
      } else if(livingEntityPatch != null) {
         Vec3 pos = TDEAnimationUtils.getJointWorldRawPos(livingEntityPatch, this.joint, this.time, this.jointOffset);
         return pos;
      } else {
         return Vec3.f_82478_;
      }
   }

   // $FF: synthetic method
   private static List lambda$start$0(Entity p) {
      return new ArrayList();
   }

}
