package com.merlin204.tde.photon;

import com.lowdragmc.photon.client.fx.EntityEffect;
import com.lowdragmc.photon.client.fx.FX;
import com.lowdragmc.photon.client.fx.EntityEffect.AutoRotate;
import com.lowdragmc.photon.client.gameobject.IFXObject;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunction3;
import com.lowdragmc.photon.client.gameobject.emitter.particle.ParticleConfig;
import com.lowdragmc.photon.client.gameobject.emitter.particle.ParticleEmitter;
import com.merlin204.tde.util.TDEAnimationUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(Dist.CLIENT)
public class JointEffect extends EntityEffect {

   public static Map CACHE = new HashMap();
   public final Entity entity;
   private final Joint joint;
   private final Vec3f jointOffset;
   private final boolean updatePos;
   private final NumberFunction3 startRotation;
   private int age;
   private int maxAge;


   public JointEffect(FX fx, Level level, Entity entity, Joint joint, Vec3f offset, int maxAge, boolean canupdatePos, boolean allowMulti, NumberFunction3 startRotation) {
      super(fx, level, entity, AutoRotate.NONE);
      this.maxAge = -1;
      this.entity = entity;
      this.joint = joint;
      this.jointOffset = offset;
      this.maxAge = maxAge;
      this.allowMulti = allowMulti;
      this.updatePos = canupdatePos;
      this.startRotation = startRotation;
   }

   public JointEffect(FX fx, Level level, Entity entity, Joint joint, Vec3f offset, int maxAge, boolean canupdatePos, boolean allowMulti) {
      super(fx, level, entity, AutoRotate.NONE);
      this.maxAge = -1;
      this.entity = entity;
      this.joint = joint;
      this.jointOffset = offset;
      this.maxAge = maxAge;
      this.allowMulti = allowMulti;
      this.updatePos = canupdatePos;
      this.startRotation = null;
   }

   public JointEffect(FX fx, Level level, Entity entity, Joint joint, int maxAge, boolean canupdatePos) {
      this(fx, level, entity, joint, Vec3f.ZERO, maxAge, canupdatePos, true);
   }

   public JointEffect(FX fx, Level level, Entity entity, Joint joint, int maxAge) {
      this(fx, level, entity, joint, Vec3f.ZERO, maxAge, true, true);
   }

   public JointEffect(FX fx, Level level, Entity entity, Joint joint) {
      this(fx, level, entity, joint, Vec3f.ZERO, -1, true, true);
   }

   public JointEffect(FX fx, Level level, Entity entity, Joint joint, int maxAge, boolean canupdatePos, boolean allowMulti) {
      this(fx, level, entity, joint, Vec3f.ZERO, maxAge, canupdatePos, allowMulti);
   }

   public void updateFXObjectTick(IFXObject fxObject) {
      super.updateFXObjectTick(fxObject);
      if(fxObject instanceof ParticleEmitter) {
         ParticleEmitter particleEmitter = (ParticleEmitter)fxObject;
         if(this.startRotation != null) {
            ParticleConfig particleConfig = particleEmitter.config;
            particleConfig.setStartRotation(this.startRotation);
         }
      }

      ++this.age;
      if(this.maxAge > 0 && this.age >= this.maxAge) {
         this.runtime.destroy(this.forcedDeath);
         this.removeFromCache();
      }

      if(this.runtime != null && fxObject == this.runtime.root && !this.entity.m_6084_()) {
         this.runtime.destroy(this.forcedDeath);
         this.removeFromCache();
      }

   }

   public void setMaxAge(int ticks) {
      this.maxAge = ticks;
   }

   public void destroy() {
      if(this.runtime != null) {
         this.runtime.destroy(this.forcedDeath);
         this.removeFromCache();
      }

   }

   private void removeFromCache() {
      List effects = (List)CACHE.get(this.entity);
      if(effects != null) {
         effects.remove(this);
         if(effects.isEmpty()) {
            CACHE.remove(this.entity);
         }
      }

   }

   public void updateFXObjectFrame(IFXObject fxObject, float partialTicks) {
      if(this.updatePos) {
         Vec3 joint;
         if(this.joint == null) {
            joint = this.entity.m_20318_(partialTicks);
            this.runtime.root.updatePos(new Vector3f((float)(joint.f_82479_ + (double)this.offset.x), (float)(joint.f_82480_ + (double)this.offset.y), (float)(joint.f_82481_ + (double)this.offset.z)));
         } else if(this.runtime != null && fxObject == this.runtime.root) {
            joint = this.jointPos(this.entity, partialTicks);
            this.runtime.root.updatePos(new Vector3f((float)joint.f_82479_, (float)joint.f_82480_, (float)joint.f_82481_));
         }
      }

   }

   public void start() {
      // $FF: Couldn't be decompiled
   }

   private Vec3 jointPos(Entity entity, float partialTicks) {
      LivingEntityPatch livingEntityPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch(entity, LivingEntityPatch.class);
      if(this.joint == null) {
         return new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
      } else if(livingEntityPatch != null) {
         Vec3 pos = TDEAnimationUtils.getJointWorldPos(livingEntityPatch, this.joint, this.jointOffset, partialTicks);
         return pos;
      } else {
         return Vec3.f_82478_;
      }
   }

   // $FF: synthetic method
   private static List lambda$start$0(Entity p) {
      return new ArrayList();
   }

}
