package com.merlin204.tde.network.server;

import com.lowdragmc.lowdraglib.networking.IHandlerContext;
import com.lowdragmc.lowdraglib.networking.IPacket;
import com.merlin204.tde.ldlib.TDEUIFactory;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class TDESPacketUIOpen implements IPacket {

   private ResourceLocation uiFactoryId;
   private FriendlyByteBuf serializedHolder;
   private int windowId;


   public TDESPacketUIOpen(ResourceLocation uiFactoryId, FriendlyByteBuf serializedHolder, int windowId) {
      this.uiFactoryId = uiFactoryId;
      this.serializedHolder = serializedHolder;
      this.windowId = windowId;
   }

   public void encode(FriendlyByteBuf buf) {
      buf.m_130130_(this.serializedHolder.readableBytes());
      buf.writeBytes(this.serializedHolder);
      buf.m_130085_(this.uiFactoryId);
      buf.m_130130_(this.windowId);
   }

   public TDESPacketUIOpen(FriendlyByteBuf buf) {
      this.decode(buf);
   }

   public void decode(FriendlyByteBuf buf) {
      ByteBuf directSliceBuffer = buf.readBytes(buf.m_130242_());
      ByteBuf copiedDataBuffer = Unpooled.copiedBuffer(directSliceBuffer);
      directSliceBuffer.release();
      this.serializedHolder = new FriendlyByteBuf(copiedDataBuffer);
      this.uiFactoryId = buf.m_130281_();
      this.windowId = buf.m_130242_();
   }

   public void execute(IHandlerContext handler) {
      if(handler.isClient()) {
         Minecraft.m_91087_().execute(this);
      }

   }

   // $FF: synthetic method
   private void lambda$execute$0() {
      TDEUIFactory uiFactory = (TDEUIFactory)TDEUIFactory.FACTORIES.get(this.uiFactoryId);
      if(uiFactory != null) {
         uiFactory.initClientUI(this.serializedHolder, this.windowId);
      }

   }
}
