package com.merlin204.tde.network.server;

import com.merlin204.tde.client.CameraShake;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent.Context;

public class ShakeCameraPacket {

   private final int duration;
   private final float intensity;
   private final float frequency;
   private final Vec3 center;
   private final float radius;


   public ShakeCameraPacket(int duration, float intensity, float frequency, Vec3 center, float radius) {
      this.duration = duration;
      this.intensity = intensity;
      this.frequency = frequency;
      this.center = center;
      this.radius = radius;
   }

   public static void encode(ShakeCameraPacket msg, FriendlyByteBuf buffer) {
      buffer.writeInt(msg.duration);
      buffer.writeFloat(msg.intensity);
      buffer.writeFloat(msg.frequency);
      buffer.writeDouble(msg.center.f_82479_);
      buffer.writeDouble(msg.center.f_82480_);
      buffer.writeDouble(msg.center.f_82481_);
      buffer.writeFloat(msg.radius);
   }

   public static ShakeCameraPacket decode(FriendlyByteBuf buffer) {
      return new ShakeCameraPacket(buffer.readInt(), buffer.readFloat(), buffer.readFloat(), new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()), buffer.readFloat());
   }

   public static void handle(ShakeCameraPacket msg, Supplier ctx) {
      Context context = (Context)ctx.get();
      context.enqueueWork(msg);
      context.setPacketHandled(true);
   }

   // $FF: synthetic method
   private static void lambda$handle$2(ShakeCameraPacket msg) {
      DistExecutor.unsafeRunWhenOn(Dist.CLIENT, msg);
   }

   // $FF: synthetic method
   private static Runnable lambda$handle$1(ShakeCameraPacket msg) {
      return msg;
   }

   // $FF: synthetic method
   private static void lambda$handle$0(ShakeCameraPacket msg) {
      CameraShake.shake(msg.duration, msg.intensity, msg.frequency, msg.center, msg.radius);
   }
}
