package com.merlin204.tde.network.server;

import com.merlin204.tde.capabilitiy.player.TDEPlayerCapabilities;
import com.merlin204.tde.capabilitiy.player.ability.PlayerAbilities;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent.Context;

public class AbilitySyncPacket {

   private final CompoundTag data;


   public AbilitySyncPacket(CompoundTag data) {
      this.data = data;
   }

   public AbilitySyncPacket(FriendlyByteBuf buf) {
      this.data = buf.m_130260_();
   }

   public void encode(FriendlyByteBuf buf) {
      buf.m_130079_(this.data);
   }

   public static void handle(AbilitySyncPacket msg, Supplier ctx) {
      ((Context)ctx.get()).enqueueWork(msg);
      ((Context)ctx.get()).setPacketHandled(true);
   }

   // $FF: synthetic method
   private static void lambda$handle$1(AbilitySyncPacket msg) {
      LocalPlayer player = Minecraft.m_91087_().f_91074_;
      if(player != null) {
         player.getCapability(TDEPlayerCapabilities.PLAYER_ABILITIES).ifPresent(msg);
      }

   }

   // $FF: synthetic method
   private static void lambda$handle$0(AbilitySyncPacket msg, PlayerAbilities abilities) {
      abilities.loadFromNBT(msg.data);
   }
}
