package com.merlin204.tde.network;

import com.merlin204.tde.client.gui.TDEBossBar;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent.Context;

public class SyncBossBarPacket {

   private final UUID bossUuid;
   private final int entityId;


   public SyncBossBarPacket(UUID bossUuid, int entityId) {
      this.bossUuid = bossUuid;
      this.entityId = entityId;
   }

   public void encode(FriendlyByteBuf buf) {
      buf.m_130077_(this.bossUuid);
      buf.writeInt(this.entityId);
   }

   public static SyncBossBarPacket decode(FriendlyByteBuf buf) {
      return new SyncBossBarPacket(buf.m_130259_(), buf.readInt());
   }

   public void handle(Supplier ctx) {
      ((Context)ctx.get()).enqueueWork(this);
      ((Context)ctx.get()).setPacketHandled(true);
   }

   // $FF: synthetic method
   private void lambda$handle$0() {
      TDEBossBar.BOSSES.put(this.bossUuid, Integer.valueOf(this.entityId));
   }
}
