package com.merlin204.tde.mixin;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import yesman.epicfight.api.client.model.SkinnedMesh;

@Mixin(
   targets = {"yesman.epicfight.client.renderer.patched.layer.WearableItemLayer"},
   remap = false
)
public abstract class WearableItemLayerMixin {

   @Shadow
   @Final
   private static Map ARMOR_MODELS;
   @Unique
   private static final Map CUSTOM_TEXTURE_CACHE = Maps.newHashMap();


   @Inject(
      method = {"getArmorTexture"},
      at = {         @At("HEAD")},
      cancellable = true,
      remap = false
   )
   private void onGetArmorTexture(ItemStack itemstack, LivingEntity entity, SkinnedMesh armorMesh, EquipmentSlot slot, String type, HumanoidModel originalModel, CallbackInfoReturnable cir) {
      if(itemstack.m_41720_() instanceof ArmorItem) {
         ResourceLocation itemId = ForgeRegistries.ITEMS.getKey(itemstack.m_41720_());
         if(itemId != null) {
            itemId.m_135815_();
            String path = type != null?type:"";
            ResourceLocation textureId = new ResourceLocation(itemId.m_135827_(), path);
            ResourceLocation cached = (ResourceLocation)CUSTOM_TEXTURE_CACHE.get(textureId);
            if(cached == null) {
               cached = textureId;
               CUSTOM_TEXTURE_CACHE.put(textureId, textureId);
            }

            cir.setReturnValue(cached);
         }
      }
   }

}
