package com.merlin204.tde.mixin;

import com.github.leawind.thirdperson.ThirdPerson;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.entity.PartEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;

@Mixin({LocalPlayerPatch.class})
public abstract class LocalPlayerPatchMixin {

   @Shadow
   private LivingEntity rayTarget;
   @Shadow
   private boolean targetLockedOn;


   @Inject(
      method = {"pickEntity()Lnet/minecraft/world/phys/EntityHitResult;"},
      at = {         @At("HEAD")},
      cancellable = true,
      remap = false
   )
   private void onPickEntity(CallbackInfoReturnable cir) {
      EntityHitResult result = ThirdPerson.CAMERA_AGENT.pickEntity(20.0D);
      if(result != null) {
         Entity hit = result.m_82443_();
         if(hit instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)hit;
            this.rayTarget = living;
            this.targetLockedOn = false;
         } else if(hit instanceof PartEntity) {
            PartEntity part = (PartEntity)hit;
            Entity parent = part.getParent();
            if(parent instanceof LivingEntity) {
               LivingEntity livingParent = (LivingEntity)parent;
               this.rayTarget = livingParent;
               this.targetLockedOn = false;
            }
         }

         cir.setReturnValue(result);
         cir.cancel();
      }

   }
}
