package com.merlin204.tde.mixin;

import com.merlin204.tde.entity.player.TDELocalPlayerPatch;
import com.merlin204.tde.entity.player.TDEServerPlayerPatch;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.provider.EntityPatchProvider;

@Mixin(
   value = {EntityPatchProvider.class},
   remap = false
)
public abstract class EntityPatchProviderMixin {

   @Shadow
   private static Map CAPABILITIES;
   @Shadow
   private static Map CUSTOM_CAPABILITIES;
   @Shadow
   private EntityPatch capability;


   @Inject(
      method = {"<clinit>"},
      at = {         @At("TAIL")}
   )
   private static void onStaticInit(CallbackInfo ci) {
      overridePlayerPatch();
   }

   @Inject(
      method = {"registerEntityPatches"},
      at = {         @At("TAIL")}
   )
   private static void onRegisterEntityPatches(CallbackInfo ci) {
      overridePlayerPatch();
   }

   @Inject(
      method = {"registerEntityPatchesClient"},
      at = {         @At("TAIL")}
   )
   private static void onRegisterEntityPatchesClient(CallbackInfo ci) {
      overridePlayerPatch();
   }

   @Inject(
      method = {"clear"},
      at = {         @At("HEAD")},
      cancellable = true
   )
   private static void onClear(CallbackInfo ci) {
      Function playerPatch = (Function)CUSTOM_CAPABILITIES.get(EntityType.f_20532_);
      CUSTOM_CAPABILITIES.clear();
      if(playerPatch != null) {
         CUSTOM_CAPABILITIES.put(EntityType.f_20532_, playerPatch);
      }

      ci.cancel();
   }

   private static void overridePlayerPatch() {
      // $FF: Couldn't be decompiled
   }

   @Inject(
      method = {"<init>"},
      at = {         @At("RETURN")}
   )
   private void onConstruct(Entity entity, CallbackInfo ci) {
      if(this.capability == null && entity.m_6095_() == EntityType.f_20532_) {
         if(entity instanceof LocalPlayer) {
            this.capability = new TDELocalPlayerPatch();
         } else if(entity instanceof Player) {
            this.capability = new TDEServerPlayerPatch();
         }
      }

   }

   // $FF: synthetic method
   private static Supplier lambda$overridePlayerPatch$5(Entity param0) {
      // $FF: Couldn't be decompiled
   }

   // $FF: synthetic method
   private static EntityPatch lambda$overridePlayerPatch$4() {
      return null;
   }

   // $FF: synthetic method
   private static EntityPatch lambda$overridePlayerPatch$3() {
      return null;
   }

   // $FF: synthetic method
   private static Supplier lambda$overridePlayerPatch$2(Entity param0) {
      // $FF: Couldn't be decompiled
   }

   // $FF: synthetic method
   private static EntityPatch lambda$overridePlayerPatch$1() {
      return null;
   }

   // $FF: synthetic method
   private static EntityPatch lambda$overridePlayerPatch$0() {
      return null;
   }
}
