package com.merlin204.tde.ldlib;

import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.core.mixins.accessor.ServerPlayerAccessor;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.modular.ModularUIContainer;
import com.lowdragmc.lowdraglib.side.ForgeEventHooks;
import com.merlin204.tde.ldlib.TDEModularUIGuiContainer;
import com.merlin204.tde.network.NetworkHandler;
import com.merlin204.tde.network.server.TDESPacketUIOpen;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class TDEUIFactory {

   public final ResourceLocation uiFactoryId;
   public static final Map FACTORIES = new HashMap();


   public TDEUIFactory(ResourceLocation uiFactoryId) {
      this.uiFactoryId = uiFactoryId;
   }

   public static void register(TDEUIFactory factory) {
      FACTORIES.put(factory.uiFactoryId, factory);
   }

   public final boolean openUI(Object holder, ServerPlayer player) {
      ModularUI uiTemplate = this.createUITemplate(holder, player);
      if(uiTemplate == null) {
         return false;
      } else {
         uiTemplate.initWidgets();
         if(player.f_36096_ != player.f_36095_) {
            player.m_6915_();
         }

         ((ServerPlayerAccessor)player).callNextContainerCounter();
         int currentWindowId = ((ServerPlayerAccessor)player).getContainerCounter();
         FriendlyByteBuf serializedHolder = new FriendlyByteBuf(Unpooled.buffer());
         this.writeHolderToSyncData(serializedHolder, holder);
         ModularUIContainer container = new ModularUIContainer(uiTemplate, currentWindowId);
         uiTemplate.mainGroup.writeInitialData(serializedHolder);
         NetworkHandler.sendToClient(new TDESPacketUIOpen(this.uiFactoryId, serializedHolder, currentWindowId), player);
         ((ServerPlayerAccessor)player).callInitMenu(container);
         player.f_36096_ = container;
         if(Platform.isForge()) {
            ForgeEventHooks.postPlayerContainerEvent(player, container);
         }

         return true;
      }
   }

   public final void initClientUI(FriendlyByteBuf serializedHolder, int windowId) {
      Object holder = this.readHolderFromSyncData(serializedHolder);
      Minecraft minecraft = Minecraft.m_91087_();
      LocalPlayer entityPlayer = minecraft.f_91074_;
      ModularUI uiTemplate = this.createUITemplate(holder, entityPlayer);
      if(uiTemplate != null) {
         uiTemplate.initWidgets();
         TDEModularUIGuiContainer ModularUIGuiContainer = new TDEModularUIGuiContainer(uiTemplate, windowId);
         uiTemplate.mainGroup.readInitialData(serializedHolder);
         minecraft.m_91152_(ModularUIGuiContainer);
         minecraft.f_91074_.f_36096_ = ModularUIGuiContainer.m_6262_();
      }
   }

   protected ModularUI createUITemplate(Object holder, Player entityPlayer) {
      return null;
   }

   protected Object readHolderFromSyncData(FriendlyByteBuf syncData) {
      return null;
   }

   protected void writeHolderToSyncData(FriendlyByteBuf syncData, Object holder) {
   }

}
