package com.merlin204.tde.ldlib;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class TDEIUIHolder {

   IUIHolder EMPTY = new IUIHolder() {
      public ModularUI createUI(Player entityPlayer) {
         return null;
      }
      public boolean isInvalid() {
         return false;
      }
      public boolean isRemote() {
         return true;
      }
      public void markAsDirty() {
      }
   };



   public interface EntityUI extends IUIHolder {

      default LivingEntity self() {
         return (LivingEntity)this;
      }

      default boolean isInvalid() {
         return this.self().m_213877_() || !this.self().m_6084_();
      }

      default boolean isRemote() {
         Level level = this.self().m_9236_();
         return level == null?LDLib.isRemote():level.f_46443_;
      }

      default void markAsDirty() {
      }
   }
}
