package com.merlin204.tde.ldlib;

import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.merlin204.tde.ldlib.TDEIUIHolder;
import com.merlin204.tde.ldlib.TDEUIFactory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class NPCEntityUIFactory extends TDEUIFactory {

   public static final NPCEntityUIFactory INSTANCE = new NPCEntityUIFactory();


   public NPCEntityUIFactory() {
      super(ResourceLocation.fromNamespaceAndPath("tde", "npc_entity"));
   }

   protected ModularUI createUITemplate(LivingEntity livingEntity, Player player) {
      if(livingEntity instanceof TDEIUIHolder.EntityUI) {
         TDEIUIHolder.EntityUI tdeiuiHolder = (TDEIUIHolder.EntityUI)livingEntity;
         return tdeiuiHolder.createUI(player);
      } else {
         return null;
      }
   }

   protected LivingEntity readHolderFromSyncData(FriendlyByteBuf syncData) {
      int entityId = syncData.readInt();
      ClientLevel world = Minecraft.m_91087_().f_91073_;
      if(world == null) {
         return null;
      } else {
         Entity entity = world.m_6815_(entityId);
         return entity instanceof LivingEntity?(LivingEntity)entity:null;
      }
   }

   protected void writeHolderToSyncData(FriendlyByteBuf syncData, LivingEntity holder) {
      syncData.writeInt(holder.m_19879_());
   }

}
