package com.merlin204.tde.item.weapon;

import com.merlin204.tde.item.weapon.TDECollider;
import com.merlin204.tde.item.weapon.TDEWeaponType;
import net.minecraft.sounds.SoundEvent;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.collider.MultiOBBCollider;
import yesman.epicfight.gameasset.EpicFightSounds;

public class TDEWeaponItemProperties {

   private final float weight;
   private final int impactBonus;
   private final int defendBonus;
   private final TDEWeaponType weaponType;
   private final TDECollider tdeCollider;
   private final SoundEvent swingSound;
   private final SoundEvent hitSound;


   private TDEWeaponItemProperties(TDEWeaponItemProperties.Builder builder) {
      this.weight = builder.weight;
      this.impactBonus = builder.impactBonus;
      this.defendBonus = builder.defendBonus;
      this.weaponType = builder.weaponType;
      this.tdeCollider = builder.tdeCollider;
      this.hitSound = builder.hitSound;
      this.swingSound = builder.swingSound;
   }

   public float getWeight() {
      return this.weight;
   }

   public int getImpactBonus() {
      return this.impactBonus;
   }

   public int getDefendBonus() {
      return this.defendBonus;
   }

   public TDEWeaponType getWeaponType() {
      return this.weaponType;
   }

   public TDECollider getTdeCollider() {
      return this.tdeCollider;
   }

   public SoundEvent getSwingSound() {
      return this.swingSound;
   }

   public SoundEvent getHitSound() {
      return this.hitSound;
   }

   public static class Builder {

      private float weight = 0.0F;
      private int impactBonus = 0;
      private int defendBonus = 0;
      private TDEWeaponType weaponType;
      private TDECollider tdeCollider;
      private SoundEvent swingSound;
      private SoundEvent hitSound;


      public Builder() {
         this.weaponType = TDEWeaponType.EMPTY;
         this.tdeCollider = new TDECollider(new MultiOBBCollider(0, 0.0D, 0.0D, 0.0D, 0.0D, 0.0D, 0.0D));
         this.swingSound = (SoundEvent)EpicFightSounds.WHOOSH.get();
         this.hitSound = (SoundEvent)EpicFightSounds.BLADE_HIT.get();
      }

      public TDEWeaponItemProperties.Builder weight(float weight) {
         this.weight = weight;
         return this;
      }

      public TDEWeaponItemProperties.Builder impactBonus(int impactBonus) {
         this.impactBonus = impactBonus;
         return this;
      }

      public TDEWeaponItemProperties.Builder defendBonus(int defendBonus) {
         this.defendBonus = defendBonus;
         return this;
      }

      public TDEWeaponItemProperties.Builder swingSound(SoundEvent swingSound) {
         this.swingSound = swingSound;
         return this;
      }

      public TDEWeaponItemProperties.Builder hitSound(SoundEvent hitSound) {
         this.hitSound = hitSound;
         return this;
      }

      public TDEWeaponItemProperties.Builder weaponType(TDEWeaponType weaponType) {
         this.weaponType = weaponType;
         return this;
      }

      public TDEWeaponItemProperties.Builder tdeCollider(Collider collider) {
         this.tdeCollider = new TDECollider(collider);
         return this;
      }

      public TDEWeaponItemProperties build() {
         return new TDEWeaponItemProperties(this);
      }
   }
}
