package com.merlin204.tde.item.weapon;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.ImmutableMultimap.Builder;
import com.merlin204.tde.item.weapon.TDEWeaponItemProperties;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.AttributeModifier.Operation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.Item.Properties;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class TDEWeaponItem extends Item implements Vanishable {

   private final TDEWeaponItemProperties properties;
   private final float attackDamage;
   private final Multimap defaultModifiers;


   public TDEWeaponItem(float damageIn, Properties pProperties, TDEWeaponItemProperties customProps) {
      super(pProperties);
      this.properties = customProps;
      this.attackDamage = damageIn;
      Builder builder = ImmutableMultimap.builder();
      builder.put(Attributes.f_22281_, new AttributeModifier(UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A99DB5CF"), "tde Weapon modifier", (double)this.attackDamage, Operation.ADDITION));
      this.defaultModifiers = builder.build();
   }

   public void m_7373_(ItemStack stack, @Nullable Level level, List tooltip, TooltipFlag flag) {
   }

   public float getDamage() {
      return this.attackDamage;
   }

   public boolean m_6777_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
      return !pPlayer.m_7500_();
   }

   public boolean m_6813_(ItemStack param1, Level param2, BlockState param3, BlockPos param4, LivingEntity param5) {
      // $FF: Couldn't be decompiled
   }

   public boolean m_8096_(BlockState pBlock) {
      return false;
   }

   public Multimap m_7167_(EquipmentSlot pEquipmentSlot) {
      return pEquipmentSlot == EquipmentSlot.MAINHAND?this.defaultModifiers:super.m_7167_(pEquipmentSlot);
   }

   public TDEWeaponItemProperties getProperties() {
      return this.properties;
   }

   // $FF: synthetic method
   private static void lambda$mineBlock$0(LivingEntity p_43276_) {
      p_43276_.m_21166_(EquipmentSlot.MAINHAND);
   }
}
