package com.merlin204.tde.item.uesItem.skillbook;

import com.merlin204.tde.client.hud.TDEHud;
import com.merlin204.tde.entity.player.TDELocalPlayerPatch;
import com.merlin204.tde.entity.player.TDEServerPlayerPatch;
import com.merlin204.tde.epicfight.gameassets.skill.SkillInfo;
import com.merlin204.tde.item.uesItem.UesItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.Item.Properties;
import net.minecraft.world.level.Level;
import yesman.epicfight.api.data.reloader.SkillManager;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.skill.CapabilitySkill;

public class TDESkillBook extends UesItem {

   private final String skillName;


   public TDESkillBook(Properties pProperties, String skill) {
      super(pProperties);
      this.skillName = skill;
   }

   public void m_7373_(ItemStack stack, @Nullable Level level, List tooltip, TooltipFlag flag) {
      super.m_7373_(stack, level, tooltip, flag);
      Skill var6 = SkillManager.getSkill(this.skillName);
      if(var6 instanceof SkillInfo) {
         SkillInfo skillInfo = (SkillInfo)var6;
         tooltip.add(Component.m_237115_(SkillManager.getSkill(this.skillName).getTranslationKey()));
      }

   }

   public Component m_7626_(ItemStack stack) {
      return Component.m_237115_("item.tde.skill_book");
   }

   public void uesEvent(Level level, Player player, InteractionHand hand) {
      super.uesEvent(level, player, hand);
      Skill skill;
      CapabilitySkill skills;
      if(level.f_46443_) {
         if(SkillManager.getSkill(this.skillName) != null) {
            skill = SkillManager.getSkill(this.skillName);
            TDELocalPlayerPatch tdeServerPlayerPatch = (TDELocalPlayerPatch)EpicFightCapabilities.getEntityPatch(player, TDELocalPlayerPatch.class);
            skills = tdeServerPlayerPatch.getSkillCapability();
            skills.addLearnedSkill(skill);
            if(TDEHud.instance != null) {
               TDEHud.instance.showLearnSkill(skill);
            }
         }
      } else if(SkillManager.getSkill(this.skillName) != null) {
         skill = SkillManager.getSkill(this.skillName);
         TDEServerPlayerPatch tdeServerPlayerPatch1 = (TDEServerPlayerPatch)EpicFightCapabilities.getEntityPatch(player, TDEServerPlayerPatch.class);
         skills = tdeServerPlayerPatch1.getSkillCapability();
         skills.addLearnedSkill(skill);
      }

   }
}
