package com.merlin204.tde.item.armor;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.ArmorItem.Type;
import net.minecraft.world.item.Item.Properties;
import net.minecraft.world.level.Level;

public class TDEArmor extends ArmorItem {

   private float damageReduction;


   public TDEArmor(ArmorMaterial material, Type slot, float reductionPercent, Properties properties) {
      super(material, slot, properties.m_41503_(500).setNoRepair());
      this.damageReduction = reductionPercent;
   }

   public CompoundTag getShareTag(ItemStack stack) {
      CompoundTag tag = super.getShareTag(stack) != null?super.getShareTag(stack):new CompoundTag();
      tag.m_128350_("DamageReduction", this.damageReduction);
      return tag;
   }

   public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
      super.readShareTag(stack, nbt);
      if(nbt != null && nbt.m_128441_("DamageReduction")) {
         this.damageReduction = nbt.m_128457_("DamageReduction");
      } else {
         Item item = stack.m_41720_();
         if(item instanceof TDEArmor) {
            TDEArmor armor = (TDEArmor)item;
            this.damageReduction = armor.getDefaultReduction();
         }
      }

   }

   public boolean isDamageable(ItemStack stack) {
      return false;
   }

   public float getDamageReduction() {
      return this.damageReduction;
   }

   public float getDefaultReduction() {
      return 0.05F;
   }

   public void m_7836_(ItemStack stack, Level world, Player player) {
      super.m_7836_(stack, world, player);
      if(!world.f_46443_) {
         CompoundTag tag = stack.m_41784_();
         tag.m_128350_("DamageReduction", this.damageReduction);
      }

   }

   public void m_7373_(ItemStack stack, @Nullable Level world, List tooltip, TooltipFlag flag) {
      super.m_7373_(stack, world, tooltip, flag);
      tooltip.add(Component.m_237115_("tooltip.damage_reduction").m_7220_(Component.m_237113_(String.format("%.0f", new Object[]{Float.valueOf(this.damageReduction * 100.0F)}))).m_130940_(ChatFormatting.BLUE));
   }
}
