package com.merlin204.tde.item;

import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.entity.xuan.XEntity;
import com.merlin204.tde.entity.xuan.XPatch;
import com.merlin204.tde.util.TDEAbilityUtils;
import java.util.Iterator;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Item.Properties;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;

public class MerlinSuperGG extends SwordItem {

   public MerlinSuperGG(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Properties pProperties) {
      super(pTier, pAttackDamageModifier, pAttackSpeedModifier, pProperties);
   }

   @NotNull
   public InteractionResultHolder m_7203_(@NotNull Level pLevel, @NotNull Player player, @NotNull InteractionHand pUsedHand) {
      ItemStack stack = player.m_21120_(pUsedHand);
      Level world = player.m_9236_();
      if(world instanceof ServerLevel) {
         ServerLevel serverLevel = (ServerLevel)world;
         float range = 20.0F;
         Vec3 playerPos = player.m_20318_(0.0F);
         AABB searchArea = new AABB(playerPos.f_82479_ - (double)range, playerPos.f_82480_ - (double)range, playerPos.f_82481_ - (double)range, playerPos.f_82479_ + (double)range, playerPos.f_82480_ + (double)range, playerPos.f_82481_ + (double)range);
         Iterator var10 = player.m_9236_().m_45976_(XEntity.class, searchArea).iterator();

         while(var10.hasNext()) {
            XEntity xEntity = (XEntity)var10.next();
            XPatch xPatch = (XPatch)EpicFightCapabilities.getEntityPatch(xEntity, XPatch.class);
            xPatch.playAnimationSynchronized(xEntity.getXAnimation(), 0.0F);
         }
      }

      TDEAbilityUtils.addAbility(AbilityType.SOUL, player, 1.0E8F);
      player.m_36335_().m_41524_(stack.m_41720_(), 20);
      return super.m_7203_(pLevel, player, pUsedHand);
   }
}
