package com.merlin204.tde.events;

import com.merlin204.tde.capabilitiy.player.TDEPlayerCapabilities;
import com.merlin204.tde.capabilitiy.player.ability.AbilityProvider;
import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.capabilitiy.player.ability.PlayerAbilities;
import com.merlin204.tde.capabilitiy.player.ability.PlayerAttribute;
import com.merlin204.tde.capabilitiy.player.campfiredata.CampfireDataProvider;
import com.merlin204.tde.capabilitiy.player.campfiredata.PlayerCampfireData;
import com.merlin204.tde.client.gui.TDEBossBar;
import com.merlin204.tde.client.gui.TDEHealthBar;
import com.merlin204.tde.effect.TDEMobEffect;
import com.merlin204.tde.entity.enemy.EnemyEntity;
import com.merlin204.tde.entity.player.TDELocalPlayerPatch;
import com.merlin204.tde.item.armor.TDEArmor;
import com.merlin204.tde.network.NetworkHandler;
import com.merlin204.tde.network.server.SyncCampfireDataPacket;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource.BufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameRules.BooleanValue;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent.BossEventProgress;
import net.minecraftforge.client.event.RenderLevelStageEvent.Stage;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingEvent.LivingTickEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent.Added;
import net.minecraftforge.event.entity.living.MobEffectEvent.Remove;
import net.minecraftforge.event.entity.player.PlayerEvent.Clone;
import net.minecraftforge.event.entity.player.PlayerEvent.PlayerLoggedInEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod.EventBusSubscriber;
import net.minecraftforge.fml.common.Mod.EventBusSubscriber.Bus;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;

@EventBusSubscriber(
   modid = "tde",
   bus = Bus.FORGE
)
public class ForgeModEvents {

   private static final TDEHealthBar HEALTH_BAR = new TDEHealthBar();


   @SubscribeEvent
   public static void onPlayerLogin(PlayerLoggedInEvent event) {
      event.getEntity().getCapability(TDEPlayerCapabilities.PLAYER_ABILITIES).ifPresent(event);
      GameRules rules = event.getEntity().m_9236_().m_46469_();
      event.getEntity().getCapability(TDEPlayerCapabilities.PLAYER_CAMPFIRE_DATA).ifPresent(event);
      ((BooleanValue)rules.m_46170_(GameRules.f_46139_)).m_46246_(false, event.getEntity().m_9236_().m_7654_());
   }

   @SubscribeEvent
   public static void onPlayerFall(LivingFallEvent event) {
      if(event.getEntity() instanceof Player) {
         Player player = (Player)event.getEntity();
         if(event.getDistance() >= 6.0F) {
            event.setCanceled(true);
            DamageSources damageSources = player.m_9236_().m_269111_();
            player.m_6469_(damageSources.m_268989_(), Float.MAX_VALUE);
            if(player.m_21223_() > 0.0F) {
               player.m_6074_();
            }
         }
      }

   }

   @SubscribeEvent
   public static void onAttachCapabilities(AttachCapabilitiesEvent event) {
      if(event.getObject() instanceof Player) {
         event.addCapability(new ResourceLocation("tde", "abilities"), new AbilityProvider());
         event.addCapability(new ResourceLocation("tde", "campfire_data"), new CampfireDataProvider());
      }

   }

   @SubscribeEvent
   public static void onPlayerClone(Clone event) {
      event.getOriginal().reviveCaps();
      event.getOriginal().getCapability(TDEPlayerCapabilities.PLAYER_ABILITIES).ifPresent(event);
      event.getOriginal().getCapability(TDEPlayerCapabilities.PLAYER_CAMPFIRE_DATA).ifPresent(event);
      event.getOriginal().invalidateCaps();
   }

   @SubscribeEvent
   public static void onLivingHurt(LivingHurtEvent event) {
      LivingEntity totalReduction = event.getEntity();
      if(totalReduction instanceof Player) {
         Player player = (Player)totalReduction;
         float var8 = 0.0F;
         int armorCount = 0;
         Iterator newAmount = player.m_6168_().iterator();

         while(newAmount.hasNext()) {
            ItemStack stack = (ItemStack)newAmount.next();
            Item var7 = stack.m_41720_();
            if(var7 instanceof TDEArmor) {
               TDEArmor armor = (TDEArmor)var7;
               var8 += armor.getDamageReduction();
               ++armorCount;
            }
         }

         if(var8 > 0.0F) {
            var8 = Math.min(var8, 0.95F);
            float var9 = event.getAmount() * (1.0F - var8);
            event.setAmount(var9);
         }

      }
   }

   public boolean isDamageable(ItemStack stack) {
      return false;
   }

   @SubscribeEvent
   public static void onRenderLevelStage(RenderLevelStageEvent event) {
      if(event.getStage() == Stage.AFTER_ENTITIES) {
         Minecraft mc = Minecraft.m_91087_();
         HEALTH_BAR.tick();
         HEALTH_BAR.remove();
         TDELocalPlayerPatch localPlayerPatch = (TDELocalPlayerPatch)EpicFightCapabilities.getEntityPatch(mc.f_91074_, TDELocalPlayerPatch.class);
         mc.f_91073_.m_104735_();
         mc.forEach(event);
      }

   }

   @SubscribeEvent
   public void onBossRender(BossEventProgress event) {
      if(TDEBossBar.renderBossBar(event.getGuiGraphics(), event.getBossEvent(), event.getX(), event.getY())) {
         event.setCanceled(true);
      }

   }

   private static void copyAbilities(PlayerAbilities oldAbilities, PlayerAbilities newAbilities) {
      AbilityType[] var2 = AbilityType.values();
      int var3 = var2.length;

      for(int var4 = 0; var4 < var3; ++var4) {
         AbilityType type = var2[var4];
         PlayerAttribute oldAttr = oldAbilities.get(type);
         PlayerAttribute newAttr = newAbilities.get(type);
         newAttr.set(oldAttr.get());
      }

   }

   public static void syncCampfireData(ServerPlayer player, PlayerCampfireData data) {
      NetworkHandler.sendToClient(new SyncCampfireDataPacket(data.serializeNBT()), player);
   }

   @SubscribeEvent
   public static void onEffectApplied(Added event) {
      MobEffect var2 = event.getEffectInstance().m_19544_();
      if(var2 instanceof TDEMobEffect) {
         TDEMobEffect tdeMobEffect = (TDEMobEffect)var2;
         tdeMobEffect.onApplied(event.getEntity());
      }

   }

   @SubscribeEvent
   public static void onEffectRemoved(Remove event) {
      MobEffect var2 = event.getEffectInstance().m_19544_();
      if(var2 instanceof TDEMobEffect) {
         TDEMobEffect tdeMobEffect = (TDEMobEffect)var2;
         tdeMobEffect.onRemoved(event.getEntity());
      }

   }

   @SubscribeEvent
   public static void onEffectTick(LivingTickEvent event) {
      Iterator var1 = event.getEntity().m_21220_().iterator();

      while(var1.hasNext()) {
         MobEffectInstance mobEffectInstance = (MobEffectInstance)var1.next();
         MobEffect var4 = mobEffectInstance.m_19544_();
         if(var4 instanceof TDEMobEffect) {
            TDEMobEffect tdeMobEffect = (TDEMobEffect)var4;
            tdeMobEffect.tick(event.getEntity());
         }
      }

   }

   // $FF: synthetic method
   private static void lambda$onRenderLevelStage$6(TDELocalPlayerPatch localPlayerPatch, Minecraft mc, RenderLevelStageEvent event, Entity entity) {
      if(entity instanceof EnemyEntity) {
         EnemyEntity enemyEntity = (EnemyEntity)entity;
         if(HEALTH_BAR.shouldDraw(enemyEntity, enemyEntity.getEnemyPatch(), localPlayerPatch, mc.m_91296_())) {
            PoseStack poseStack = event.getPoseStack();
            BufferSource buffer = mc.m_91269_().m_110104_();
            buffer.m_109911_();
         }
      }

   }

   // $FF: synthetic method
   private static void lambda$onPlayerClone$5(Clone event, PlayerCampfireData oldData) {
      event.getEntity().getCapability(TDEPlayerCapabilities.PLAYER_CAMPFIRE_DATA);
      oldData.ifPresent(event);
   }

   // $FF: synthetic method
   private static void lambda$onPlayerClone$4(PlayerCampfireData oldData, Clone event, PlayerCampfireData newData) {
      newData.deserializeNBT(oldData.serializeNBT());
      syncCampfireData((ServerPlayer)event.getEntity(), newData);
   }

   // $FF: synthetic method
   private static void lambda$onPlayerClone$3(Clone event, PlayerAbilities oldAbilities) {
      event.getEntity().getCapability(TDEPlayerCapabilities.PLAYER_ABILITIES);
      oldAbilities.ifPresent(event);
   }

   // $FF: synthetic method
   private static void lambda$onPlayerClone$2(PlayerAbilities oldAbilities, Clone event, PlayerAbilities newAbilities) {
      copyAbilities(oldAbilities, newAbilities);
      newAbilities.syncToClient((ServerPlayer)event.getEntity());
   }

   // $FF: synthetic method
   private static void lambda$onPlayerLogin$1(PlayerLoggedInEvent event, PlayerCampfireData data) {
      syncCampfireData((ServerPlayer)event.getEntity(), data);
   }

   // $FF: synthetic method
   private static void lambda$onPlayerLogin$0(PlayerLoggedInEvent event, PlayerAbilities abilities) {
      abilities.syncToClient(event.getEntity());
   }

}
