package com.merlin204.tde.events;

import com.merlin204.tde.entity.enemy.EnemyEntity;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Entity.RemovalReason;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent.Phase;
import net.minecraftforge.event.TickEvent.ServerTickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod.EventBusSubscriber;
import net.minecraftforge.fml.common.Mod.EventBusSubscriber.Bus;

@EventBusSubscriber(
   modid = "tde",
   bus = Bus.FORGE
)
public class EntityCleanerSystem {

   public static final Predicate ENEMY_FILTER;
   private static final Map activeTasks;


   public static void startEntityClearing(ServerPlayer player, BlockPos centerPos, Predicate entityFilter, Runnable onComplete) {
      if(activeTasks.containsKey(player)) {
         player.m_213846_(Component.m_237113_("已有进行中的清除任务"));
      } else {
         EntityCleanerSystem.EntityCleanerTask task = new EntityCleanerSystem.EntityCleanerTask(player, centerPos, entityFilter, onComplete);
         activeTasks.put(player, task);
         task.start();
      }
   }

   @SubscribeEvent
   public static void onServerTick(ServerTickEvent event) {
      if(event.phase == Phase.END) {
         ArrayList toRemove = new ArrayList();
         Iterator var2 = activeTasks.entrySet().iterator();

         while(var2.hasNext()) {
            Entry player = (Entry)var2.next();
            EntityCleanerSystem.EntityCleanerTask task = (EntityCleanerSystem.EntityCleanerTask)player.getValue();
            task.tick();
            if(task.isComplete()) {
               toRemove.add((Player)player.getKey());
            }
         }

         var2 = toRemove.iterator();

         while(var2.hasNext()) {
            Player player1 = (Player)var2.next();
            activeTasks.remove(player1);
         }
      }

   }

   private static void setRenderDistance(ServerPlayer player, int distance) {
      MinecraftServer server = player.f_8924_;
      PlayerList playerList = server.m_6846_();
      playerList.m_11217_(distance);
      setClientRenderDistance(player, distance);
   }

   private static void forceLoadChunks(ServerPlayer player, int radius) {
      BlockPos center = player.m_20183_();
      ServerLevel level = (ServerLevel)player.m_9236_();

      for(int x = -radius; x <= radius; ++x) {
         for(int z = -radius; z <= radius; ++z) {
            BlockPos pos = center.m_7918_(x * 16, 0, z * 16);
            level.m_7726_().m_62227_(pos.m_123341_() >> 4, pos.m_123343_() >> 4, true);
         }
      }

   }

   @OnlyIn(Dist.CLIENT)
   private static void setClientRenderDistance(Player player, int distance) {
      Minecraft minecraft = Minecraft.m_91087_();
      if(minecraft.f_91074_ != null && minecraft.f_91074_.m_20148_().equals(player.m_20148_())) {
         minecraft.execute((Runnable)distance);
      }

   }

   // $FF: synthetic method
   private static void lambda$setClientRenderDistance$1(Minecraft minecraft, int distance) {
      Options options = minecraft.f_91066_;
      options.m_231984_().m_231514_(Integer.valueOf(Math.min(32, Math.max(2, distance))));
      minecraft.f_91060_.m_109818_();
   }

   // $FF: synthetic method
   private static boolean lambda$static$0(Entity entity) {
      return entity instanceof EnemyEntity;
   }

   static {
      // $FF: Couldn't be decompiled
   }

   public static class EntityCleanerTask {

      private final ServerPlayer player;
      private final Predicate entityFilter;
      private final int requiredChunks;
      private int originalDistance;
      private int loadedChunks = 0;
      private int ticks = 0;
      private boolean isComplete = false;
      private final BlockPos centerPos;
      private final Runnable onComplete;


      public EntityCleanerTask(ServerPlayer player, BlockPos centerPos, Predicate entityFilter, Runnable onComplete) {
         this.player = player;
         this.centerPos = centerPos;
         this.entityFilter = entityFilter;
         this.onComplete = onComplete;
         byte radius = 32;
         this.requiredChunks = (radius * 2 + 1) * (radius * 2 + 1);
      }

      public void start() {
         this.originalDistance = this.player.f_8924_.m_6846_().m_11312_();
         EntityCleanerSystem.setRenderDistance(this.player, 32);
         EntityCleanerSystem.forceLoadChunks(this.player, 32);
      }

      public void tick() {
         ++this.ticks;
         if(this.ticks % 10 == 0) {
            this.checkChunkLoadingProgress();
         }

         if(this.loadedChunks >= this.requiredChunks && !this.isComplete) {
            this.clearEntities();
            this.restoreRenderDistance();
            this.isComplete = true;
            if(this.onComplete != null) {
               this.onComplete.run();
            }
         }

      }

      private void checkChunkLoadingProgress() {
         BlockPos center = this.centerPos;
         ServerLevel level = (ServerLevel)this.player.m_9236_();
         byte radius = 32;
         int count = 0;

         for(int x = -radius; x <= radius; ++x) {
            for(int z = -radius; z <= radius; ++z) {
               BlockPos pos = center.m_7918_(x * 16, 0, z * 16);
               if(level.m_7726_().m_5563_(pos.m_123341_() >> 4, pos.m_123343_() >> 4)) {
                  ++count;
               }
            }
         }

         this.loadedChunks = count;
      }

      private void clearEntities() {
         double range = 512.0D;
         BlockPos center = this.centerPos;
         ServerLevel level = (ServerLevel)this.player.m_9236_();
         int minY = level.m_141937_();
         int maxY = level.m_151558_();
         AABB area = new AABB((double)center.m_123341_() - range, (double)minY, (double)center.m_123343_() - range, (double)center.m_123341_() + range, (double)maxY, (double)center.m_123343_() + range);
         ArrayList toRemove = new ArrayList();
         Iterator var9 = this.player.m_9236_().m_45933_(this.player, area).iterator();

         Entity entity;
         while(var9.hasNext()) {
            entity = (Entity)var9.next();
            if(this.entityFilter.test(entity)) {
               toRemove.add(entity);
            }
         }

         var9 = toRemove.iterator();

         while(var9.hasNext()) {
            entity = (Entity)var9.next();
            entity.m_142687_(RemovalReason.DISCARDED);
         }

      }

      private void restoreRenderDistance() {
         EntityCleanerSystem.setRenderDistance(this.player, this.originalDistance);
      }

      public boolean isComplete() {
         return this.isComplete;
      }
   }
}
