package com.merlin204.tde.events;

import com.merlin204.tde.block.respawncampfireblock.FireBlockRegister;
import com.merlin204.tde.client.particle.TDEAnimationTrailParticle.Provider;
import com.merlin204.tde.item.uesItem.skillbook.SkillBookItems;
import com.merlin204.tde.particle.TDEParticles;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.ModelEvent.ModifyBakingResult;
import net.minecraftforge.client.event.ModelEvent.RegisterAdditional;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod.EventBusSubscriber;
import net.minecraftforge.fml.common.Mod.EventBusSubscriber.Bus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.RegistryObject;
import yesman.epicfight.api.client.forgeevent.PatchedRenderersEvent.RegisterItemRenderer;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;

@EventBusSubscriber(
   modid = "tde",
   bus = Bus.MOD,
   value = {Dist.CLIENT}
)
public class ClientModEvents {

   private static final ModelResourceLocation COMMON_MODEL = new ModelResourceLocation(new ResourceLocation("tde", "skill_book"), "inventory");


   @SubscribeEvent
   public static void onClientSetup(FMLClientSetupEvent param0) {
      // $FF: Couldn't be decompiled
   }

   @SubscribeEvent
   public static void registerAdditionalModels(RegisterAdditional event) {
      event.register(COMMON_MODEL);
   }

   @SubscribeEvent
   public static void onModelBaking(ModifyBakingResult event) {
      Map modelRegistry = event.getModels();
      BakedModel commonBakedModel = (BakedModel)modelRegistry.get(COMMON_MODEL);
      if(commonBakedModel != null) {
         Iterator var3 = SkillBookItems.ALL_SKILL_BOOKS.iterator();

         while(var3.hasNext()) {
            RegistryObject bookReg = (RegistryObject)var3.next();
            ResourceLocation itemId = bookReg.getId();
            ModelResourceLocation itemModelLoc = new ModelResourceLocation(itemId, "inventory");
            modelRegistry.put(itemModelLoc, commonBakedModel);
         }
      }

   }

   @SubscribeEvent(
      priority = EventPriority.LOWEST
   )
   public static void onParticleRegistry(RegisterParticleProvidersEvent event) {
      event.registerSpecial((ParticleType)TDEParticles.TDE_TRAIL.get(), new Provider());
      event.registerSpecial((ParticleType)TDEParticles.TDE_ENTITY_AFTER_IMAGE.get(), new com.merlin204.tde.client.particle.TDEEntityAfterImageParticle.Provider());
      event.registerSpecial((ParticleType)TDEParticles.TDE_SCALE_ENTITY_AFTER_IMAGE.get(), new com.merlin204.tde.client.particle.TDEScaleEntityAfterImageParticle.Provider());
   }

   @SubscribeEvent
   public static void registerRenderers(RegisterItemRenderer param0) {
      // $FF: Couldn't be decompiled
   }

   // $FF: synthetic method
   private static void lambda$onClientSetup$2() {
      ItemBlockRenderTypes.setRenderLayer((Block)FireBlockRegister.TEST_CAMPFIRE.get(), RenderType.m_110463_());
      ItemBlockRenderTypes.setRenderLayer((Block)FireBlockRegister.S1_1.get(), RenderType.m_110463_());
   }

   // $FF: synthetic method
   private static Supplier lambda$onClientSetup$1(Entity param0) {
      // $FF: Couldn't be decompiled
   }

   // $FF: synthetic method
   private static EntityPatch lambda$onClientSetup$0() {
      return null;
   }

}
