package com.merlin204.tde.events;

import com.merlin204.tde.item.weapon.TDEWeaponItem;
import com.merlin204.tde.item.weapon.TDEWeaponItemProperties;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod.EventBusSubscriber;
import net.minecraftforge.fml.common.Mod.EventBusSubscriber.Bus;

@EventBusSubscriber(
   modid = "tde",
   bus = Bus.FORGE,
   value = {Dist.CLIENT}
)
public class ClientForgeModEvents {

   @SubscribeEvent
   public static void onTooltip(ItemTooltipEvent event) {
      Item props = event.getItemStack().m_41720_();
      if(props instanceof TDEWeaponItem) {
         TDEWeaponItem item = (TDEWeaponItem)props;
         TDEWeaponItemProperties props1 = item.getProperties();
         ArrayList customLines = new ArrayList();
         customLines.add(Component.m_237113_("=================="));
         customLines.add(Component.m_237115_("tooltip.tde.weight").m_130940_(ChatFormatting.GOLD).m_7220_(Component.m_237113_(": ")).m_7220_(Component.m_237113_(String.valueOf(props1.getWeight())).m_130940_(ChatFormatting.WHITE)));
         customLines.add(Component.m_237115_("tooltip.tde.weapon_type").m_130940_(ChatFormatting.GRAY).m_7220_(Component.m_237113_(" ➔ ").m_130940_(ChatFormatting.DARK_GRAY)).m_7220_(Component.m_237115_(props1.getWeaponType().getTranslationKey()).m_130940_(ChatFormatting.DARK_AQUA)));
         customLines.add(Component.m_237113_("=================="));
         int insertIndex = findInsertPosition(event.getToolTip());
         event.getToolTip().addAll(insertIndex, customLines);
      }

   }

   private static int findInsertPosition(List tooltip) {
      for(int i = 0; i < tooltip.size(); ++i) {
         Component line = (Component)tooltip.get(i);
         if(line.getString().contains("Durability")) {
            return i + 1;
         }
      }

      return Math.max(1, tooltip.size() - 1);
   }
}
