package com.merlin204.tde.epicfight.gameassets.skill.soulfire;

import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.entity.player.TDELocalPlayerPatch;
import com.merlin204.tde.entity.player.TDEServerPlayerPatch;
import com.merlin204.tde.epicfight.animations.player.ExecuteAnimation;
import com.merlin204.tde.epicfight.gameassets.skill.soulfire.SoulfireSkill;
import com.merlin204.tde.epicfight.skill.TDESkillSlots;
import com.merlin204.tde.util.TDEAbilityUtils;
import com.merlin204.tde.util.TDEEventUtils;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.animation.AnimationManager.AnimationAccessor;
import yesman.epicfight.api.animation.AnimationManager.AnimationBuilder;
import yesman.epicfight.api.animation.property.AnimationEvent;
import yesman.epicfight.api.animation.property.AnimationParameters;
import yesman.epicfight.api.animation.property.AnimationEvent.Event;
import yesman.epicfight.api.animation.property.AnimationEvent.InPeriodEvent;
import yesman.epicfight.api.animation.property.AnimationEvent.InTimeEvent;
import yesman.epicfight.api.animation.property.AnimationEvent.Side;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.utils.AttackResult.ResultType;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.gameasset.Armatures.ArmatureAccessor;
import yesman.epicfight.model.armature.HumanoidArmature;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class SoulfireSkillAnimations {

   public static AnimationAccessor SOULFIRE_1;
   public static AnimationAccessor SOULFIRE_1_EXCUTE;


   public static void buildSoulfireSkillAnimations(AnimationBuilder builder) {
      ArmatureAccessor biped = Armatures.BIPED;
      SOULFIRE_1 = builder.nextAccessor("biped/skill/soulfire/soulfire_1", biped);
      SOULFIRE_1_EXCUTE = builder.nextAccessor("biped/skill/soulfire/soulfire_1_execute", biped);
   }

   private static InTimeEvent addHealth(int startFrame, float addRatio) {
      float start = (float)startFrame / 60.0F;
      return InTimeEvent.create(start, (Event)addRatio, Side.SERVER);
   }

   private static InPeriodEvent setCooldown(int param0, int param1) {
      // $FF: Couldn't be decompiled
   }

   // $FF: synthetic method
   private static void lambda$setCooldown$4(LivingEntityPatch entityPatch, AssetAccessor self, AnimationParameters params) {
      if(entityPatch instanceof TDELocalPlayerPatch) {
         TDELocalPlayerPatch tdeLocalPlayerPatch = (TDELocalPlayerPatch)entityPatch;
         Skill patt5050$temp = tdeLocalPlayerPatch.getSkill(TDESkillSlots.SOULFIRE).getSkill();
         if(patt5050$temp instanceof SoulfireSkill) {
            SoulfireSkill soulfireSkill = (SoulfireSkill)patt5050$temp;
            soulfireSkill.setCoolDown(tdeLocalPlayerPatch, 20);
         }
      }

   }

   // $FF: synthetic method
   private static void lambda$addHealth$3(float addRatio, LivingEntityPatch entityPatch, AssetAccessor self, AnimationParameters params) {
      if(entityPatch instanceof TDEServerPlayerPatch) {
         TDEServerPlayerPatch serverPlayerPatch = (TDEServerPlayerPatch)entityPatch;
         ((ServerPlayer)serverPlayerPatch.getOriginal()).m_5634_(((ServerPlayer)serverPlayerPatch.getOriginal()).m_21233_() * addRatio);
         TDEAbilityUtils.subAbility(AbilityType.SOULFIRE, (Player)serverPlayerPatch.getOriginal(), 1.0F);
      }

   }

   // $FF: synthetic method
   private static ExecuteAnimation lambda$buildSoulfireSkillAnimations$2(ArmatureAccessor param0, AnimationAccessor param1) {
      // $FF: Couldn't be decompiled
   }

   // $FF: synthetic method
   private static ResultType lambda$buildSoulfireSkillAnimations$1(DamageSource damagesource) {
      return ResultType.MISSED;
   }

   // $FF: synthetic method
   private static StaticAnimation lambda$buildSoulfireSkillAnimations$0(ArmatureAccessor biped, AnimationAccessor accessor) {
      return (new StaticAnimation(0.15F, false, accessor, biped)).addEvents(new AnimationEvent[]{setCooldown(0, 250), addHealth(35, 0.5F), TDEEventUtils.allBackTime(0, 250), TDEEventUtils.simpleCameraShake(35, 25, 10.0F, 0.4F, 5.0F), TDEEventUtils.creatSimpleFxEvent(35, "photon:soulfire/soulfire_1_boom", ((HumanoidArmature)biped.get()).toolR, 20, false), TDEEventUtils.simpleSound(10, SoundEvents.f_11936_, 5.0F, 1.0F), TDEEventUtils.simpleSound(35, SoundEvents.f_11874_, 5.0F, 1.0F), TDEEventUtils.fxTrail(0, 34, ((HumanoidArmature)biped.get()).toolR, Vec3.f_82478_, Vec3.f_82478_, 2.0F, 1, "photon:soulfire/soulfire_1", 0.0F)});
   }
}
