package com.merlin204.tde.epicfight.gameassets.skill.sect.se1.se1_2;

import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.epicfight.api.animation.TDELivingMotions;
import com.merlin204.tde.epicfight.gameassets.skill.sect.se1.SE1Sect;
import com.merlin204.tde.epicfight.gameassets.skill.sect.se1.se1_2.SE1_2Animations;
import com.merlin204.tde.item.weapon.TDEWeaponType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.sounds.SoundEvent;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.AnimationManager.AnimationAccessor;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.skill.SkillBuilder;

public class SE1_2Sect extends SE1Sect {

   public SE1_2Sect(SkillBuilder builder) {
      super(builder);
   }

   public String getId() {
      return "2";
   }

   protected List getBuiltInAttacks() {
      return List.of(SE1_2Animations.ATK_1, SE1_2Animations.ATK_2, SE1_2Animations.ATK_3, SE1_2Animations.ATK_4);
   }

   protected Map createLivingAnimations() {
      HashMap map = new HashMap();
      map.put(LivingMotions.IDLE, SE1_2Animations.IDLE);
      map.put(TDELivingMotions.TDE_WALK, SE1_2Animations.WALK);
      map.put(TDELivingMotions.TDE_SNEAK, SE1_2Animations.SNEAK);
      map.put(TDELivingMotions.TDE_KNEEL, SE1_2Animations.KNEE);
      map.put(TDELivingMotions.TDE_RUN, SE1_2Animations.RUN);
      return map;
   }

   public SoundEvent getPerfectBlockSound() {
      return (SoundEvent)EpicFightSounds.CLASH.get();
   }

   public SoundEvent getBlockSound() {
      return (SoundEvent)EpicFightSounds.CLASH.get();
   }

   public AnimationAccessor getGuardHitAnimations(int levelDifference) {
      AnimationAccessor var10000;
      switch(levelDifference) {
      case 0:
         var10000 = SE1_2Animations.BLOCK_3;
         break;
      case 1:
         var10000 = SE1_2Animations.BLOCK_2;
         break;
      default:
         var10000 = SE1_2Animations.BLOCK_1;
      }

      return var10000;
   }

   public int getDefendLevel() {
      return 3;
   }

   public AnimationAccessor getGuardBrokenAnimations() {
      return SE1_2Animations.BLOCK_BROKEN;
   }

   public AnimationAccessor getPerfectGuardAnimations() {
      return SE1_2Animations.BLOCK_PERFECT;
   }

   public AnimationAccessor getDashAtkAnimations() {
      return SE1_2Animations.RUN_ATK;
   }

   public AnimationAccessor getGuardAnimation() {
      return SE1_2Animations.BLOCK;
   }

   public AnimationAccessor getChargingAnimation() {
      return SE1_2Animations.CHARGE;
   }

   public AnimationAccessor getChargingAttackAnimation() {
      return SE1_2Animations.CHARGE_ATK;
   }

   public AnimationAccessor getFullChargingAttackAnimation() {
      return SE1_2Animations.FULL_CHARGE_ATK;
   }

   public Map getAbilityRequirements() {
      HashMap requirements = new HashMap();
      requirements.put(AbilityType.STRENGTH, Float.valueOf(5.0F));
      requirements.put(AbilityType.DEXTERITY, Float.valueOf(12.0F));
      requirements.put(AbilityType.STAMINA, Float.valueOf(4.0F));
      requirements.put(AbilityType.VITALITY, Float.valueOf(3.0F));
      return requirements;
   }

   public float getMaxWeight() {
      return 15.0F;
   }

   public Set getMainAllowed() {
      return Set.of(TDEWeaponType.SWORD, TDEWeaponType.DAGGER);
   }

   public Set getOffAllowed() {
      return Set.of(TDEWeaponType.SWORD, TDEWeaponType.DAGGER, TDEWeaponType.HATCHET);
   }
}
